

import java.lang.reflect.InvocationTargetException;

public class TurnIndicatorSystem {

	public static Class SUTClass = null;
	public static Object SUT = null;
	public static String[] tokens = null;
	
	public int systemTime;
	
	public int oldVoltage;
	public boolean oldEmergency;
	public int oldTurnIndicator;
	
	public int voltage;
	public boolean emergency;
	public int turnIndicator;

	public int oldFlashingMode;
	
	public int flashingMode;
	public int newFlashingMode;
	
	public int flashingCounter;
	public int newFlashingCounter;
	
	public int flashingTimer;
	public int newFlashingTimer;
	
	public boolean leftFlashing;
	public boolean newLeftFlashing;
	
	public boolean rightFlashing;
	public boolean newRightFlashing;
	
	private void updateOldInputs() {
		this.oldVoltage = this.voltage;
		this.oldEmergency = this.emergency;
		this.oldTurnIndicator = this.turnIndicator;
		this.oldFlashingMode = this.flashingMode;
		
		this.voltage = Integer.parseInt(tokens[1]);
		
		if ( tokens[2].equals("off") ) {
			this.emergency = false;
		} else {
			this.emergency = true;
		}

		if ( tokens[3].equals("idle") ) {
			this.turnIndicator = 0;
		} else if ( tokens[3].equals("left") ) {
			this.turnIndicator = 1;
		} else {
			this.turnIndicator = 2;
		}		
	}
	
	private boolean memoryChanged() {
		if ( flashingMode != newFlashingMode || flashingCounter != newFlashingCounter ||
				flashingTimer != newFlashingTimer || leftFlashing != newLeftFlashing ||
				rightFlashing != newRightFlashing ) {
			this.updateMemory();
			return true;
		}
		return false;
	}
	
	private void updateMemory() {
		flashingMode = newFlashingMode;
		flashingCounter = newFlashingCounter;
		flashingTimer = newFlashingTimer;
		leftFlashing = newLeftFlashing;
		rightFlashing = newRightFlashing;
	}	
	
	public void lightsComponent() {
		if ( oldVoltage > 80 && voltage <= 80 ) {
			newLeftFlashing = false;
			newRightFlashing = false;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;
		} else if ( voltage > 80 ) {
			if ( flashingMode == 0 && (oldFlashingMode != 0 || oldVoltage <= 80) ) {
				newLeftFlashing = true;
				newRightFlashing = false;
				newFlashingCounter = 0;
				newFlashingTimer = systemTime;
			} 
			if ( flashingMode == 1 && (oldFlashingMode != 1 || oldVoltage <= 80) ) {
				newLeftFlashing = false;
				newRightFlashing = true;
				newFlashingCounter = 0;
				newFlashingTimer = systemTime;
			}
			if ( flashingMode == 2 && (oldFlashingMode != 2 || oldVoltage <= 80) ) {
				newLeftFlashing = true;
				newRightFlashing = true;
				newFlashingCounter = 0;
				newFlashingTimer = systemTime;	
			} 					

			if ( flashingMode == 3 ) {
				newLeftFlashing = false;
				newRightFlashing = false;
				newFlashingCounter = 0;
				newFlashingTimer = systemTime;	
			}
			
			if ( (systemTime-flashingTimer)>=340 && (leftFlashing==true || rightFlashing==true) ) {
				newLeftFlashing = false;
				newRightFlashing = false;
				newFlashingCounter = flashingCounter + 1;
				newFlashingTimer = systemTime;					
			}
			
			if ( (systemTime-flashingTimer)>=220 && leftFlashing==false && rightFlashing==false ) {
				if ( flashingMode == 0 || flashingMode == 4 ) {
					newLeftFlashing = true;
					newRightFlashing = false;
					newFlashingTimer = systemTime;
				}
				if ( flashingMode == 1 || flashingMode == 5 ) {
					newLeftFlashing = false;
					newRightFlashing = true;
					newFlashingTimer = systemTime;					
				}
				if ( flashingMode == 2 ) {
					newLeftFlashing = true;
					newRightFlashing = true;
					newFlashingTimer = systemTime;					
				}
			}
		}
	}
	
	public void flashingComponent() {
		if ( turnIndicator == 1 && oldTurnIndicator != 1 && emergency == false ) {
			newFlashingMode = 0;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}

		if ( turnIndicator == 2 && oldTurnIndicator != 2 && emergency == false ) {
			newFlashingMode = 1;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}
		
		if ( emergency == true && oldEmergency != true ) {
			newFlashingMode = 2;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}

		if ( emergency == true && oldEmergency == true && turnIndicator == 1 && oldTurnIndicator != 1 ) {
			newFlashingMode = 0;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}		
		
		if ( emergency == true && oldEmergency == true && turnIndicator == 2 && oldTurnIndicator != 2 ) {
			newFlashingMode = 1;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}		
		
		if ( emergency == true && oldEmergency == true && turnIndicator == 0 && 
				oldTurnIndicator != 0 && flashingMode != 2
		) {
			newFlashingMode = 2;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}		

		if ( emergency == false && oldEmergency != false && turnIndicator == 1 && 
				oldTurnIndicator == 1 && flashingMode != 0
				) {
			newFlashingMode = 0;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}
		
		if ( emergency == false && oldEmergency != false && turnIndicator == 2 &&
				oldTurnIndicator == 2 && flashingMode != 1 ) {
			newFlashingMode = 1;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}
		
		if ( emergency == false && oldEmergency == false && flashingCounter < 3 && turnIndicator == 0 && oldTurnIndicator == 1 ) {
			newFlashingMode = 4;
		}

		if ( emergency == false && oldEmergency == false && flashingCounter < 3 && turnIndicator == 0 && oldTurnIndicator == 2 ) {
			newFlashingMode = 5;
		}

		if ( flashingCounter >= 3 && (flashingMode == 4 || flashingMode == 5) ) {
			newFlashingMode = 3;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;				
		}
		
		if ( turnIndicator == 0 && emergency == false && (oldTurnIndicator == 0 || flashingCounter >= 3)
			 && flashingMode != 4 && flashingMode != 5 ) {
			newFlashingMode = 3;
			newFlashingCounter = 0;
			newFlashingTimer = systemTime;	
		}
	}
	
	public void simulateDiscreteStep() {
		updateOldInputs();
		
		do {
			Thread thread1 = new Thread() {
				public void run() {
					try {
						SUTClass.getMethod("lightsComponent").invoke(SUT);
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
					} catch (SecurityException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					} catch (InvocationTargetException e) {
						e.printStackTrace();
					} catch (NoSuchMethodException e) {
						e.printStackTrace();
					}
				}
			};
			Thread thread2 = new Thread() {
				public void run() { 
					try {
						SUTClass.getMethod("flashingComponent").invoke(SUT);
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
					} catch (SecurityException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					} catch (InvocationTargetException e) {
						e.printStackTrace();
					} catch (NoSuchMethodException e) {
						e.printStackTrace();
					}
				}
			};
            
			thread1.start();
			thread2.start();
			
			try {
				thread1.join();
				thread2.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}		
		} while ( memoryChanged() == true );
	}	
	
}
