// Filename of the map currently added
String mapname;
// The map currently edited
Map map;


// x and y index of the block shown at 0,0 on the screen
int leftBlock, topBlock;
// current level element
int cursorX, cursorY;

// opens a new map with a file input dialog
void openMap() {
  mapname = selectInput ("Open block-level map file");
  Map newMap=null;
  if (mapname!=null && !mapname.equals("")) newMap = new Map(mapname);
  if (newMap!=null) {
    map = newMap;
    leftBlock = topBlock = cursorX  = cursorY = 0;
  }
}

// saves the current map into a new file
void saveAsMap() {
  mapname = selectOutput ("Save block-level map file as");
  if (mapname!=null && !mapname.equals("")) map.saveFile (mapname);
}

// saves the current map to the current file
void saveMap () {
  if (mapname==null) saveAsMap();
  else map.saveFile (mapname);
}

void newMap () {
  mapname = selectOutput ("Save new block-level map file as");
  if (mapname==null || mapname.equals("")) exit();
  else {
    String[] emptyMapAsStrings = {"_"};
    saveStrings (mapname, emptyMapAsStrings);
    map = new Map (mapname);
  }
}

void setup()
{
  size( 800, 600 );
  openMap();
}

void keyPressed () {
  if (keyCode==LEFT) cursorX--;
  else if (keyCode==RIGHT) cursorX++;
  else if (keyCode==UP) cursorY--;
  else if (keyCode==DOWN) cursorY++;
  else if (key==' ' || key=='_' || ('A'<=key && key<='Z')) map.set (cursorX, cursorY, key);
  else if ('a'<=key && key<='z') map.set (cursorX, cursorY, char('A'+(key-'a')));
  else if (key==15) openMap(); // CTRL-O
  else if (key==19) saveMap(); // CTRL-S
  else if (key==14) newMap(); // CTRL-N
  else if (key==1) saveAsMap(); // CTRL-A
  else println ("key="+key+" "+int(key));
  
  // No negative indices  
  if (cursorX<0) cursorX=0;
  if (cursorY<0) cursorY=0;
  
  // Scroll with cursor
  int scrollStep=3;
  if (cursorX<leftBlock-scrollStep) leftBlock=cursorX-scrollStep;
  if (cursorX-width/map.elementSize+scrollStep>leftBlock) leftBlock=cursorX-width/map.elementSize+scrollStep;
  if (cursorY<topBlock-scrollStep) topBlock=cursorY-scrollStep;
  if (cursorY-height/map.elementSize+scrollStep>topBlock) topBlock=cursorY-height/map.elementSize+scrollStep;
  
  if (leftBlock<0) leftBlock=0;
  if (topBlock<0) topBlock=0;
}

void drawCursor () {
  stroke (255);
  fill (0,0,0,128);
  rect ((cursorX-leftBlock)*map.elementSize, (cursorY-topBlock)*map.elementSize, map.elementSize, map.elementSize);
}

void drawTextInfo () {
  fill (255);
  textSize (12);
  textAlign (LEFT, TOP);
  text ("New CTRL-N   Open CTRL-O   Save CTRL-S   Save as CTRL-A\n"+
  "("+cursorX+"/"+cursorY+") ["+map.at(cursorX, cursorY)+"] "+mapname, 0,0 );
}

void draw () {
  background (128);
  map.draw (leftBlock*map.elementSize, topBlock*map.elementSize);  
  drawTextInfo();
  drawCursor ();
}
