Map map;
// Position of player center in level coordinates
float playerX = 0, playerY = 0;
// Velocity of player
float vx = 0, vy = 0;
// Speed at which the player moves
float speed = 200;
// Both width and height of the player
float playerR = 20;

double time;
boolean gameRunning = true;

void setup()
{
  size( 500, 500 );
  
  time=0;
  restart();  
  ellipseMode(CENTER);
}

void restart () {
  map = new Map( "demo.map");
  for ( int x = 0; x < map.w; ++x )
  {
    for ( int y = 0; y < map.h; ++y )
    {
      if ( map.at(x, y) == 'S' )
      {
        playerX = map.elementSize * x + map.elementSize/2;
        playerY = map.elementSize * y + map.elementSize/2;
        map.set(x, y, 'A');
      }
    }
  }
  vx = 0;
  vy = 0;
}

void updatePlayer()
{
  // update speed
  if ( keyPressed )
  {
    if ( keyCode == UP && vy == 0 )
    {
      vy = -speed;
      vx = 0;
    }
    else if ( keyCode == DOWN && vy == 0 )
    {
      vy = speed;
      vx = 0;
    }
    else if ( keyCode == LEFT && vx == 0 )
    {
      vx = -speed;
      vy = 0;
    }
    else if ( keyCode == RIGHT && vx == 0 )
    {
      vx = speed;
      vy = 0;
    }
  }
  
  // update player
  float nextX = playerX + vx/frameRate, 
        nextY = playerY + vy/frameRate;
  if ( map.testCharacterInRect( nextX, nextY, playerR, playerR, "W_" ) )
  {
    vx = -vx;
    vy = -vy;
  }
  else if ( map.testCharacterInRect( nextX, nextY, playerR, playerR, "H" ) )
  {
    restart();
  }
  else if ( map.testCharacterFullyInsideRect( nextX, nextY, playerR, playerR, "E" ) )
  {
    gameRunning = false;
  }
  
  playerX = playerX + vx/frameRate;
  playerY = playerY + vy/frameRate;
}


void drawGame()
{   
  // draw map
  background(128);
  float offsetX = playerX - width/2,
        offsetY = (map.heightPixel() - height)/2;
  map.draw( offsetX, offsetY );

  // draw player
  noStroke();
  fill(0, 255, 255);
  ellipse( playerX - offsetX, playerY - offsetY, playerR, playerR );  
}


void drawWin()
{
  background(0);
  textAlign(CENTER, CENTER);
  fill(255, 0, 0);
  
  textSize(60);  
  text("Won!", width/2, height/2);
  textSize(20);
  text("You needed " + time + " seconds", width/2, height/2 + 60);
}


void draw()
{
  if ( gameRunning )
  {
    updatePlayer();
    time+=1/frameRate;
    drawGame();
  }
  else
  {
    drawWin();
  }
}





