# *****************************************************
# For a first glance ignore everything between here....
#
require "pp"
class Song
  def initialize (name)
    @name = name
  end
  def name
    @name
  end
end
#
# .... and here
# *****************************************************
print "******* Hello World *********"
puts

puts "******** Ausdrücke *********"
puts 7+5
puts 5*(9+4)-17
puts 3.14*1.05


puts "******** Variablen ******"
x = 7+3
puts x
y = -100
puts 3*(x+y)
y = 10
puts 3*(x+y)

puts "******** Objekte werden mit Klasse.new erstellt *******"
song1 = Song.new("Ruby Tuesday")
song2 = Song.new("Enveloped in Python")

puts "******** Auf Objekten kann man Methoden aufrufen"
puts song1.name
puts "gin joint".length
puts "Rick".index("c")
puts -1942.abs
puts "ABCde".downcase

puts "******** Eine Methode definieren *********"

def say_goodnight(name)
  result = "Good night, " + name + "."
  return result
end

puts say_goodnight("udo")
puts say_goodnight("tobias")

puts "Zeile1\nZeile2"
puts "/ und \\"

def say_goodnight(name)
  result = "Good night, #{name}."
  return result
end

puts say_goodnight("udo")

def say_goodnight(name)
  result = "Good night, #{name.capitalize}."
  return result
end

puts say_goodnight("udo")

def say_goodnight(name)
  "Good night, #{name.capitalize}."
end

puts say_goodnight("udo")

puts "******* Arrays and Hashes *********"

a = [1, "cat", 3.14]
puts a[0]
a[2] = nil
pp a

inst_section = {
  "cello" => "string",
  "clarinet" => "woodwind",
  "drum" => "percussion",
  "oboe" => "woodwind",
  "trumpet" => "brass",
  "violoin" => "string"
}

puts inst_section["oboe"]
puts inst_section["cello"]
puts inst_section["bassoon"]

histogram = Hash.new(0)
puts histogram["Udo"]
histogram["Udo"] = histogram["Udo"] + 1
puts histogram["Udo"]
histogram["Udo"] = histogram["Udo"] + 1
puts histogram["Udo"]

puts "************* Kntrollstrukturen **************"

def balance_as_text (balance)
  if balance>0
    "Guthaben #{balance}"
  elsif balance==0
    "Pleite"
  else
    "Schulden #{-balance}"
  end
end

puts balance_as_text(77)
puts balance_as_text(0)
puts balance_as_text(-77)

number = 1
while number*number<=1000
  number = number + 1
end
puts "#{number} hoch 2 = #{number**2}"

puts "******** Dateien lesen *******"

f = File.new("chapter2Example.rb")
zaehler=0
while line = f.gets
  zaehler = zaehler +1
end
f.close
puts "Chapter2Example hat #{zaehler} Zeilen."

puts "******* Regulaere Ausdruecke **********"

pattern = /Perl|Python/
def passt? (s, pattern)
  if s =~ pattern
    puts "#{s} passt zu #{pattern}."
  else
    puts "#{s} passt nicht zu #{pattern}."
  end
end

passt?("Perl", pattern)
passt?("Perl", /P(erl|ython)/)
passt?("12:34:56", /\d\d:\d\d:\d\d/)
passt?("Perl ist besser als Python.", /Perl.*Python/)
passt?("PerlPython", /Perl *Python/)
passt?("Perl Python", /Perl +Python/)

puts "Perl necklace".sub(/Perl/, "Python")

puts "Perl is better than Python".gsub(/Perl|Python/, "Ruby")

puts "Perl is better than Python".match(/b\w*r/)[0]


puts "***** Blocks and Iterators ******"

5.times {puts "Einmal"}

animals = ["Ant", "Bee", "Cat", "Dog", "Elk"]

animals.each {puts "Tier"}

animals.each {|animal| puts "Tier: #{animal}"}

def two_times
  yield 1
  yield 2
end

two_times {puts "Hallo"}
two_times {|i| puts "Hallo #{i}"}


puts "********** Reading and 'Riting ***********"

while not ((line = gets) == "\n")
  line.chop
  puts line.gsub(/Perl/, "Ruby")
end
puts "Ende"
