# To change this template, choose Tools | Templates
# and open the template in the editor.

require 'pp'

class Song
  def initialize(name, artist, duration)
    @name = name
    @artist = artist
    @duration = duration
  end
  def to_s
    "Song: #{@name} - by #{@artist} (#{@duration}s)"
  end
  attr_reader :name, :artist, :duration
  attr_writer :duration
end

class KaraokeSong < Song
  def initialize(name, artist, duration, lyrics)
    super(name, artist, duration)
    @lyrics = lyrics
  end
  def to_s
    super + " [#{@lyrics}]"
  end
end

song = Song.new("Winds of Change","Scorpions", 310)
pp song
puts song

song2 = KaraokeSong.new("Alle meine Entchen", "Helga Feddersen", 200, "schwimmen auf dem See")
pp song2
puts song2

puts song.name
puts song.artist
song.duration = 400
puts song.duration
