
# Performs one Monte Carlo experiment, whether a random
# point inside a square
# is inside the corresponding fourth of a circle
def one_try_pi
  x = rand
  y = rand
  distance = Math.sqrt(x*x+y*y)
  distance<=1
end

# Make n tries of one_try_pi and compute the probability therefrom
def probability_pi4 (n)
  counter = 0.0 # using floating point number in counter/n
  n.times do
    if one_try_pi then counter+=1 end
  end
  counter/n
end

puts "pi is #{probability_pi4(100000)*4}"

# *****************************************************************

# random number 1..6, dice=Wuerfel
def dice
  rand(6)+1
end

# Perfoms one try of a Monte Carlo simulation, throwing n_throw
# dice and counting the number of 6er
def one_try_number_of_6_in_n_throws (n_throws)
  counter = 0
  n_throws.times do
    if dice==6 then counter+=1 end
  end
  counter
end

# Performs n Monte Carlo simulations, each throwing n_trow dice
# and counting how often less than n6 6er were encountered.
def probability_number_below (n, n_throws, n6)
  counter = 0.0 # using floating point number in counter/n
  n.times do
    if one_try_number_of_6_in_n_throws(n_throws)<n6 then counter+=1 end
  end
  counter/n
end

puts "dice is fake with significance"+
  "#{probability_number_below(100000, 10, 5)}"

# *********************************************************************

# Make one Monte Carlo run of the kniffel problem and
# trying to achieve a 6er kniffel
# return the number of 6 obtained
def one_try_6kniffel
  counter=0
  3.times do
    (5-counter).times do
       if dice==6 then counter+=1 end
    end
  end
  counter
end

# Makes n tries and returns the estimated probability of having a 6er Kniffel
def probability_6kniffel (n)
  counter = 0.0 # using floating point number in counter/n
  n.times do
    if one_try_6kniffel==5 then counter+=1 end
  end
  counter/n
end

puts "Probability of 6er Kniffel is #{probability_6kniffel(100000)}"

# *********************************************************************

# returns a random number of list of numbers
def rand_of_list (list)
end

# Makes one Monte-Carlo simulated try of the Monty-Hall game.
# Returns true, if the strategy of switching to the other door
# wins.
def one_try_monty_hall
  # note: [1,2,3]-[2] = [1,3]
end

# Runs n Monte-Carlo tries on the Monty Hall problem and returns the
# estimated probability that changing wins
def probability_monty_hall (n)
end

#puts "Changing to the other door helps #{probability_monty_hall(100000)}."

  