require "rubygame"

class Pong
   def initialize
     @width = 800
     @height=  480
     @screen = Rubygame::Screen.open([@width, @height])

     Rubygame::TTF.setup
     @font = Rubygame::TTF.new("FreeSans.ttf", 50)

     @clock=Rubygame::Clock.new
     @clock.target_framerate = 24

     @events=Rubygame::EventQueue.new

     new_game
   end

   def new_game
     @ball_x = @width/2
     @ball_y = @height/2
     @ball_radius = 10
     @ball_vx = 10
     @ball_vy = 0

     @club_x = 0
     @club_y = @height/2
     @club_width = 10
     @club_height = 100
     @club_vy = 0

     @score = 0
   end

   def update_ball
     @ball_x += @ball_vx
     @ball_y += @ball_vy
     if @ball_x-@ball_radius<=0 then # left
       new_game
     elsif @ball_x+@ball_radius>=@width then # right
       @ball_vx = -@ball_vx
     elsif @ball_y-@ball_radius<=0 then # top
       @ball_vy = -@ball_vy
     elsif @ball_y+@ball_radius>=@height then # bottom
       @ball_vy = -@ball_vy
     end

     if @club_x<=@ball_x-@ball_radius and @ball_x-@ball_radius<=@club_x+@club_width and
         @club_y<=@ball_y and @ball_y<=@club_y+@club_height then
       @ball_vx = -@ball_vx
       @ball_vy += @club_vy/2
     end
   end

   def update_club
     @club_y += @club_vy
     if @club_y<0 then
       @club_y=0
     end
     if @club_y+@club_height>=@height then
       @club_y = @height-@club_height
     end
   end

   def update
     update_ball
     update_club
   end

   def draw_ball
     @screen.draw_circle_s([@ball_x,@ball_y], @ball_radius, [255,255,255])
   end

   def draw_club
     @screen.draw_box_s([@club_x,@club_y],[@club_x+@club_width, @club_y+@club_height], [0,255,0])
   end

   def draw_score
     image = @font.render("#{@score}", true, [255, 0, 0])
     image.blit(@screen, [512, 0])
   end

   def draw
     @screen.draw_box_s([0,0], [@width,@height], [0,0,0])
     draw_ball
     draw_club
     draw_score
     @screen.update
   end

   def handle_events
     @events.each do |event|
       if event.is_a?(Rubygame::QuitEvent) then
         return :quit
       elsif event.is_a?(Rubygame::KeyDownEvent) and event.key==Rubygame::K_UP then
         @club_vy += -15
       elsif event.is_a?(Rubygame::KeyUpEvent) and event.key==Rubygame::K_UP then
         @club_vy = 0
       elsif event.is_a?(Rubygame::KeyDownEvent) and event.key==Rubygame::K_DOWN then
         @club_vy = 15
       elsif event.is_a?(Rubygame::KeyUpEvent) and event.key==Rubygame::K_DOWN then
         @club_vy = 0
       elsif event.is_a?(Rubygame::KeyDownEvent) and event.key==Rubygame::K_ESCAPE then
         return :quit
       end
     end
   end

   def loop
     while true do
       if handle_events==:quit then break end
       update
       draw
       @screen.update
       @clock.tick
     end
   end
end

Pong.new.loop


