require 'open-uri'

# load url from the web and store the data in filename
def download (url, filename)
  begin
    web = open(url)
    file= open(filename, "wb")
    data= web.read
    file.write(data)
  rescue OpenURI::HTTPError=>error
    if error.message =~ /\b503\b/ then
      sleep 10
      retry
    else 
      file.close
      file=nil
      File.delete(filename)
      raise
    end
  ensure
    if web!=nil then web.close end
    if file!=nil then file.close end
  end
  puts "downloaded: #{url} --> #{filename}"
end

# convert integer i to string using digits digits with leading 0s
def format (i, digits)
  decimaldigits = ['0','1','2','3','4','5','6','7','8','9']
  s = ""
  digits.times do
    s = decimaldigits[i%10] + s
    i = i/10
  end
  s
end

# build the webcam .jpg url for the date/time datetime
def url_of_datetime (baseurl, datetime)
  # datetime.year, datetime.month, datetime.day, datetime.hour
  "#{baseurl}/#{format(datetime.year,4)}/#{format(datetime.month,2)}/#{format(datetime.day,2)}#{format(datetime.hour,2)}.jpg"
end

# build the filename for the date/time datetime
def filename_of_datetime (datetime)
  "#{format(datetime.year,4)}#{format(datetime.month,2)}#{format(datetime.day,2)}#{format(datetime.hour,2)}.jpg"
end

# download the webcame .jpg corresponding to date/time datetime
def download_from_webcam (baseurl, datetime)
  download(url_of_datetime(baseurl, datetime), filename_of_datetime(datetime))
end

# download all 4 .jpgs of a certain day (date)
def download_day (baseurl, date)
  # datetime + seconds, 8,12,16,20
  download_from_webcam(baseurl, date+ 8*3600)
  download_from_webcam(baseurl, date+12*3600)
  download_from_webcam(baseurl, date+16*3600)
  download_from_webcam(baseurl, date+20*3600)
end

# download all .jpgs for the day from from to to (inclusively)
def download_days (baseurl, from, to)
  if from>to then 
    raise RangeError, "from (#{from}) is later than to (#{to})"
  end
  day = from
  while day<=to do
    download_day(baseurl, day)
    day = day + 24*3600
  end
end

def download_days_ui (baseurl, from, to)
  begin
    download_days(baseurl, from, to)
  rescue StandardError=>error
    puts "An error occurred #{error.message}"
  end
end

#download('http://www.min.uni-bremen.de/mincam/2010/01/0108.jpg', '2010010108.jpg')
puts url_of_datetime('http://www.min.uni-bremen.de/mincam', Time.parse("1 Jan 2010"))
puts filename_of_datetime(Time.parse("1 Jan 2010"))
#download_from_webcam('http://www.min.uni-bremen.de/mincam', Time.parse("1 Jan 2010 12:00"))
#download_day ('http://www.min.uni-bremen.de/mincam', Time.parse("1 Jan 2010"))
download_days_ui('http://www.min.uni-bremen.de/mincam', Time.parse("30 Jan 2010"), Time.parse("14 Jan 2010"))
