require 'open-uri'

# load url from the web and store the data in filename
def download (url, filename)
  begin
    web  = open(url)
    file = open(filename, "wb")
    data=web.read()
    file.write(data)
  rescue OpenURI::HTTPError => error
    if error.message =~ /\b503\b/ then
      puts "Server overloaded (#{url}), retrying"
      sleep 10
      retry
    elsif file!=nil then
      file.close
      file = nil
      File.delete(filename)
      raise
    end
  ensure
    if file!=nil then file.close end
    if web!=nil then web.close end
  end
  puts "downloaded: #{url} --> #{filename}"
end

# convert integer i to string using digits digits with leading 0s
def format (i, digits)
  s = i.to_s
  while s.length<digits do
    s = '0'+s
  end
  s
end

# build the webcam .jpg url for the date/time datetime
def url_of_datetime (baseurl, datetime)
  "#{baseurl}/#{format(datetime.year, 4)}/#{format(datetime.month, 2)}/#{format(datetime.day,2)}#{format(datetime.hour,2)}.jpg"
end

# build the filename for the date/time datetime
def filename_of_datetime (datetime)
  "#{format(datetime.year, 4)}#{format(datetime.month, 2)}#{format(datetime.day,2)}#{format(datetime.hour,2)}.jpg"
end

# download the webcame .jpg corresponding to date/time datetime
def download_from_webcam (baseurl, datetime)
  download(url_of_datetime(baseurl, datetime), filename_of_datetime(datetime))
end

# download all 4 .jpgs of a certain day (date)
def download_day (baseurl, date)
  [8,12,16,20].each do |hour| 
    datetime = date + hour*60*60
    download_from_webcam(baseurl, datetime)
  end
end

# download all .jpgs for the day from from to to (inclusively)
def download_days (baseurl, from, to)
  if from>to then raise ArgumentError, "from=#{from} larger than to=#{to}" end
  myday = from
  while myday <= to do
    download_day(baseurl, myday)
    myday += 24*60*60
  end
end

# download (as above) but with printed error message
def download_days_with_errormessage (baseurl, from, to)
  begin
     download_days(baseurl, from, to)
     puts "Download finished."
  rescue StandardError => error
    puts "An error occurred:", error.message
  end
end

download_days_with_errormessage('http://www.min.uni-bremen.de/mincam', Time.parse("1 Jan 2010"), Time.parse("3 Jan 2010"))
