require 'socket'

class ChatServer
  def initialize
    @port = 12345
    @clients = [] # List of client sockets connected to the server
    @server = TCPServer.new(@port) # Our chat server
  end

  # Send textline line to all clients in @clients
  def send_all (line)
    @clients.each do |client|
      client.puts line
    end
  end

  def handle_socket (socket)
    if socket==@server then
      socket = @server.accept
      @clients += [socket]
      send_all ("Someone joined us")
    elsif socket.eof? then
      @clients -= [socket]
      send_all ("Someone left")
    else
      line = socket.gets
      send_all (line)
    end
  end

  def run
    while true do
      begin
         readlist, writelist = select(@clients+[@server], nil, nil, nil)
         if readlist!=nil then
           readlist.each do |socket|
             handle_socket(socket)
           end
         end
      rescue StandardError=>error
        puts "An error occurred: #{error.message}"
      end
    end
  end
end

ChatServer.new.run
