require 'socket'

server = TCPServer.new(12345)
puts "Server running"
while true do
  socket = server.accept
  puts "Connection established"
  ctr=0
  begin
    while true do
      line = socket.gets
      line.chomp!
      if line=="QUIT" then break end
      puts line
      ctr += 1
      socket.puts ctr
    end
  rescue Errno::EINVAL, Errno::ECONNRESET
    puts "Connection closed."
  rescue SystemCallError=>err
    puts "Error in connection\n #{err.message} #{err.class.name}"
  ensure
    socket.close
  end
end
server.close
puts "Server closed"
