//! All parameters needed for describing the coal cart shape/behavior
//! Including beacons
class CoalCartParameter 
{
    //! Length and width of the cart
    double cartLength = 10, cartWidth = 4;    

    //! The cart sees beacons with an angle of +/- fieldOfView
    //! from its front direction
    double fieldOfView = Math.PI/3;    
    
    //! Length and width of the cart workspace [m]
    double workspaceLength = 100;    

    //! Standard deviation of the beacon sensor [rad]
    double measurementNoiseSigma = 3.0/180*Math.PI;    

    /*! noise coefficient for the wheel sensor The actual noise
        applied depends on how much the wheel  has moved and should be
        chosen such that for a motion of [1m] the noise covariance
        increases by \c dynamicNoiseSigma*dynamicNoiseSigma.
    */
    double dynamicNoiseSigma = 0.15;

    //! Where the coal cart starts
    double initialCartX = 50, initialCartY = 50;
    
    //! The orientation of the coal cart in the beginning
    double initialCartPhi = 0;
    
    

    //! Position of known beacons
    double[][] beacon = new double[][] {{20, 20}, {90, 50}, {50, 90}};

    //! The outline of the cart in cart coordinates
    double[][] cartShape = new double[][] {{-2, -2}, {6, -2}, {8,0}, {6, 2}, {-2, 2}}; 
};