//! All parameters needed for describing the coal cart shape/behavior
//! Including beacons
class CoalCartParameter 
{
    //! Cart dimensions
    double cartWidth = 10, cartHeight = 4, cartLength = 12;    
   
    //! Length and width of the cart workspace [m]
    double workspaceLength = 1000;    

    //! Physical standard deviation accelerometers [m/s^2]
    /*! \warning: In our model we chose to ignore the actual
        acceleration of the coal cart pretending it was in rest.
	Since there is acceleration we have to pretend its large
        Gaussian noise on the accelerometers. So choose a reasonable
	value larger than measurementNoiseSigma for your filter.
     */
    double measurementNoiseSigma = 0.2;

    //! Standard deviation of the gyrometer sensors [rad/s].
    /*! The noise does not depend on the rotation rate.
    */
    double dynamicNoiseSigma = 0.1;

    //! Where the coal cart starts
    double initialCartX = 0, initialCartY = -700, initialCartZ = 20;
    
    //! Orientation of the coal cart in the beginning
    double initialCartGamma = 0.0, initialCartBeta = 0.0, initialCartAlpha = 0.0;
    
    //! Transparency settings for esimated Coal Cart
    float estCoalCartTransparency = 0.7f;
    
    //! Duration of a dynamic step
    double deltaT = 0.04;
    
    //! gravity [m/s^2]
    double[] gravity = new double[] {0.0, 0.0, -9.81}; 
};