/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.LOD;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.Switch;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public class DistanceLOD
extends LOD {
    private double[] distances;
    private Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    private Point3f center = new Point3f();
    private Point3f viewPosition = new Point3f();

    public DistanceLOD() {
        this.distances = new double[1];
        this.distances[0] = 0.0;
    }

    public DistanceLOD(float[] fArray) {
        this.distances = new double[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.distances[i] = fArray[i];
        }
    }

    public DistanceLOD(float[] fArray, Point3f point3f) {
        this.distances = new double[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.distances[i] = fArray[i];
        }
        this.position.set((Tuple3f)point3f);
    }

    public void setPosition(Point3f point3f) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            ((NodeRetained)this.retained).staticTransform.transform.transform(point3f, this.position);
        } else {
            this.position.set((Tuple3f)point3f);
        }
    }

    public void getPosition(Point3f point3f) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            Transform3D transform3D = ((NodeRetained)this.retained).staticTransform.getInvTransform();
            transform3D.transform(this.position, point3f);
        } else {
            point3f.set((Tuple3f)this.position);
        }
    }

    public int numDistances() {
        return this.distances.length;
    }

    public double getDistance(int n) {
        return this.distances[n];
    }

    public void setDistance(int n, double d) {
        this.distances[n] = d;
    }

    public void initialize() {
        this.wakeupOn(this.wakeupFrame);
    }

    public void processStimulus(Enumeration enumeration) {
        int n;
        View view = this.getView();
        if (view == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        ViewPlatform viewPlatform = view.getViewPlatform();
        if (viewPlatform == null) {
            return;
        }
        double d = 0.0;
        int n2 = 0;
        Transform3D transform3D = VirtualUniverse.mc.getTransform3D(null);
        transform3D.set(((NodeRetained)this.retained).getCurrentLocalToVworld());
        transform3D.transform(this.position, this.center);
        this.viewPosition.x = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.x;
        this.viewPosition.y = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.y;
        this.viewPosition.z = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.z;
        d = this.center.distance(this.viewPosition);
        d /= transform3D.getDistanceScale();
        int n3 = this.numSwitches();
        n2 = this.distances.length;
        if (d <= this.distances[0]) {
            n2 = 0;
        } else {
            for (n = 1; n < this.distances.length; ++n) {
                if (!(d > this.distances[n - 1]) || !(d <= this.distances[n])) continue;
                n2 = n;
                break;
            }
        }
        for (n = n3 - 1; n >= 0; --n) {
            Switch switch_ = this.getSwitch(n);
            if (((SwitchRetained)switch_.retained).getWhichChild() == n2) continue;
            switch_.setWhichChild(n2);
        }
        VirtualUniverse.mc.addToTransformFreeList(transform3D);
        this.wakeupOn(this.wakeupFrame);
    }

    public Node cloneNode(boolean bl) {
        DistanceLOD distanceLOD = new DistanceLOD();
        distanceLOD.duplicateNode(this, bl);
        return distanceLOD;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        DistanceLOD distanceLOD = (DistanceLOD)node;
        int n = distanceLOD.numDistances();
        this.distances = new double[n];
        for (int i = 0; i < n; ++i) {
            this.setDistance(i, distanceLOD.getDistance(i));
        }
        Point3f point3f = new Point3f();
        distanceLOD.getPosition(point3f);
        this.setPosition(point3f);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        transformGroupRetained.transform.transform(this.position, this.position);
    }
}

