/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderBin;
import javax.media.j3d.ShaderAppearanceRetained;
import javax.media.j3d.ShaderAttributeSetRetained;
import javax.media.j3d.ShaderProgramRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;

class ShaderBin
implements ObjectUpdate {
    static final int SHADER_PROGRAM_DIRTY = 1;
    static final int SHADER_ATTRIBUTE_SET_DIRTY = 2;
    RenderBin renderBin = null;
    AttributeBin attributeBin = null;
    ShaderBin next = null;
    ShaderBin prev = null;
    TextureBin textureBinList = null;
    ArrayList addTextureBins = new ArrayList();
    boolean onUpdateList = false;
    int numEditingTextureBins = 0;
    int componentDirty = 0;
    ShaderAppearanceRetained shaderAppearance = null;
    ShaderProgramRetained shaderProgram = null;
    ShaderAttributeSetRetained shaderAttributeSet = new ShaderAttributeSetRetained();

    ShaderBin(ShaderAppearanceRetained shaderAppearanceRetained, RenderBin renderBin) {
        this.reset(shaderAppearanceRetained, renderBin);
    }

    void reset(ShaderAppearanceRetained shaderAppearanceRetained, RenderBin renderBin) {
        this.prev = null;
        this.next = null;
        this.renderBin = renderBin;
        this.attributeBin = null;
        this.textureBinList = null;
        this.onUpdateList = false;
        this.numEditingTextureBins = 0;
        this.addTextureBins.clear();
        if (shaderAppearanceRetained != null) {
            this.shaderProgram = shaderAppearanceRetained.shaderProgram;
            this.shaderAttributeSet = shaderAppearanceRetained.shaderAttributeSet;
        } else {
            this.shaderProgram = null;
            this.shaderAttributeSet = null;
        }
        this.shaderAppearance = shaderAppearanceRetained;
    }

    void clear() {
        this.reset(null, null);
    }

    boolean equals(ShaderAppearanceRetained shaderAppearanceRetained) {
        ShaderAttributeSetRetained shaderAttributeSetRetained;
        ShaderProgramRetained shaderProgramRetained;
        if (shaderAppearanceRetained == null) {
            shaderProgramRetained = null;
            shaderAttributeSetRetained = null;
        } else {
            shaderProgramRetained = shaderAppearanceRetained.shaderProgram;
            shaderAttributeSetRetained = shaderAppearanceRetained.shaderAttributeSet;
        }
        return this.shaderProgram == shaderProgramRetained && this.shaderAttributeSet == shaderAttributeSetRetained;
    }

    public void updateObject() {
        if (this.addTextureBins.size() > 0) {
            TextureBin textureBin = (TextureBin)this.addTextureBins.get(0);
            if (this.textureBinList == null) {
                this.textureBinList = textureBin;
            } else {
                this.insertTextureBin(textureBin);
            }
            for (int i = 1; i < this.addTextureBins.size(); ++i) {
                textureBin = (TextureBin)this.addTextureBins.get(i);
                this.insertTextureBin(textureBin);
            }
        }
        this.addTextureBins.clear();
        this.onUpdateList = false;
    }

    void insertTextureBin(TextureBin textureBin) {
        TextureRetained textureRetained = null;
        if (textureBin.texUnitState != null && textureBin.texUnitState.length > 0 && textureBin.texUnitState[0] != null) {
            textureRetained = textureBin.texUnitState[0].texture;
        }
        if (textureRetained != null) {
            TextureBin textureBin2 = this.textureBinList;
            while (textureBin2 != null) {
                if (textureBin2.texUnitState == null || textureBin2.texUnitState[0] == null || textureBin2.texUnitState[0].texture != textureRetained) {
                    textureBin2 = textureBin2.next;
                    continue;
                }
                textureBin.next = textureBin2;
                textureBin.prev = textureBin2.prev;
                if (textureBin2.prev == null) {
                    this.textureBinList = textureBin;
                } else {
                    textureBin2.prev.next = textureBin;
                }
                textureBin2.prev = textureBin;
                return;
            }
        }
        textureBin.prev = null;
        textureBin.next = this.textureBinList;
        this.textureBinList.prev = textureBin;
        this.textureBinList = textureBin;
        textureBin.tbFlag &= 0xFFFFFFEF;
    }

    void reInsertTextureBin(TextureBin textureBin) {
        TextureRetained textureRetained = null;
        TextureRetained textureRetained2 = null;
        TextureRetained textureRetained3 = null;
        if (textureBin.texUnitState != null && textureBin.texUnitState[0] != null) {
            textureRetained = textureBin.texUnitState[0].texture;
        }
        if (textureBin.prev != null && textureBin.prev.texUnitState != null) {
            textureRetained2 = textureBin.prev.texUnitState[0].texture;
        }
        if (textureRetained != textureRetained2) {
            if (textureBin.next != null && textureBin.next.texUnitState != null) {
                textureRetained3 = textureBin.next.texUnitState[0].texture;
            }
            if (textureRetained != textureRetained3 && textureBin.prev != null && textureBin.next != null) {
                textureBin.prev.next = textureBin.next;
                textureBin.next.prev = textureBin.prev;
                this.insertTextureBin(textureBin);
            }
        }
    }

    void addTextureBin(TextureBin textureBin, RenderBin renderBin, RenderAtom renderAtom) {
        textureBin.environmentSet = this.attributeBin.environmentSet;
        textureBin.attributeBin = this.attributeBin;
        textureBin.shaderBin = this;
        this.attributeBin.updateFromShaderBin(renderAtom);
        this.addTextureBins.add(textureBin);
        if (!this.onUpdateList) {
            renderBin.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    void removeTextureBin(TextureBin textureBin) {
        if (this.addTextureBins.contains(textureBin)) {
            this.addTextureBins.remove(this.addTextureBins.indexOf(textureBin));
        } else if (textureBin.prev == null) {
            this.textureBinList = textureBin.next;
            if (textureBin.next != null) {
                textureBin.next.prev = null;
            }
        } else {
            textureBin.prev.next = textureBin.next;
            if (textureBin.next != null) {
                textureBin.next.prev = textureBin.prev;
            }
        }
        textureBin.shaderBin = null;
        textureBin.prev = null;
        textureBin.next = null;
        textureBin.clear();
        this.renderBin.textureBinFreelist.add(textureBin);
        if (this.textureBinList == null && this.addTextureBins.size() == 0) {
            this.attributeBin.removeShaderBin(this);
        }
    }

    void render(Canvas3D canvas3D) {
        canvas3D.setStateToUpdate(6, this);
        TextureBin textureBin = this.textureBinList;
        while (textureBin != null) {
            textureBin.render(canvas3D);
            textureBin = textureBin.next;
        }
    }

    void updateTransparentAttributes(Canvas3D canvas3D) {
        canvas3D.setStateToUpdate(6, this);
    }

    void updateAttributes(Canvas3D canvas3D) {
        if (this.shaderProgram != null) {
            this.shaderProgram.updateNative(canvas3D, true);
            if (this.shaderAttributeSet != null) {
                this.shaderAttributeSet.updateNative(canvas3D, this.shaderProgram);
            }
        } else if (canvas3D.shaderProgram != null) {
            canvas3D.shaderProgram.updateNative(canvas3D, false);
        }
        canvas3D.shaderBin = this;
        canvas3D.shaderProgram = this.shaderProgram;
    }

    void updateNodeComponent() {
        if ((this.componentDirty & 1) != 0) {
            this.shaderProgram = this.shaderAppearance.shaderProgram;
        }
        if ((this.componentDirty & 2) != 0) {
            HashMap hashMap = (HashMap)this.shaderAttributeSet.getAttrs();
            hashMap.clear();
            if (this.shaderAppearance.shaderAttributeSet != null) {
                hashMap.putAll(this.shaderAppearance.shaderAttributeSet.getAttrs());
            }
        }
        this.componentDirty = 0;
    }

    void incrActiveTextureBin() {
        ++this.numEditingTextureBins;
    }

    void decrActiveTextureBin() {
        --this.numEditingTextureBins;
    }
}

