# To change this template, choose Tools | Templates
# and open the template in the editor.

require 'pp'

class Song
  def initialize(name, artist, duration)
    @name = name
    @artist = artist
    @duration = duration
  end
  def to_s
    "Song: #{@name} - by #{@artist} (#{@duration}s)"
  end
  attr_reader :name, :artist, :duration
  attr_writer :duration
end

class KaraokeSong < Song
  def initialize(name, artist, duration, lyrics)
    super(name, artist, duration)
    @lyrics = lyrics
  end
  def to_s
    super + " [#{@lyrics}]"
  end
end


class SongList
  attr_reader :songs
  def initialize
    @songs = Array.new
  end

	def append(song)
		@songs += [song]
		self
	end

	def delete_first
		first = @songs[0]
		@songs = @songs[1..-1]
		first
	end

  def delete_last
		last = @songs[-1]
		@songs = @songs[0..-2]
		last
	end

	def [](index)
		@songs[index]
	end

  def with_title(title)
    @songs.find{|song| song.name==title}
  end

  def to_s
    s = "["
    @songs[0...-1].each do |song|
      s += song.name + ", "
    end
    s+=@songs[-1].name + "]"
    s
  end
end

song = Song.new("Winds of Change","Scorpions", 310)
song2 = KaraokeSong.new("Alle meine Entchen", "Helga Feddersen", 200, "schwimmen auf dem See")
song3 = Song.new("Thriller", "Michael Jackson", 13*60)

sl = SongList.new
sl.append(song).append(song2).append(song3).append(song)
puts sl
puts sl.delete_first
puts sl
puts sl.delete_last
puts sl
puts sl[0]
puts sl.with_title("Thriller")
