class KalmanFilter1D 
{
    //! The filter's belief on the current state
        double muX, sigmaX2;

    /*! noise coefficient for the wheel sensor. The actual noise
        applied depends on how much the wheel has moved and should be
        chosen such that for a motion of [1m] the noise covariance
        increases by \c dynamicNoiseSigma*dynamicNoiseSigma.
    */
    double dynamicNoiseSigma = 0.3;

    //! Standard deviation of the bearing measurement
    double measurementNoiseSigma = 1*Math.PI/180;

    //! Height of the sensor above the point of the cart that is measured.
    double height = 8;

    //! Just for convenience
    static final double sqr(double x) 
    {
        return x*x;
    }    

    //! Just for convenience
    static final double sqrt(double x) 
    {
        return Math.sqrt(x);
    }    


    KalmanFilter1D ()
    {
        initialize ();        
    }    


    //! Set \c muX and \c sigmaX2
    void initialize ()
    {
        // TODO Implement
    }

    //! Returns the (expected) new state if \c x is the old state and
    //! \c u the command.
    double dynamicModel (double x, double u)
    {
        // TODO Implement
        return 0;        
    }
    

    //! Dynamic update: Incorporate a dynamic step with distance 
    //! measurement \c u into the filter's belief state
    void dynamic (double u)
    {
        // TODO Implement
    }

    //! Returns the (expected) measurement if the state was \c x
    double measurementModel (double x)
    {
        // TODO Implement
        return 0;        
    }

    //! Returns the derivative of \c measurementModel
    double measurementModelDerivative (double x)
    {
        // TODO Implement
        return 0;        
    }
    
    
    //! Measurement step: Incorporate the measurement \c z into the belief state
    void measurement (double z)
    {
        // TODO Implement
    }
}
