/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking;

import com.sun.j3d.internal.Distance;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickIntersection;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class PickResult {
    public static final int SHAPE3D = 1;
    public static final int MORPH = 2;
    public static final int PRIMITIVE = 4;
    public static final int LINK = 8;
    public static final int GROUP = 16;
    public static final int TRANSFORM_GROUP = 32;
    public static final int BRANCH_GROUP = 64;
    public static final int SWITCH = 128;
    static boolean debug = false;
    private boolean firstIntersectOnly = false;
    private SceneGraphPath pickedSceneGraphPath = null;
    private Node pickedNode = null;
    private GeometryArray[] geometryArrays = null;
    private Shape3D[] compressGeomShape3Ds = null;
    private Transform3D localToVWorld = null;
    private PickShape pickShape = null;
    private int pickShapeType = -1;
    private Vector3d pickShapeDir = null;
    private Point3d pickShapeStart = null;
    private Point3d pickShapeEnd = null;
    private Bounds pickShapeBounds = null;
    static final Point3d zeroPnt = new Point3d();
    ArrayList intersections = null;
    static final double FUZZ = 1.0E-6;
    static final int PICK_SHAPE_RAY = 1;
    static final int PICK_SHAPE_SEGMENT = 2;
    static final int PICK_SHAPE_POINT = 3;
    static final int PICK_SHAPE_BOUNDING_BOX = 4;
    static final int PICK_SHAPE_BOUNDING_SPHERE = 5;
    static final int PICK_SHAPE_BOUNDING_POLYTOPE = 6;
    static final int PICK_SHAPE_CYLINDER = 7;
    static final int PICK_SHAPE_CONE = 8;
    static final double EPS = 1.0E-13;

    PickResult() {
    }

    public PickResult(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        this.pickedSceneGraphPath = sceneGraphPath;
        this.pickedNode = sceneGraphPath.getObject();
        this.localToVWorld = sceneGraphPath.getTransform();
        this.pickShape = pickShape;
        this.initPickShape();
    }

    public PickResult(Node node, Transform3D transform3D, PickShape pickShape) {
        if (!(node instanceof Shape3D) && !(node instanceof Morph)) {
            throw new IllegalArgumentException();
        }
        this.pickedNode = node;
        this.localToVWorld = transform3D;
        this.pickShape = pickShape;
        this.initPickShape();
    }

    void reset(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        this.firstIntersectOnly = false;
        this.geometryArrays = null;
        this.compressGeomShape3Ds = null;
        this.pickShapeBounds = null;
        this.intersections = null;
        this.pickedSceneGraphPath = sceneGraphPath;
        this.pickedNode = sceneGraphPath.getObject();
        this.localToVWorld = sceneGraphPath.getTransform();
        this.pickShape = pickShape;
        this.initPickShape();
    }

    void reset(Node node, Transform3D transform3D, PickShape pickShape) {
        if (!(node instanceof Shape3D) && !(node instanceof Morph)) {
            throw new IllegalArgumentException();
        }
        this.firstIntersectOnly = false;
        this.geometryArrays = null;
        this.compressGeomShape3Ds = null;
        this.pickShapeBounds = null;
        this.intersections = null;
        this.pickedSceneGraphPath = null;
        this.pickedNode = node;
        this.localToVWorld = transform3D;
        this.pickShape = pickShape;
        this.initPickShape();
    }

    void initPickShape() {
        if (this.pickShape instanceof PickRay) {
            if (this.pickShapeStart == null) {
                this.pickShapeStart = new Point3d();
            }
            if (this.pickShapeDir == null) {
                this.pickShapeDir = new Vector3d();
            }
            ((PickRay)this.pickShape).get(this.pickShapeStart, this.pickShapeDir);
            this.pickShapeType = 1;
        } else if (this.pickShape instanceof PickSegment) {
            if (this.pickShapeStart == null) {
                this.pickShapeStart = new Point3d();
            }
            if (this.pickShapeEnd == null) {
                this.pickShapeEnd = new Point3d();
            }
            if (this.pickShapeDir == null) {
                this.pickShapeDir = new Vector3d();
            }
            ((PickSegment)this.pickShape).get(this.pickShapeStart, this.pickShapeEnd);
            this.pickShapeDir.set(this.pickShapeEnd.x - this.pickShapeStart.x, this.pickShapeEnd.y - this.pickShapeStart.y, this.pickShapeEnd.z - this.pickShapeStart.z);
            this.pickShapeType = 2;
        } else if (this.pickShape instanceof PickBounds) {
            this.pickShapeBounds = ((PickBounds)this.pickShape).get();
            if (this.pickShapeBounds instanceof BoundingBox) {
                this.pickShapeType = 4;
            } else if (this.pickShapeBounds instanceof BoundingSphere) {
                this.pickShapeType = 5;
            } else if (this.pickShapeBounds instanceof BoundingPolytope) {
                this.pickShapeType = 6;
            }
        } else {
            if (this.pickShape instanceof PickPoint) {
                throw new RuntimeException("PickPoint doesn't make sense for geometry-based picking. Java 3D doesn't have spatial information of the surface. Should use PickBounds with BoundingSphere and set radius to a epsilon tolerance.");
            }
            if (this.pickShape instanceof PickCylinder) {
                this.pickShapeType = 7;
            } else if (this.pickShape instanceof PickCone) {
                this.pickShapeType = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
    }

    public SceneGraphPath getSceneGraphPath() {
        return this.pickedSceneGraphPath;
    }

    public Transform3D getLocalToVworld() {
        return this.localToVWorld;
    }

    public GeometryArray getGeometryArray() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays[0];
    }

    public GeometryArray[] getGeometryArrays() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays;
    }

    public int numGeometryArrays() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays.length;
    }

    public int numCompressedGeometryShape3Ds() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        if (this.compressGeomShape3Ds == null) {
            return 0;
        }
        return this.compressGeomShape3Ds.length;
    }

    public Shape3D[] getCompressedGeometryShape3Ds() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        if (this.compressGeomShape3Ds == null) {
            return null;
        }
        return this.compressGeomShape3Ds;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public void setFirstIntersectOnly(boolean bl) {
        this.firstIntersectOnly = bl;
    }

    public boolean getFirstPickEnable() {
        return this.firstIntersectOnly;
    }

    public int numIntersections() {
        if (this.intersections == null) {
            this.generateIntersections();
        }
        return this.intersections.size();
    }

    public PickIntersection getIntersection(int n) {
        if (this.intersections == null) {
            this.generateIntersections();
        }
        return (PickIntersection)this.intersections.get(n);
    }

    public PickIntersection getClosestIntersection(Point3d point3d) {
        PickIntersection pickIntersection = null;
        PickIntersection pickIntersection2 = null;
        Point3d point3d2 = null;
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        if (point3d == null) {
            return null;
        }
        if (this.intersections == null) {
            this.generateIntersections();
        }
        for (int i = 0; i < this.intersections.size(); ++i) {
            pickIntersection2 = this.getIntersection(i);
            if (null == pickIntersection2 || null == (point3d2 = pickIntersection2.getPointCoordinatesVW()) || !((d2 = point3d.distance(point3d2)) < d)) continue;
            pickIntersection = pickIntersection2;
            d = d2;
        }
        return pickIntersection;
    }

    public String toString() {
        String string = new String("PickResult: sgp:" + this.pickedSceneGraphPath + "\n");
        if (this.pickedNode != null) {
            string = string + " node:" + this.pickedNode;
        }
        if (this.intersections == null) {
            this.generateIntersections();
        }
        if (this.intersections.size() > 0) {
            for (int i = 0; i < this.intersections.size(); ++i) {
                string = string + "\n";
                string = string + ((PickIntersection)this.intersections.get(i)).toString2();
            }
        }
        return string;
    }

    private void storeGeometry() {
        Shape3D shape3D;
        if (this.pickedNode instanceof Morph) {
            this.geometryArrays = new GeometryArray[1];
            this.geometryArrays[0] = ((Morph)this.pickedNode).getGeometryArray(0);
        } else if (this.pickedNode instanceof Shape3D) {
            int n;
            shape3D = (Shape3D)this.pickedNode;
            ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
            for (n = 0; n < shape3D.numGeometries(); ++n) {
                Geometry geometry = shape3D.getGeometry(n);
                if (geometry instanceof CompressedGeometry) {
                    int n2;
                    Shape3D[] shape3DArray = ((CompressedGeometry)geometry).decompress();
                    if (shape3DArray != null) {
                        for (int i = 0; i < shape3DArray.length; ++i) {
                            for (n2 = 0; n2 < shape3DArray[i].numGeometries(); ++n2) {
                                arrayList.add(shape3DArray[i].getGeometry(n2));
                            }
                        }
                    }
                    if (this.compressGeomShape3Ds == null) {
                        this.compressGeomShape3Ds = shape3DArray;
                        continue;
                    }
                    Shape3D[] shape3DArray2 = this.compressGeomShape3Ds;
                    n2 = shape3DArray2.length + shape3DArray.length;
                    this.compressGeomShape3Ds = new Shape3D[n2];
                    System.arraycopy(shape3DArray2, 0, this.compressGeomShape3Ds, 0, shape3DArray2.length);
                    System.arraycopy(shape3DArray, 0, this.compressGeomShape3Ds, shape3DArray2.length, shape3DArray.length);
                    continue;
                }
                if (!(geometry instanceof GeometryArray)) continue;
                arrayList.add(geometry);
            }
            this.geometryArrays = new GeometryArray[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.geometryArrays[n] = (GeometryArray)arrayList.get(n);
            }
        }
        if (this.geometryArrays == null) {
            if (this.pickedNode instanceof Shape3D) {
                shape3D = (Shape3D)this.pickedNode;
            }
            throw new RuntimeException("Type of the picked node is not supported");
        }
    }

    public Node getObject() {
        if (this.pickedNode == null) {
            this.storeNode();
        }
        return this.pickedNode;
    }

    void setObject(Node node) {
        this.pickedNode = node;
    }

    public Node getNode(int n) {
        if (this.pickedNode == null) {
            this.storeNode();
        }
        if (this.pickedNode instanceof Shape3D && (n & 1) != 0) {
            if (debug) {
                System.out.println("Shape3D found");
            }
            return this.pickedNode;
        }
        if (this.pickedNode instanceof Morph && (n & 2) != 0) {
            if (debug) {
                System.out.println("Morph found");
            }
            return this.pickedNode;
        }
        if (this.pickedSceneGraphPath == null) {
            return null;
        }
        for (int i = this.pickedSceneGraphPath.nodeCount() - 1; i >= 0; --i) {
            Node node = this.pickedSceneGraphPath.getNode(i);
            if (debug) {
                System.out.println("looking at node " + node);
            }
            if (node instanceof Primitive && (n & 4) != 0) {
                if (debug) {
                    System.out.println("Primitive found");
                }
                return node;
            }
            if (node instanceof Link && (n & 8) != 0) {
                if (debug) {
                    System.out.println("Link found");
                }
                return node;
            }
            if (node instanceof Switch && (n & 0x80) != 0) {
                if (debug) {
                    System.out.println("Switch found");
                }
                return node;
            }
            if (node instanceof TransformGroup && (n & 0x20) != 0) {
                if (debug) {
                    System.out.println("xform group found");
                }
                return node;
            }
            if (node instanceof BranchGroup && (n & 0x40) != 0) {
                if (debug) {
                    System.out.println("Branch group found");
                }
                return node;
            }
            if (!(node instanceof Group) || (n & 0x10) == 0) continue;
            if (debug) {
                System.out.println("Group found");
            }
            return node;
        }
        return null;
    }

    void storeNode() {
        if (this.pickedSceneGraphPath == null) {
            throw new RuntimeException("SceneGraphPath missing");
        }
        this.pickedNode = this.pickedSceneGraphPath.getObject();
    }

    boolean generateIntersections() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        this.intersections = new ArrayList();
        int n = 0;
        for (int i = 0; i < this.geometryArrays.length; ++i) {
            if (!this.intersect(i, this.firstIntersectOnly)) continue;
            if (this.firstIntersectOnly) {
                return true;
            }
            ++n;
        }
        return n > 0;
    }

    final boolean intersect(int n, boolean bl) {
        int n2;
        int n3;
        GeometryArray geometryArray = this.geometryArrays[n];
        int n4 = geometryArray.getVertexCount();
        double[] dArray = null;
        float[] fArray = null;
        Point3d[] point3dArray = null;
        Point3f[] point3fArray = null;
        int n5 = geometryArray.getVertexFormat();
        boolean bl2 = false;
        if ((n5 & 0x80) == 0) {
            dArray = new double[n4 * 3];
            geometryArray.getCoordinates(0, dArray);
        } else if ((n5 & 0x100) == 0) {
            dArray = geometryArray.getCoordRefDouble();
            if (dArray == null && (fArray = geometryArray.getCoordRefFloat()) == null && (point3fArray = geometryArray.getCoordRef3f()) == null) {
                point3dArray = geometryArray.getCoordRef3d();
            }
        } else {
            fArray = geometryArray.getInterleavedVertices();
        }
        Point3d[] point3dArray2 = new Point3d[n4];
        if (debug) {
            System.out.println("localToVWorld = " + this.localToVWorld);
        }
        if ((n5 & 0x100) == 0) {
            if (dArray != null) {
                n3 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    point3dArray2[n2] = PickResult.getPoint3d();
                    point3dArray2[n2].x = dArray[n3++];
                    point3dArray2[n2].y = dArray[n3++];
                    point3dArray2[n2].z = dArray[n3++];
                    this.localToVWorld.transform(point3dArray2[n2]);
                }
            } else if (fArray != null) {
                n3 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    point3dArray2[n2] = PickResult.getPoint3d();
                    point3dArray2[n2].x = fArray[n3++];
                    point3dArray2[n2].y = fArray[n3++];
                    point3dArray2[n2].z = fArray[n3++];
                    this.localToVWorld.transform(point3dArray2[n2]);
                }
            } else if (point3fArray != null) {
                for (n2 = 0; n2 < n4; ++n2) {
                    point3dArray2[n2] = PickResult.getPoint3d();
                    point3dArray2[n2].set((Tuple3f)point3fArray[n2]);
                    this.localToVWorld.transform(point3dArray2[n2]);
                }
            } else {
                for (n2 = 0; n2 < n4; ++n2) {
                    point3dArray2[n2] = PickResult.getPoint3d();
                    point3dArray2[n2].set((Tuple3d)point3dArray[n2]);
                    this.localToVWorld.transform(point3dArray2[n2]);
                }
            }
        } else {
            n3 = 0;
            if ((n5 & 4) == 4) {
                n3 += 3;
            } else if ((n5 & 0xC) == 12) {
                n3 += 4;
            }
            if ((n5 & 2) != 0) {
                n3 += 3;
            }
            if ((n5 & 0x20) == 32) {
                n3 += 2 * geometryArray.getTexCoordSetCount();
            } else if ((n5 & 0x40) == 64) {
                n3 += 3 * geometryArray.getTexCoordSetCount();
            }
            int n6 = n3 + 3;
            for (n2 = 0; n2 < n4; ++n2) {
                point3dArray2[n2] = PickResult.getPoint3d();
                point3dArray2[n2].x = fArray[n3];
                point3dArray2[n2].y = fArray[n3 + 1];
                point3dArray2[n2].z = fArray[n3 + 2];
                this.localToVWorld.transform(point3dArray2[n2]);
                n3 += n6;
            }
        }
        PickIntersection pickIntersection = new PickIntersection(this, geometryArray);
        if (geometryArray instanceof PointArray) {
            bl2 = this.intersectPA((PointArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof IndexedPointArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            bl2 = this.intersectIPA((IndexedPointArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof LineArray) {
            bl2 = this.intersectLA((LineArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof LineStripArray) {
            bl2 = this.intersectLSA((LineStripArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof IndexedLineArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            bl2 = this.intersectILA((IndexedLineArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof IndexedLineStripArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            bl2 = this.intersectILSA((IndexedLineStripArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof TriangleArray) {
            bl2 = this.intersectTA((TriangleArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof TriangleStripArray) {
            bl2 = this.intersectTSA((TriangleStripArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof TriangleFanArray) {
            bl2 = this.intersectTFA((TriangleFanArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof IndexedTriangleArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            bl2 = this.intersectITA((IndexedTriangleArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof IndexedTriangleStripArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            bl2 = this.intersectITSA((IndexedTriangleStripArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof IndexedTriangleFanArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            bl2 = this.intersectITFA((IndexedTriangleFanArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof QuadArray) {
            bl2 = this.intersectQA((QuadArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else if (geometryArray instanceof IndexedQuadArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            bl2 = this.intersectIQA((IndexedQuadArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        } else {
            throw new RuntimeException("incorrect class type");
        }
        if (!bl2) {
            for (int i = 0; i < n4; ++i) {
                PickResult.freePoint3d(point3dArray2[i]);
            }
        }
        return bl2;
    }

    boolean intersectPoint(int[] nArray, int[] nArray2, int n, Point3d[] point3dArray, PickIntersection pickIntersection) {
        Point3d[] point3dArray2 = new Point3d[]{point3dArray[nArray2[0]]};
        if (debug) {
            System.out.println("intersect point, point = " + point3dArray2[0]);
        }
        boolean bl = false;
        switch (this.pickShapeType) {
            case 1: {
                bl = PickResult.intersectPntAndRay(point3dArray2[0], this.pickShapeStart, this.pickShapeDir, pickIntersection);
                break;
            }
            case 2: {
                if (!PickResult.intersectPntAndRay(point3dArray2[0], this.pickShapeStart, this.pickShapeDir, pickIntersection) || !(pickIntersection.getDistance() <= 1.0)) break;
                bl = true;
                break;
            }
            case 4: {
                bl = ((BoundingBox)this.pickShapeBounds).intersect(point3dArray2[0]);
                pickIntersection.setPointCoordinatesVW(point3dArray2[0]);
                break;
            }
            case 5: {
                bl = ((BoundingSphere)this.pickShapeBounds).intersect(point3dArray2[0]);
                pickIntersection.setPointCoordinatesVW(point3dArray2[0]);
                break;
            }
            case 6: {
                bl = ((BoundingPolytope)this.pickShapeBounds).intersect(point3dArray2[0]);
                pickIntersection.setPointCoordinatesVW(point3dArray2[0]);
                break;
            }
            case 7: {
                bl = PickResult.intersectCylinder(point3dArray2[0], (PickCylinder)this.pickShape, pickIntersection);
                break;
            }
            case 8: {
                bl = PickResult.intersectCone(point3dArray2[0], (PickCone)this.pickShape, pickIntersection);
            }
        }
        if (bl) {
            PickIntersection pickIntersection2 = new PickIntersection(this, pickIntersection.geom);
            pickIntersection2.iGeom = pickIntersection.iGeom;
            pickIntersection2.setDistance(pickIntersection.distance);
            pickIntersection2.setPointCoordinatesVW(pickIntersection.getPointCoordinatesVW());
            pickIntersection2.setGeomIndex(n);
            pickIntersection2.setVertexIndices(nArray);
            pickIntersection2.setPrimitiveCoordinatesVW(point3dArray2);
            this.intersections.add(pickIntersection2);
            return true;
        }
        return false;
    }

    boolean intersectLine(int[] nArray, int[] nArray2, int n, Point3d[] point3dArray, PickIntersection pickIntersection) {
        Point3d[] point3dArray2 = new Point3d[]{point3dArray[nArray2[0]], point3dArray[nArray2[1]]};
        boolean bl = false;
        switch (this.pickShapeType) {
            case 1: {
                bl = PickResult.intersectLineAndRay(point3dArray2[0], point3dArray2[1], this.pickShapeStart, this.pickShapeDir, pickIntersection);
                break;
            }
            case 2: {
                if (!PickResult.intersectLineAndRay(point3dArray2[0], point3dArray2[1], this.pickShapeStart, this.pickShapeDir, pickIntersection) || !(pickIntersection.getDistance() <= 1.0)) break;
                bl = true;
                break;
            }
            case 4: {
                bl = PickResult.intersectBoundingBox(point3dArray2, (BoundingBox)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 5: {
                bl = PickResult.intersectBoundingSphere(point3dArray2, (BoundingSphere)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 6: {
                bl = PickResult.intersectBoundingPolytope(point3dArray2, (BoundingPolytope)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 7: {
                bl = PickResult.intersectCylinder(point3dArray2, (PickCylinder)this.pickShape, pickIntersection);
                break;
            }
            case 8: {
                bl = PickResult.intersectCone(point3dArray2, (PickCone)this.pickShape, pickIntersection);
            }
        }
        if (bl) {
            PickIntersection pickIntersection2 = new PickIntersection(this, pickIntersection.geom);
            pickIntersection2.iGeom = pickIntersection.iGeom;
            pickIntersection2.setDistance(pickIntersection.distance);
            pickIntersection2.setPointCoordinatesVW(pickIntersection.getPointCoordinatesVW());
            pickIntersection2.setGeomIndex(n);
            pickIntersection2.setVertexIndices(nArray);
            pickIntersection2.setPrimitiveCoordinatesVW(point3dArray2);
            this.intersections.add(pickIntersection2);
            return true;
        }
        return false;
    }

    boolean intersectTri(int[] nArray, int[] nArray2, int n, Point3d[] point3dArray, PickIntersection pickIntersection) {
        Point3d[] point3dArray2 = new Point3d[]{point3dArray[nArray2[0]], point3dArray[nArray2[1]], point3dArray[nArray2[2]]};
        boolean bl = false;
        switch (this.pickShapeType) {
            case 1: {
                bl = PickResult.intersectRay(point3dArray2, (PickRay)this.pickShape, pickIntersection);
                break;
            }
            case 2: {
                bl = PickResult.intersectSegment(point3dArray2, (PickSegment)this.pickShape, pickIntersection);
                break;
            }
            case 4: {
                bl = PickResult.intersectBoundingBox(point3dArray2, (BoundingBox)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 5: {
                bl = PickResult.intersectBoundingSphere(point3dArray2, (BoundingSphere)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 6: {
                bl = PickResult.intersectBoundingPolytope(point3dArray2, (BoundingPolytope)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 7: {
                bl = PickResult.intersectCylinder(point3dArray2, (PickCylinder)this.pickShape, pickIntersection);
                break;
            }
            case 8: {
                bl = PickResult.intersectCone(point3dArray2, (PickCone)this.pickShape, pickIntersection);
            }
        }
        if (bl) {
            PickIntersection pickIntersection2 = new PickIntersection(this, pickIntersection.geom);
            pickIntersection2.iGeom = pickIntersection.iGeom;
            pickIntersection2.setDistance(pickIntersection.distance);
            pickIntersection2.setPointCoordinatesVW(pickIntersection.getPointCoordinatesVW());
            pickIntersection2.setGeomIndex(n);
            pickIntersection2.setVertexIndices(nArray);
            pickIntersection2.setPrimitiveCoordinatesVW(point3dArray2);
            this.intersections.add(pickIntersection2);
            return true;
        }
        return false;
    }

    boolean intersectQuad(int[] nArray, int[] nArray2, int n, Point3d[] point3dArray, PickIntersection pickIntersection) {
        Point3d[] point3dArray2 = new Point3d[]{point3dArray[nArray2[0]], point3dArray[nArray2[1]], point3dArray[nArray2[2]], point3dArray[nArray2[3]]};
        boolean bl = false;
        switch (this.pickShapeType) {
            case 1: {
                bl = PickResult.intersectRay(point3dArray2, (PickRay)this.pickShape, pickIntersection);
                break;
            }
            case 2: {
                bl = PickResult.intersectSegment(point3dArray2, (PickSegment)this.pickShape, pickIntersection);
                break;
            }
            case 4: {
                bl = PickResult.intersectBoundingBox(point3dArray2, (BoundingBox)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 5: {
                bl = PickResult.intersectBoundingSphere(point3dArray2, (BoundingSphere)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 6: {
                bl = PickResult.intersectBoundingPolytope(point3dArray2, (BoundingPolytope)this.pickShapeBounds);
                pickIntersection.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 7: {
                bl = PickResult.intersectCylinder(point3dArray2, (PickCylinder)this.pickShape, pickIntersection);
                break;
            }
            case 8: {
                bl = PickResult.intersectCone(point3dArray2, (PickCone)this.pickShape, pickIntersection);
            }
        }
        if (bl) {
            PickIntersection pickIntersection2 = new PickIntersection(this, pickIntersection.geom);
            pickIntersection2.iGeom = pickIntersection.iGeom;
            pickIntersection2.setDistance(pickIntersection.distance);
            pickIntersection2.setPointCoordinatesVW(pickIntersection.getPointCoordinatesVW());
            pickIntersection2.setGeomIndex(n);
            pickIntersection2.setVertexIndices(nArray);
            pickIntersection2.setPrimitiveCoordinatesVW(point3dArray2);
            this.intersections.add(pickIntersection2);
            return true;
        }
        return false;
    }

    boolean intersectPA(PointArray pointArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: PointArray");
        }
        int[] nArray = new int[1];
        int n2 = 0;
        for (int i = 0; i < point3dArray.length; ++i) {
            nArray[0] = i;
            if (!this.intersectPoint(nArray, nArray, n, point3dArray, pickIntersection)) continue;
            ++n2;
            if (!bl) continue;
            return true;
        }
        return n2 > 0;
    }

    boolean intersectIPA(IndexedPointArray indexedPointArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedPointArray");
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = 0;
        int n3 = indexedPointArray.getIndexCount();
        for (int i = 0; i < n3; ++i) {
            nArray[0] = i;
            nArray2[0] = indexedPointArray.getCoordinateIndex(i);
            if (!this.intersectPoint(nArray, nArray2, n, point3dArray, pickIntersection)) continue;
            ++n2;
            if (!bl) continue;
            return true;
        }
        return n2 > 0;
    }

    boolean intersectLA(LineArray lineArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: LineArray");
        }
        int[] nArray = new int[2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < point3dArray.length) {
            nArray[0] = n3++;
            nArray[1] = n3++;
            if (!this.intersectLine(nArray, nArray, n, point3dArray, pickIntersection)) continue;
            ++n2;
            if (!bl) continue;
            return true;
        }
        return n2 > 0;
    }

    boolean intersectLSA(LineStripArray lineStripArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        int n2 = 0;
        int[] nArray = new int[lineStripArray.getNumStrips()];
        lineStripArray.getStripVertexCounts(nArray);
        int n3 = 0;
        if (debug) {
            System.out.println("intersect: LineStripArray");
        }
        int[] nArray2 = new int[2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[0] = n3;
            int n4 = n3 + nArray[i];
            for (int j = n3 + 1; j < n4; ++j) {
                nArray2[1] = j;
                if (this.intersectLine(nArray2, nArray2, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                nArray2[0] = nArray2[1];
            }
            n3 += nArray[i];
        }
        return n2 > 0;
    }

    boolean intersectILA(IndexedLineArray indexedLineArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        int n2 = 0;
        int n3 = indexedLineArray.getIndexCount();
        if (debug) {
            System.out.println("intersect: IndexedLineArray");
        }
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n4 = 0;
        while (n4 < n3) {
            nArray[0] = n4;
            nArray2[0] = indexedLineArray.getCoordinateIndex(n4++);
            nArray[1] = n4;
            nArray2[1] = indexedLineArray.getCoordinateIndex(n4++);
            if (!this.intersectLine(nArray, nArray2, n, point3dArray, pickIntersection)) continue;
            ++n2;
            if (!bl) continue;
            return true;
        }
        return n2 > 0;
    }

    boolean intersectILSA(IndexedLineStripArray indexedLineStripArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedLineStripArray");
        }
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n2 = 0;
        int[] nArray3 = new int[indexedLineStripArray.getNumStrips()];
        indexedLineStripArray.getStripIndexCounts(nArray3);
        int n3 = 0;
        for (int i = 0; i < nArray3.length; ++i) {
            nArray[0] = n3;
            nArray2[0] = indexedLineStripArray.getCoordinateIndex(n3);
            int n4 = n3 + nArray3[i];
            for (int j = n3 + 1; j < n4; ++j) {
                nArray[1] = j;
                nArray2[1] = indexedLineStripArray.getCoordinateIndex(j);
                if (this.intersectLine(nArray, nArray2, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                nArray[0] = nArray[1];
                nArray2[0] = nArray2[1];
            }
            n3 += nArray3[i];
        }
        return n2 > 0;
    }

    boolean intersectTA(TriangleArray triangleArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: TriangleArray");
        }
        int[] nArray = new int[3];
        int n2 = 0;
        int n3 = 0;
        while (n3 < point3dArray.length) {
            nArray[0] = n3++;
            nArray[1] = n3++;
            nArray[2] = n3++;
            if (!this.intersectTri(nArray, nArray, n, point3dArray, pickIntersection)) continue;
            ++n2;
            if (!bl) continue;
            return true;
        }
        return n2 > 0;
    }

    boolean intersectITA(IndexedTriangleArray indexedTriangleArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleArray");
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n2 = 0;
        int n3 = indexedTriangleArray.getIndexCount();
        int n4 = 0;
        while (n4 < n3) {
            nArray[0] = n4;
            nArray2[0] = indexedTriangleArray.getCoordinateIndex(n4++);
            nArray[1] = n4;
            nArray2[1] = indexedTriangleArray.getCoordinateIndex(n4++);
            nArray[2] = n4;
            nArray2[2] = indexedTriangleArray.getCoordinateIndex(n4++);
            if (!this.intersectTri(nArray, nArray2, n, point3dArray, pickIntersection)) continue;
            ++n2;
            if (!bl) continue;
            return true;
        }
        return n2 > 0;
    }

    boolean intersectTSA(TriangleStripArray triangleStripArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: TriangleStripArray");
        }
        int n2 = 0;
        int[] nArray = new int[triangleStripArray.getNumStrips()];
        triangleStripArray.getStripVertexCounts(nArray);
        int n3 = 0;
        int[] nArray2 = new int[3];
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = n3;
            boolean bl2 = true;
            nArray2[0] = n4++;
            nArray2[1] = n4++;
            int n5 = n4 + nArray[i] - 2;
            for (int j = n4; j < n5; ++j) {
                nArray2[2] = j;
                if (this.intersectTri(nArray2, nArray2, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                nArray2[0] = nArray2[1];
                nArray2[1] = nArray2[2];
            }
            n3 += nArray[i];
        }
        return n2 > 0;
    }

    boolean intersectITSA(IndexedTriangleStripArray indexedTriangleStripArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleStripArray");
        }
        int n2 = 0;
        int[] nArray = new int[indexedTriangleStripArray.getNumStrips()];
        indexedTriangleStripArray.getStripIndexCounts(nArray);
        int n3 = 0;
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = n3;
            boolean bl2 = true;
            nArray3[0] = indexedTriangleStripArray.getCoordinateIndex(n4);
            nArray2[0] = n4++;
            nArray3[1] = indexedTriangleStripArray.getCoordinateIndex(n4);
            nArray2[1] = n4++;
            int n5 = n4 + nArray[i] - 2;
            for (int j = n4; j < n5; ++j) {
                if (bl2) {
                    nArray2[2] = j;
                    nArray3[2] = indexedTriangleStripArray.getCoordinateIndex(j);
                } else {
                    nArray2[1] = j;
                    nArray3[1] = indexedTriangleStripArray.getCoordinateIndex(j);
                }
                if (this.intersectTri(nArray2, nArray3, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                if (bl2) {
                    nArray2[0] = nArray2[1];
                    nArray3[0] = nArray3[1];
                    bl2 = false;
                    continue;
                }
                nArray2[0] = nArray2[2];
                nArray3[0] = nArray3[2];
                bl2 = true;
            }
            n3 += nArray[i];
        }
        return n2 > 0;
    }

    boolean intersectTFA(TriangleFanArray triangleFanArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: TriangleFanArray");
        }
        int n2 = 0;
        int[] nArray = new int[triangleFanArray.getNumStrips()];
        triangleFanArray.getStripVertexCounts(nArray);
        int n3 = 0;
        int[] nArray2 = new int[3];
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = n3;
            nArray2[0] = n4++;
            nArray2[1] = n4++;
            int n5 = n4 + nArray[i] - 2;
            for (int j = n4; j < n5; ++j) {
                nArray2[2] = j;
                if (this.intersectTri(nArray2, nArray2, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                nArray2[1] = nArray2[2];
            }
            n3 += nArray[i];
        }
        return n2 > 0;
    }

    boolean intersectITFA(IndexedTriangleFanArray indexedTriangleFanArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleFanArray");
        }
        int n2 = 0;
        int[] nArray = new int[indexedTriangleFanArray.getNumStrips()];
        indexedTriangleFanArray.getStripIndexCounts(nArray);
        int n3 = 0;
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = n3;
            nArray3[0] = indexedTriangleFanArray.getCoordinateIndex(n4);
            nArray2[0] = n4++;
            nArray3[1] = indexedTriangleFanArray.getCoordinateIndex(n4);
            nArray2[1] = n4++;
            int n5 = n4 + nArray[i] - 2;
            for (int j = n4; j < n5; ++j) {
                nArray2[2] = j;
                nArray3[2] = indexedTriangleFanArray.getCoordinateIndex(j);
                if (this.intersectTri(nArray2, nArray3, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                nArray2[1] = nArray2[2];
                nArray3[1] = nArray3[2];
            }
            n3 += nArray[i];
        }
        return n2 > 0;
    }

    boolean intersectQA(QuadArray quadArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: QuadArray");
        }
        int[] nArray = new int[4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < point3dArray.length) {
            nArray[0] = n3++;
            nArray[1] = n3++;
            nArray[2] = n3++;
            nArray[3] = n3++;
            if (!this.intersectQuad(nArray, nArray, n, point3dArray, pickIntersection)) continue;
            ++n2;
            if (!bl) continue;
            return true;
        }
        return n2 > 0;
    }

    final boolean intersectIQA(IndexedQuadArray indexedQuadArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedQuadArray");
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n2 = 0;
        int n3 = indexedQuadArray.getIndexCount();
        int n4 = 0;
        while (n4 < n3) {
            nArray[0] = n4;
            nArray2[0] = indexedQuadArray.getCoordinateIndex(n4++);
            nArray[1] = n4;
            nArray2[1] = indexedQuadArray.getCoordinateIndex(n4++);
            nArray[2] = n4;
            nArray2[2] = indexedQuadArray.getCoordinateIndex(n4++);
            nArray[3] = n4;
            nArray2[3] = indexedQuadArray.getCoordinateIndex(n4++);
            if (!this.intersectQuad(nArray, nArray2, n, point3dArray, pickIntersection)) continue;
            ++n2;
            if (!bl) continue;
            return true;
        }
        return n2 > 0;
    }

    static boolean intersectBoundingBox(Point3d[] point3dArray, BoundingBox boundingBox) {
        int n;
        int[] nArray = new int[6];
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        boundingBox.getLower(point3d);
        boundingBox.getUpper(point3d2);
        for (n = 0; n < 6; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < point3dArray.length; ++n) {
            if (point3dArray[n].x >= point3d.x && point3dArray[n].x <= point3d2.x && point3dArray[n].y >= point3d.y && point3dArray[n].y <= point3d2.y && point3dArray[n].z >= point3d.z && point3dArray[n].z <= point3d2.z) {
                return true;
            }
            if (point3dArray[n].x < point3d.x) {
                nArray[0] = nArray[0] + 1;
            }
            if (point3dArray[n].y < point3d.y) {
                nArray[1] = nArray[1] + 1;
            }
            if (point3dArray[n].z < point3d.z) {
                nArray[2] = nArray[2] + 1;
            }
            if (point3dArray[n].x > point3d2.x) {
                nArray[3] = nArray[3] + 1;
            }
            if (point3dArray[n].y > point3d2.y) {
                nArray[4] = nArray[4] + 1;
            }
            if (!(point3dArray[n].z > point3d2.z)) continue;
            nArray[5] = nArray[5] + 1;
        }
        if (nArray[0] == point3dArray.length || nArray[1] == point3dArray.length || nArray[2] == point3dArray.length || nArray[3] == point3dArray.length || nArray[4] == point3dArray.length || nArray[5] == point3dArray.length) {
            return false;
        }
        Point3d[] point3dArray2 = new Point3d[4];
        for (n = 0; n < 4; ++n) {
            point3dArray2[n] = new Point3d();
        }
        point3dArray2[0].set(point3d.x, point3d.y, point3d.z);
        point3dArray2[1].set(point3d.x, point3d.y, point3d2.z);
        point3dArray2[2].set(point3d.x, point3d2.y, point3d2.z);
        point3dArray2[3].set(point3d.x, point3d2.y, point3d.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d.y, point3d.z);
        point3dArray2[1].set(point3d2.x, point3d2.y, point3d.z);
        point3dArray2[2].set(point3d2.x, point3d2.y, point3d2.z);
        point3dArray2[3].set(point3d2.x, point3d.y, point3d2.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d.y, point3d2.z);
        point3dArray2[1].set(point3d.x, point3d.y, point3d2.z);
        point3dArray2[2].set(point3d.x, point3d.y, point3d.z);
        point3dArray2[3].set(point3d2.x, point3d.y, point3d.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d2.y, point3d2.z);
        point3dArray2[1].set(point3d2.x, point3d2.y, point3d.z);
        point3dArray2[2].set(point3d.x, point3d2.y, point3d.z);
        point3dArray2[3].set(point3d.x, point3d2.y, point3d2.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d2.y, point3d2.z);
        point3dArray2[1].set(point3d.x, point3d2.y, point3d2.z);
        point3dArray2[2].set(point3d.x, point3d.y, point3d2.z);
        point3dArray2[3].set(point3d2.x, point3d.y, point3d2.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d2.y, point3d.z);
        point3dArray2[1].set(point3d2.x, point3d.y, point3d.z);
        point3dArray2[2].set(point3d.x, point3d.y, point3d.z);
        point3dArray2[3].set(point3d.x, point3d2.y, point3d.z);
        return PickResult.intersectPolygon(point3dArray2, point3dArray, false);
    }

    static boolean intersectBoundingSphere(Point3d[] point3dArray, BoundingSphere boundingSphere) {
        int n;
        int n2;
        Vector3d vector3d = new Vector3d();
        Point3d point3d = new Point3d();
        boundingSphere.getCenter(point3d);
        double d = boundingSphere.getRadius();
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            vector3d.x = point3dArray[n2].x - point3d.x;
            vector3d.y = point3dArray[n2].y - point3d.y;
            vector3d.z = point3dArray[n2].z - point3d.z;
            if (!(vector3d.length() <= d)) continue;
            return true;
        }
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            boolean bl = n2 < point3dArray.length - 1 ? PickResult.edgeIntersectSphere(boundingSphere, point3dArray[n2], point3dArray[n2 + 1]) : PickResult.edgeIntersectSphere(boundingSphere, point3dArray[n2], point3dArray[0]);
            if (!bl) continue;
            return true;
        }
        if (point3dArray.length < 3) {
            return false;
        }
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Point3d point3d2 = new Point3d();
        n2 = 0;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2++].z;
            if (!(vector3d2.length() > 0.0)) continue;
        }
        for (n = n2; n < point3dArray.length - 1; ++n) {
            vector3d3.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d3.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d3.z = point3dArray[n + 1].z - point3dArray[n].z;
            if (vector3d3.length() > 0.0) break;
        }
        if (n == point3dArray.length - 1) {
            return false;
        }
        vector3d4.cross(vector3d2, vector3d3);
        double d2 = vector3d4.lengthSquared();
        if (d2 == 0.0) {
            return false;
        }
        vector3d5.x = point3dArray[0].x - point3d.x;
        vector3d5.y = point3dArray[0].y - point3d.y;
        vector3d5.z = point3dArray[0].z - point3d.z;
        double d3 = vector3d4.dot(vector3d5);
        double d4 = Math.sqrt(d3 * d3 / d2);
        if (d4 > d) {
            return false;
        }
        double d5 = d3 / d2;
        point3d2.x = point3d.x + d5 * vector3d4.x;
        point3d2.y = point3d.y + d5 * vector3d4.y;
        point3d2.z = point3d.z + d5 * vector3d4.z;
        return PickResult.pointIntersectPolygon2D(vector3d4, point3dArray, point3d2);
    }

    static boolean intersectBoundingPolytope(Point3d[] point3dArray, BoundingPolytope boundingPolytope) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        double d = -1.0;
        Point4d point4d = new Point4d();
        Vector4d[] vector4dArray = new Vector4d[boundingPolytope.getNumPlanes()];
        for (n5 = 0; n5 < vector4dArray.length; ++n5) {
            vector4dArray[n5] = new Vector4d();
        }
        boundingPolytope.getPlanes(vector4dArray);
        if (point3dArray.length == 2) {
            throw new RuntimeException("TODO: must make polytope.intersect(coordinates[0], coordinates[1], tP4d) public!");
        }
        if (bl) {
            System.out.println("The value of the input vertices are: ");
            for (n5 = 0; n5 < point3dArray.length; ++n5) {
                System.out.println("The " + n5 + " th vertex is: " + point3dArray[n5]);
            }
            System.out.println("The value of the input bounding Polytope's planes =");
            for (n5 = 0; n5 < vector4dArray.length; ++n5) {
                System.out.println("The " + n5 + " th plane is: " + vector4dArray[n5]);
            }
        }
        double[] dArray = new double[]{0.8, 0.9, 1.1, 1.2};
        boolean bl2 = true;
        boolean bl3 = false;
        if (bl3) {
            for (n4 = 0; n4 < point3dArray.length; ++n4) {
                for (n3 = 0; n3 < vector4dArray.length; ++n3) {
                    if (!(vector4dArray[n3].x * point3dArray[n4].x + vector4dArray[n3].y * point3dArray[n4].y + vector4dArray[n3].z * point3dArray[n4].z <= d * vector4dArray[n3].w)) {
                        bl2 = false;
                        break;
                    }
                    bl2 = true;
                }
                if (!bl2) continue;
                return true;
            }
        }
        n4 = vector4dArray.length + 2 + point3dArray.length + 1;
        n3 = 1 + point3dArray.length;
        double[][] dArray2 = new double[n3][n4];
        for (n2 = 0; n2 < vector4dArray.length; ++n2) {
            for (n = 0; n < point3dArray.length; ++n) {
                dArray2[n][n2] = -1.0 * (vector4dArray[n2].x * point3dArray[n].x + vector4dArray[n2].y * point3dArray[n].y + vector4dArray[n2].z * point3dArray[n].z);
            }
        }
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            dArray2[n2][vector4dArray.length] = -1.0;
            dArray2[n2][vector4dArray.length + 1] = 1.0;
            for (n = 0; n < point3dArray.length; ++n) {
                dArray2[n2][n + vector4dArray.length + 2] = n2 == n ? 1.0 : 0.0;
                dArray2[n2][n4 - 1] = dArray[n2];
            }
        }
        for (n2 = 0; n2 < vector4dArray.length; ++n2) {
            dArray2[n3 - 1][n2] = d * vector4dArray[n2].w;
        }
        dArray2[n3 - 1][vector4dArray.length] = 1.0;
        dArray2[n3 - 1][vector4dArray.length + 1] = -1.0;
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            dArray2[n3 - 1][vector4dArray.length + 2 + n2] = 0.0;
        }
        if (bl) {
            System.out.println("The value of the problem tableau is: ");
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                for (n = 0; n < dArray2[0].length; ++n) {
                    System.out.print(dArray2[n2][n] + "  ");
                }
                System.out.println();
            }
        }
        double d2 = PickResult.generalStandardSimplexSolver(dArray2, Double.NEGATIVE_INFINITY);
        if (bl) {
            System.out.println("The value returned by the general standard simplex = " + d2);
        }
        return d2 != Double.POSITIVE_INFINITY;
    }

    static double generalStandardSimplexSolver(double[][] dArray, double d) {
        boolean bl = false;
        int n = dArray.length;
        int n2 = dArray[0].length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            System.out.println("The number of rows is : " + n);
            System.out.println("The number of columns is : " + n2);
        }
        while (!bl2) {
            double d2;
            int n3;
            if (bl) {
                System.out.println("input problem tableau is:");
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        System.out.println("kth, jth value is:" + i + " " + j + " : " + dArray[i][j]);
                    }
                }
            }
            double d3 = 0.0;
            int n4 = -1;
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                d2 = dArray[n - 1][n3];
                if (!(d2 < d3)) continue;
                d3 = d2;
                n4 = n3;
            }
            if (n4 == -1) {
                bl2 = true;
            }
            if (bl2) continue;
            double d4 = Double.POSITIVE_INFINITY;
            double d5 = 0.0;
            int n5 = -1;
            for (n3 = 0; n3 < n - 1; ++n3) {
                d2 = dArray[n3][n4];
                double d6 = dArray[n3][n2 - 1];
                if (d2 == 0.0) {
                    if (!bl) continue;
                    System.out.println("Division by zero has occurred");
                    System.out.println("Within the linear program solver");
                    System.out.println("Ignoring the zero as a potential pivot");
                    continue;
                }
                if (d2 < 0.0 || d6 < 0.0) {
                    if (!bl) continue;
                    System.out.println("Ignoring cases where element is negative");
                    System.out.println("The value of element is: " + d2);
                    System.out.println("The value of end Element is: " + d6);
                    continue;
                }
                d5 = d6 / d2;
                if (bl) {
                    System.out.println("The value of element is: " + d2);
                    System.out.println("The value of endElement is: " + d6);
                    System.out.println("The value of ratio is: " + d5);
                    System.out.println("The value of prevRatio is: " + d4);
                    System.out.println("Value of ratio <= prevRatio is :" + (d5 <= d4));
                }
                if (!(d5 <= d4)) continue;
                if (bl) {
                    System.out.println("updating prevRatio with ratio");
                }
                d4 = d5;
                n5 = n3;
            }
            if (n5 == -1) {
                if (bl) {
                    System.out.println("UNABLE TO FIND SOLUTION");
                    System.out.println("The system is infeasable or unbounded");
                }
                return Double.POSITIVE_INFINITY;
            }
            double d7 = dArray[n5][n4];
            if (bl) {
                System.out.println("The value of row index is: " + n5);
                System.out.println("The value of col index is: " + n4);
                System.out.println("The value of pivotValue is: " + d7);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dArray[n5][n3] = dArray[n5][n3] / d7;
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (n3 == n5) continue;
                double d8 = dArray[n3][n4];
                for (int i = 0; i < n2; ++i) {
                    dArray[n3][i] = dArray[n3][i] - d8 * dArray[n5][i];
                }
            }
        }
        return dArray[n - 1][n2 - 1];
    }

    static boolean edgeIntersectSphere(BoundingSphere boundingSphere, Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d3 = new Point3d();
        boundingSphere.getCenter(point3d3);
        double d = boundingSphere.getRadius();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        double d2 = vector3d.dot(vector3d2);
        if (d2 < 0.0) {
            return false;
        }
        double d3 = vector3d.lengthSquared();
        double d4 = d2 * d2 / d3;
        if (d4 < d3) {
            return false;
        }
        double d5 = d * d;
        double d6 = vector3d2.lengthSquared();
        return d6 - d4 <= d5;
    }

    static double det2D(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return (point2d3.x - point2d.x) * (point2d.y - point2d2.y) + (point2d.y - point2d3.y) * (point2d.x - point2d2.x);
    }

    static boolean pointIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d point3d) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d point2d = new Point2d();
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (n == 1 && d2 < d3) {
            n = 2;
        }
        block10: for (int i = 0; i < point3dArray.length; ++i) {
            point2dArray[i] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray[i].x = point3dArray[i].y;
                    point2dArray[i].y = point3dArray[i].z;
                    continue block10;
                }
                case 1: {
                    point2dArray[i].x = point3dArray[i].x;
                    point2dArray[i].y = point3dArray[i].z;
                    continue block10;
                }
                case 2: {
                    point2dArray[i].x = point3dArray[i].x;
                    point2dArray[i].y = point3dArray[i].y;
                }
            }
        }
        switch (n) {
            case 0: {
                point2d.x = point3d.y;
                point2d.y = point3d.z;
                break;
            }
            case 1: {
                point2d.x = point3d.x;
                point2d.y = point3d.z;
                break;
            }
            case 2: {
                point2d.x = point3d.x;
                point2d.y = point3d.y;
            }
        }
        for (int i = 0; i < point3dArray.length; ++i) {
            if (i < point3dArray.length - 1) {
                if (PickResult.det2D(point2dArray[i], point2dArray[i + 1], point2d) > 0.0) continue;
                return false;
            }
            if (PickResult.det2D(point2dArray[i], point2dArray[0], point2d) > 0.0) continue;
            return false;
        }
        return true;
    }

    static boolean edgeIntersectPlane(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d2.set((Tuple3d)point3d);
        double d = vector3d.dot(vector3d2);
        vector3d3.x = point3d3.x - point3d2.x;
        vector3d3.y = point3d3.y - point3d2.y;
        vector3d3.z = point3d3.z - point3d2.z;
        double d2 = vector3d.dot(vector3d3);
        if (d2 == 0.0) {
            return false;
        }
        vector3d2.set((Tuple3d)point3d2);
        double d3 = (d - vector3d.dot(vector3d2)) / d2;
        if (d3 < 0.0 || d3 > 1.0) {
            return false;
        }
        point3d4.x = point3d2.x + d3 * vector3d3.x;
        point3d4.y = point3d2.y + d3 * vector3d3.y;
        point3d4.z = point3d2.z + d3 * vector3d3.z;
        return true;
    }

    static boolean edgeIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d[] point3dArray2) {
        int n;
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d[] point2dArray2 = new Point2d[2];
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n2 = d > d2 ? 0 : 1;
        if (n2 == 0) {
            if (d < d3) {
                n2 = 2;
            }
        } else if (n2 == 1 && d2 < d3) {
            n2 = 2;
        }
        block10: for (n = 0; n < point3dArray.length; ++n) {
            point2dArray[n] = new Point2d();
            switch (n2) {
                case 0: {
                    point2dArray[n].x = point3dArray[n].y;
                    point2dArray[n].y = point3dArray[n].z;
                    continue block10;
                }
                case 1: {
                    point2dArray[n].x = point3dArray[n].x;
                    point2dArray[n].y = point3dArray[n].z;
                    continue block10;
                }
                case 2: {
                    point2dArray[n].x = point3dArray[n].x;
                    point2dArray[n].y = point3dArray[n].y;
                }
            }
        }
        block11: for (n = 0; n < 2; ++n) {
            point2dArray2[n] = new Point2d();
            switch (n2) {
                case 0: {
                    point2dArray2[n].x = point3dArray2[n].y;
                    point2dArray2[n].y = point3dArray2[n].z;
                    continue block11;
                }
                case 1: {
                    point2dArray2[n].x = point3dArray2[n].x;
                    point2dArray2[n].y = point3dArray2[n].z;
                    continue block11;
                }
                case 2: {
                    point2dArray2[n].x = point3dArray2[n].x;
                    point2dArray2[n].y = point3dArray2[n].y;
                }
            }
        }
        boolean[][] blArray = new boolean[2][point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            for (n = 0; n < 2; ++n) {
                blArray[n][i] = i < point3dArray.length - 1 ? PickResult.det2D(point2dArray[i], point2dArray[i + 1], point2dArray2[n]) < 0.0 : PickResult.det2D(point2dArray[i], point2dArray[0], point2dArray2[n]) < 0.0;
            }
            if (blArray[0][i] || blArray[1][i]) continue;
            return false;
        }
        boolean bl = true;
        for (n = 0; n < point3dArray.length; ++n) {
            if (blArray[0][n]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        bl = true;
        for (n = 0; n < point3dArray.length; ++n) {
            if (blArray[1][n]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        int n3 = 0;
        for (n = 0; n < point3dArray.length; ++n) {
            if (!(PickResult.det2D(point2dArray2[0], point2dArray2[1], point2dArray[n]) < 0.0)) continue;
            ++n3;
        }
        return n3 != 0 && n3 != point3dArray.length;
    }

    static boolean intersectPolygon(Point3d[] point3dArray, Point3d[] point3dArray2, boolean bl) {
        boolean bl2;
        int n;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        int n2 = 0;
        while (n2 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d.z = point3dArray[n2 + 1].z - point3dArray[n2++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n = n2; n < point3dArray.length - 1; ++n) {
            vector3d2.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d2.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d2.z = point3dArray[n + 1].z - point3dArray[n].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        if (bl) {
            // empty if block
        }
        n = 0;
        Point3d[] point3dArray3 = new Point3d[]{new Point3d(), new Point3d()};
        for (n2 = 0; !(n2 >= point3dArray2.length || (bl2 = n2 < point3dArray2.length - 1 ? PickResult.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n2], point3dArray2[n2 + 1], point3dArray3[n]) : PickResult.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n2], point3dArray2[0], point3dArray3[n])) && ++n > 1); ++n2) {
        }
        if (n == 0) {
            return false;
        }
        if (point3dArray2.length < 3) {
            return PickResult.pointIntersectPolygon2D(vector3d3, point3dArray, point3dArray3[0]);
        }
        return PickResult.edgeIntersectPolygon2D(vector3d3, point3dArray, point3dArray3);
    }

    static final boolean isNonZero(double d) {
        return d > 1.0E-13 || d < -1.0E-13;
    }

    static boolean intersectRay(Point3d[] point3dArray, PickRay pickRay, PickIntersection pickIntersection) {
        Point3d point3d = PickResult.getPoint3d();
        Vector3d vector3d = PickResult.getVector3d();
        pickRay.get(point3d, vector3d);
        boolean bl = PickResult.intersectRayOrSegment(point3dArray, vector3d, point3d, pickIntersection, false);
        PickResult.freeVector3d(vector3d);
        PickResult.freePoint3d(point3d);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean intersectRayOrSegment(Point3d[] point3dArray, Vector3d vector3d, Point3d point3d, PickIntersection pickIntersection, boolean bl) {
        Point3d point3d2;
        double d;
        Vector3d vector3d2;
        boolean bl2;
        Vector3d vector3d3;
        Vector3d vector3d4;
        Vector3d vector3d5;
        block30: {
            Point3d point3d3;
            Point3d point3d4;
            double d2;
            int n;
            block36: {
                block37: {
                    block34: {
                        block35: {
                            int n2;
                            block32: {
                                double d3;
                                double d4;
                                block33: {
                                    double d5;
                                    double d6;
                                    block31: {
                                        vector3d5 = PickResult.getVector3d();
                                        vector3d4 = PickResult.getVector3d();
                                        vector3d3 = PickResult.getVector3d();
                                        d6 = 0.0;
                                        d5 = 0.0;
                                        bl2 = false;
                                        n2 = 0;
                                        int n3 = 0;
                                        for (n = 0; n < point3dArray.length; ++n) {
                                            n3 = n != point3dArray.length - 1 ? n + 1 : 0;
                                            vector3d5.x = point3dArray[n3].x - point3dArray[n].x;
                                            vector3d5.y = point3dArray[n3].y - point3dArray[n].y;
                                            vector3d5.z = point3dArray[n3].z - point3dArray[n].z;
                                            if (vector3d5.length() > 0.0) break;
                                        }
                                        for (int i = n3; i < point3dArray.length; ++i) {
                                            n2 = i != point3dArray.length - 1 ? i + 1 : 0;
                                            vector3d4.x = point3dArray[n2].x - point3dArray[i].x;
                                            vector3d4.y = point3dArray[n2].y - point3dArray[i].y;
                                            vector3d4.z = point3dArray[n2].z - point3dArray[i].z;
                                            if (vector3d4.length() > 0.0) break;
                                        }
                                        vector3d3.cross(vector3d5, vector3d4);
                                        if (vector3d4.length() == 0.0 || vector3d3.length() == 0.0) {
                                            n2 = n3 == 0 ? point3dArray.length - 1 : n3 - 1;
                                            bl2 = PickResult.intersectLineAndRay(point3dArray[n3], point3dArray[n2], point3d, vector3d, pickIntersection);
                                            PickResult.freeVector3d(vector3d5);
                                            PickResult.freeVector3d(vector3d4);
                                            PickResult.freeVector3d(vector3d3);
                                            return bl2;
                                        }
                                        d5 = vector3d3.dot(vector3d);
                                        if (d5 != 0.0) break block31;
                                        break block32;
                                    }
                                    vector3d2 = PickResult.getVector3d();
                                    vector3d2.set((Tuple3d)point3dArray[0]);
                                    d6 = vector3d3.dot(vector3d2);
                                    vector3d2.set((Tuple3d)point3d);
                                    d = (d6 - vector3d3.dot(vector3d2)) / d5;
                                    if (d < -1.0E-13 || bl && d > 1.0000000000001) {
                                        PickResult.freeVector3d(vector3d5);
                                        PickResult.freeVector3d(vector3d4);
                                        PickResult.freeVector3d(vector3d3);
                                        PickResult.freeVector3d(vector3d2);
                                        return false;
                                    }
                                    point3d2 = PickResult.getPoint3d();
                                    point3d2.x = point3d.x + vector3d.x * d;
                                    point3d2.y = point3d.y + vector3d.y * d;
                                    point3d2.z = point3d.z + vector3d.z * d;
                                    double d7 = Math.abs(vector3d3.x);
                                    d4 = Math.abs(vector3d3.y);
                                    d3 = Math.abs(vector3d3.z);
                                    d2 = 0.0;
                                    point3d4 = point3dArray[point3dArray.length - 1];
                                    point3d3 = point3dArray[0];
                                    bl2 = true;
                                    if (!(d7 > d4)) break block33;
                                    if (!(d7 < d3)) break block34;
                                    break block35;
                                }
                                if (!(d4 < d3)) break block36;
                                break block37;
                            }
                            for (n = 0; n < point3dArray.length; ++n) {
                                n2 = n != point3dArray.length - 1 ? n + 1 : 0;
                                if (!PickResult.intersectLineAndRay(point3dArray[n], point3dArray[n2], point3d, vector3d, pickIntersection)) continue;
                                bl2 = true;
                                break;
                            }
                            PickResult.freeVector3d(vector3d5);
                            PickResult.freeVector3d(vector3d4);
                            PickResult.freeVector3d(vector3d3);
                            return bl2;
                        }
                        for (n = 0; n < point3dArray.length; ++n) {
                            point3d4 = point3dArray[n];
                            point3d3 = n != point3dArray.length - 1 ? point3dArray[n + 1] : point3dArray[0];
                            double d8 = (point3d2.y - point3d4.y) * (point3d3.x - point3d4.x) - (point3d2.x - point3d4.x) * (point3d3.y - point3d4.y);
                            if (PickResult.isNonZero(d8)) {
                                if (d8 * d2 < 0.0) {
                                    bl2 = false;
                                    break block30;
                                } else {
                                    d2 = d8;
                                    continue;
                                }
                            }
                            double d9 = point3d3.y - point3d4.y;
                            if (PickResult.isNonZero(d9)) {
                                bl2 = (d9 = (point3d2.y - point3d4.y) / d9) > -1.0E-13 && d9 < 1.0000000000001;
                                break block30;
                            } else {
                                d9 = point3d3.x - point3d4.x;
                                if (!PickResult.isNonZero(d9)) continue;
                                bl2 = (d9 = (point3d2.x - point3d4.x) / d9) > -1.0E-13 && d9 < 1.0000000000001;
                            }
                            break block30;
                        }
                        break block30;
                    }
                    for (n = 0; n < point3dArray.length; ++n) {
                        point3d4 = point3dArray[n];
                        point3d3 = n != point3dArray.length - 1 ? point3dArray[n + 1] : point3dArray[0];
                        double d10 = (point3d2.y - point3d4.y) * (point3d3.z - point3d4.z) - (point3d2.z - point3d4.z) * (point3d3.y - point3d4.y);
                        if (PickResult.isNonZero(d10)) {
                            if (d10 * d2 < 0.0) {
                                bl2 = false;
                                break block30;
                            } else {
                                d2 = d10;
                                continue;
                            }
                        }
                        double d11 = point3d3.y - point3d4.y;
                        if (PickResult.isNonZero(d11)) {
                            bl2 = (d11 = (point3d2.y - point3d4.y) / d11) > -1.0E-13 && d11 < 1.0000000000001;
                            break block30;
                        } else {
                            d11 = point3d3.z - point3d4.z;
                            if (!PickResult.isNonZero(d11)) continue;
                            bl2 = (d11 = (point3d2.z - point3d4.z) / d11) > -1.0E-13 && d11 < 1.0000000000001;
                        }
                        break block30;
                    }
                    break block30;
                }
                for (n = 0; n < point3dArray.length; ++n) {
                    point3d4 = point3dArray[n];
                    point3d3 = n != point3dArray.length - 1 ? point3dArray[n + 1] : point3dArray[0];
                    double d12 = (point3d2.y - point3d4.y) * (point3d3.x - point3d4.x) - (point3d2.x - point3d4.x) * (point3d3.y - point3d4.y);
                    if (PickResult.isNonZero(d12)) {
                        if (d12 * d2 < 0.0) {
                            bl2 = false;
                            break block30;
                        } else {
                            d2 = d12;
                            continue;
                        }
                    }
                    double d13 = point3d3.y - point3d4.y;
                    if (PickResult.isNonZero(d13)) {
                        bl2 = (d13 = (point3d2.y - point3d4.y) / d13) > -1.0E-13 && d13 < 1.0000000000001;
                        break block30;
                    } else {
                        d13 = point3d3.x - point3d4.x;
                        if (!PickResult.isNonZero(d13)) continue;
                        bl2 = (d13 = (point3d2.x - point3d4.x) / d13) > -1.0E-13 && d13 < 1.0000000000001;
                    }
                    break block30;
                }
                break block30;
            }
            for (n = 0; n < point3dArray.length; ++n) {
                point3d4 = point3dArray[n];
                point3d3 = n != point3dArray.length - 1 ? point3dArray[n + 1] : point3dArray[0];
                double d14 = (point3d2.x - point3d4.x) * (point3d3.z - point3d4.z) - (point3d2.z - point3d4.z) * (point3d3.x - point3d4.x);
                if (PickResult.isNonZero(d14)) {
                    if (d14 * d2 < 0.0) {
                        bl2 = false;
                        break;
                    } else {
                        d2 = d14;
                        continue;
                    }
                }
                double d15 = point3d3.x - point3d4.x;
                if (PickResult.isNonZero(d15)) {
                    bl2 = (d15 = (point3d2.x - point3d4.x) / d15) > -1.0E-13 && d15 < 1.0000000000001;
                } else {
                    d15 = point3d3.z - point3d4.z;
                    if (!PickResult.isNonZero(d15)) continue;
                    bl2 = (d15 = (point3d2.z - point3d4.z) / d15) > -1.0E-13 && d15 < 1.0000000000001;
                }
                break;
            }
        }
        if (bl2) {
            pickIntersection.setDistance(d * vector3d.length());
            pickIntersection.setPointCoordinatesVW(point3d2);
        }
        PickResult.freeVector3d(vector3d5);
        PickResult.freeVector3d(vector3d4);
        PickResult.freeVector3d(vector3d3);
        PickResult.freeVector3d(vector3d2);
        PickResult.freePoint3d(point3d2);
        return bl2;
    }

    static boolean intersectSegment(Point3d[] point3dArray, PickSegment pickSegment, PickIntersection pickIntersection) {
        Point3d point3d = PickResult.getPoint3d();
        Point3d point3d2 = PickResult.getPoint3d();
        Vector3d vector3d = PickResult.getVector3d();
        pickSegment.get(point3d, point3d2);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        boolean bl = PickResult.intersectRayOrSegment(point3dArray, vector3d, point3d, pickIntersection, true);
        PickResult.freeVector3d(vector3d);
        PickResult.freePoint3d(point3d);
        PickResult.freePoint3d(point3d2);
        return bl;
    }

    static boolean inside(Point3d[] point3dArray, PickPoint pickPoint, int n) {
        int n2;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        Point3d point3d = new Point3d();
        pickPoint.get(point3d);
        int n3 = 0;
        while (n3 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d.z = point3dArray[n3 + 1].z - point3dArray[n3++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n2 = n3; n2 < point3dArray.length - 1; ++n2) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        if (n == 1) {
            vector3d3.cross(vector3d, vector3d2);
        } else {
            vector3d3.cross(vector3d2, vector3d);
        }
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        vector3d4.set((Tuple3d)point3d);
        return !(d - vector3d3.dot(vector3d4) > 0.0);
    }

    static boolean intersectPntAndPnt(Point3d point3d, Point3d point3d2, PickIntersection pickIntersection) {
        if (point3d.x == point3d2.x && point3d.y == point3d2.y && point3d.z == point3d2.z) {
            pickIntersection.setPointCoordinatesVW(point3d);
            pickIntersection.setDistance(0.0);
            return true;
        }
        return false;
    }

    static boolean intersectPntAndRay(Point3d point3d, Point3d point3d2, Vector3d vector3d, PickIntersection pickIntersection) {
        double d;
        double d2;
        int n = 0;
        if (vector3d.x != 0.0) {
            n = 0;
            d2 = (point3d.x - point3d2.x) / vector3d.x;
        } else if (vector3d.y != 0.0) {
            if (point3d.x != point3d2.x) {
                return false;
            }
            n = 1;
            d2 = (point3d.y - point3d2.y) / vector3d.y;
        } else if (vector3d.z != 0.0) {
            if (point3d.x != point3d2.x || point3d.y != point3d2.y) {
                return false;
            }
            n = 2;
            d2 = (point3d.z - point3d2.z) / vector3d.z;
        } else {
            return false;
        }
        if (d2 < 0.0) {
            return false;
        }
        if (n == 0 && (point3d.y < (d = point3d2.y + d2 * vector3d.y) - Double.MIN_VALUE || point3d.y > d + Double.MIN_VALUE)) {
            return false;
        }
        if (n < 2 && (point3d.z < (d = point3d2.z + d2 * vector3d.z) - Double.MIN_VALUE || point3d.z > d + Double.MIN_VALUE)) {
            return false;
        }
        pickIntersection.setPointCoordinatesVW(point3d);
        pickIntersection.setDistance(d2);
        return true;
    }

    static boolean intersectLineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, PickIntersection pickIntersection) {
        Vector3d vector3d2 = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
        double d = vector3d2.x;
        double d2 = -vector3d.y;
        double d3 = vector3d2.y;
        double d4 = -vector3d.x;
        double d5 = d * d2 - d3 * d4;
        if (d5 == 0.0) {
            boolean bl = false;
            if (vector3d2.x == 0.0 && vector3d2.y == 0.0 && vector3d2.z == 0.0 && (bl = PickResult.intersectPntAndRay(point3d, point3d3, vector3d, pickIntersection))) {
                pickIntersection.setPointCoordinatesVW(point3d);
                pickIntersection.setDistance(0.0);
            }
            return bl;
        }
        double d6 = 1.0 / d5;
        double d7 = d6 * d2;
        double d8 = d6 * -d4;
        double d9 = d6 * -d3;
        double d10 = d6 * d;
        d6 = point3d3.x - point3d.x;
        double d11 = point3d3.y - point3d.y;
        double d12 = d7 * d6 + d8 * d11;
        double d13 = d9 * d6 + d10 * d11;
        if (d13 < 0.0) {
            return false;
        }
        if (d12 < 0.0 || d12 > 1.0) {
            return false;
        }
        d6 = point3d3.z + d13 * vector3d.z;
        d11 = point3d.z + d12 * vector3d2.z;
        if (d6 < d11 - Double.MIN_VALUE || d6 > d11 + Double.MIN_VALUE) {
            return false;
        }
        double d14 = d13;
        pickIntersection.setDistance(d14);
        Point3d point3d4 = new Point3d();
        point3d4.scaleAdd(d13, (Tuple3d)vector3d, (Tuple3d)point3d3);
        pickIntersection.setPointCoordinatesVW(point3d4);
        return true;
    }

    static boolean intersectCylinder(Point3d[] point3dArray, PickCylinder pickCylinder, PickIntersection pickIntersection) {
        Point3d point3d = PickResult.getPoint3d();
        Point3d point3d2 = PickResult.getPoint3d();
        Vector3d vector3d = PickResult.getVector3d();
        Point3d point3d3 = PickResult.getPoint3d();
        Point3d point3d4 = PickResult.getPoint3d();
        Vector3d vector3d2 = PickResult.getVector3d();
        pickCylinder.getOrigin(point3d);
        pickCylinder.getDirection(vector3d);
        double d = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d2);
        }
        if (point3dArray.length > 2) {
            if (pickCylinder instanceof PickCylinderRay) {
                if (PickResult.intersectRay(point3dArray, new PickRay(point3d, vector3d), pickIntersection)) {
                    PickResult.freePoint3d(point3d);
                    PickResult.freePoint3d(point3d2);
                    PickResult.freeVector3d(vector3d);
                    PickResult.freePoint3d(point3d3);
                    PickResult.freePoint3d(point3d4);
                    PickResult.freeVector3d(vector3d2);
                    return true;
                }
            } else if (PickResult.intersectSegment(point3dArray, new PickSegment(point3d, point3d2), pickIntersection)) {
                PickResult.freePoint3d(point3d);
                PickResult.freePoint3d(point3d2);
                PickResult.freeVector3d(vector3d);
                PickResult.freePoint3d(point3d3);
                PickResult.freePoint3d(point3d4);
                PickResult.freeVector3d(vector3d2);
                return true;
            }
        }
        for (int i = 0; i < point3dArray.length - 1; ++i) {
            double d2 = pickCylinder instanceof PickCylinderSegment ? Distance.segmentToSegment(point3d, point3d2, point3dArray[i], point3dArray[i + 1], point3d3, point3d4, null) : Distance.rayToSegment(point3d, vector3d, point3dArray[i], point3dArray[i + 1], point3d3, point3d4, null);
            if (!(d2 <= d * d)) continue;
            pickIntersection.setPointCoordinatesVW(point3d4);
            vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d);
            pickIntersection.setDistance(vector3d2.length());
            PickResult.freePoint3d(point3d);
            PickResult.freePoint3d(point3d2);
            PickResult.freeVector3d(vector3d);
            PickResult.freePoint3d(point3d3);
            PickResult.freePoint3d(point3d4);
            PickResult.freeVector3d(vector3d2);
            return true;
        }
        PickResult.freePoint3d(point3d);
        PickResult.freePoint3d(point3d2);
        PickResult.freeVector3d(vector3d);
        PickResult.freePoint3d(point3d3);
        PickResult.freePoint3d(point3d4);
        PickResult.freeVector3d(vector3d2);
        return false;
    }

    static boolean intersectCone(Point3d[] point3dArray, PickCone pickCone, PickIntersection pickIntersection) {
        Point3d point3d = PickResult.getPoint3d();
        Point3d point3d2 = PickResult.getPoint3d();
        Vector3d vector3d = PickResult.getVector3d();
        Vector3d vector3d2 = PickResult.getVector3d();
        Point3d point3d3 = PickResult.getPoint3d();
        Point3d point3d4 = PickResult.getPoint3d();
        Vector3d vector3d3 = PickResult.getVector3d();
        pickCone.getOrigin(point3d);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d2);
        }
        if (point3dArray.length > 2) {
            if (pickCone instanceof PickConeRay) {
                if (PickResult.intersectRay(point3dArray, new PickRay(point3d, vector3d), pickIntersection)) {
                    PickResult.freePoint3d(point3d);
                    PickResult.freePoint3d(point3d2);
                    PickResult.freePoint3d(point3d3);
                    PickResult.freePoint3d(point3d4);
                    PickResult.freeVector3d(vector3d);
                    PickResult.freeVector3d(vector3d2);
                    PickResult.freeVector3d(vector3d3);
                    return true;
                }
            } else if (PickResult.intersectSegment(point3dArray, new PickSegment(point3d, point3d2), pickIntersection)) {
                PickResult.freePoint3d(point3d);
                PickResult.freePoint3d(point3d2);
                PickResult.freePoint3d(point3d3);
                PickResult.freePoint3d(point3d4);
                PickResult.freeVector3d(vector3d);
                PickResult.freeVector3d(vector3d2);
                PickResult.freeVector3d(vector3d3);
                return true;
            }
        }
        for (int i = 0; i < point3dArray.length - 1; ++i) {
            double d = pickCone instanceof PickConeSegment ? Distance.segmentToSegment(point3d, point3d2, point3dArray[i], point3dArray[i + 1], point3d3, point3d4, null) : Distance.rayToSegment(point3d, vector3d, point3dArray[i], point3dArray[i + 1], point3d3, point3d4, null);
            vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d);
            double d2 = vector3d2.length();
            double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
            if (!(d <= d3 * d3)) continue;
            pickIntersection.setPointCoordinatesVW(point3d4);
            pickIntersection.setDistance(d2);
            PickResult.freePoint3d(point3d);
            PickResult.freePoint3d(point3d2);
            PickResult.freePoint3d(point3d3);
            PickResult.freePoint3d(point3d4);
            PickResult.freeVector3d(vector3d);
            PickResult.freeVector3d(vector3d2);
            PickResult.freeVector3d(vector3d3);
            return true;
        }
        PickResult.freePoint3d(point3d);
        PickResult.freePoint3d(point3d2);
        PickResult.freePoint3d(point3d3);
        PickResult.freePoint3d(point3d4);
        PickResult.freeVector3d(vector3d);
        PickResult.freeVector3d(vector3d2);
        PickResult.freeVector3d(vector3d3);
        return false;
    }

    static boolean intersectCylinder(Point3d point3d, PickCylinder pickCylinder, PickIntersection pickIntersection) {
        double d;
        Point3d point3d2 = PickResult.getPoint3d();
        Point3d point3d3 = PickResult.getPoint3d();
        Vector3d vector3d = PickResult.getVector3d();
        Point3d point3d4 = PickResult.getPoint3d();
        Vector3d vector3d2 = PickResult.getVector3d();
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d2 = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
            d = Distance.pointToSegment(point3d, point3d2, point3d3, point3d4, null);
        } else {
            d = Distance.pointToRay(point3d, point3d2, vector3d, point3d4, null);
        }
        if (d <= d2 * d2) {
            pickIntersection.setPointCoordinatesVW(point3d);
            vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
            pickIntersection.setDistance(vector3d2.length());
            PickResult.freePoint3d(point3d2);
            PickResult.freePoint3d(point3d3);
            PickResult.freeVector3d(vector3d);
            PickResult.freePoint3d(point3d4);
            PickResult.freeVector3d(vector3d2);
            return true;
        }
        PickResult.freePoint3d(point3d2);
        PickResult.freePoint3d(point3d3);
        PickResult.freeVector3d(vector3d);
        PickResult.freePoint3d(point3d4);
        PickResult.freeVector3d(vector3d2);
        return false;
    }

    static boolean intersectCone(Point3d point3d, PickCone pickCone, PickIntersection pickIntersection) {
        double d;
        Point3d point3d2 = PickResult.getPoint3d();
        Point3d point3d3 = PickResult.getPoint3d();
        Vector3d vector3d = PickResult.getVector3d();
        Point3d point3d4 = PickResult.getPoint3d();
        Vector3d vector3d2 = PickResult.getVector3d();
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
            d = Distance.pointToSegment(point3d, point3d2, point3d3, point3d4, null);
        } else {
            d = Distance.pointToRay(point3d, point3d2, vector3d, point3d4, null);
        }
        vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
        double d2 = vector3d2.length();
        double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
        if (d <= d3 * d3) {
            pickIntersection.setPointCoordinatesVW(point3d);
            pickIntersection.setDistance(d2);
            PickResult.freePoint3d(point3d2);
            PickResult.freePoint3d(point3d3);
            PickResult.freeVector3d(vector3d);
            PickResult.freePoint3d(point3d4);
            PickResult.freeVector3d(vector3d2);
            return true;
        }
        PickResult.freePoint3d(point3d2);
        PickResult.freePoint3d(point3d3);
        PickResult.freeVector3d(vector3d);
        PickResult.freePoint3d(point3d4);
        PickResult.freeVector3d(vector3d2);
        return false;
    }

    static Vector3d getVector3d() {
        return new Vector3d();
    }

    static void freeVector3d(Vector3d vector3d) {
    }

    static Point3d getPoint3d() {
        return new Point3d();
    }

    static void freePoint3d(Point3d point3d) {
    }
}

