/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSceneGraphException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.VirtualUniverse;

class AlternateAppearanceRetained
extends LeafRetained {
    static final int APPEARANCE_CHANGED = 1;
    static final int SCOPE_CHANGED = 2;
    static final int BOUNDS_CHANGED = 4;
    static final int BOUNDINGLEAF_CHANGED = 8;
    static final int INIT_MIRROR = 16;
    static final int CLEAR_MIRROR = 32;
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Vector scopes = new Vector();
    boolean inImmCtx = false;
    static final int targetThreads = 4224;
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    Bounds region = null;
    AlternateAppearanceRetained mirrorAltApp = null;
    AppearanceRetained appearance;
    AlternateAppearanceRetained sgAltApp = null;
    boolean isViewScoped = false;

    AlternateAppearanceRetained() {
        this.nodeType = 27;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void initAppearance(Appearance appearance) {
        this.appearance = appearance != null ? (AppearanceRetained)appearance.retained : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppearance(Appearance appearance) {
        Object object;
        if (this.appearance != null) {
            object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.clearLive(this.refCount);
            }
        }
        this.initAppearance(appearance);
        if (this.appearance != null) {
            object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.sendMessage(1, this.appearance != null ? this.appearance.mirror : null);
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    void initInfluencingBounds(Bounds bounds) {
        this.regionOfInfluence = bounds != null ? (Bounds)bounds.clone() : null;
    }

    void setInfluencingBounds(Bounds bounds) {
        this.initInfluencingBounds(bounds);
        this.sendMessage(4, bounds != null ? bounds.clone() : null);
    }

    Bounds getInfluencingBounds() {
        return this.regionOfInfluence != null ? (Bounds)this.regionOfInfluence.clone() : null;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorAltApp);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorAltApp);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(8, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null);
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void initScope(Group group, int n) {
        this.scopes.setElementAt((GroupRetained)group.retained, n);
    }

    void setScope(Group group, int n) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object[] objectArray = new Object[3];
        GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
        this.tempKey.reset();
        groupRetained.removeAllNodesForScopedAltApp(this.mirrorAltApp, arrayList, this.tempKey);
        groupRetained = (GroupRetained)group.retained;
        this.initScope(group, n);
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedAltApp(this.mirrorAltApp, arrayList2, this.tempKey);
        objectArray[0] = arrayList2;
        objectArray[1] = arrayList;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    Group getScope(int n) {
        return (Group)((GroupRetained)this.scopes.elementAt((int)n)).source;
    }

    void initInsertScope(Node node, int n) {
        GroupRetained groupRetained = (GroupRetained)node.retained;
        this.scopes.insertElementAt((GroupRetained)node.retained, n);
        groupRetained.setAltAppScope();
    }

    void insertScope(Node node, int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)node.retained;
        this.initInsertScope(node, n);
        groupRetained = (GroupRetained)node.retained;
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedAltApp(this.mirrorAltApp, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void initRemoveScope(int n) {
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n);
        this.scopes.removeElementAt(n);
        groupRetained.removeAltAppScope();
    }

    void removeScope(int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n);
        this.tempKey.reset();
        groupRetained.removeAllNodesForScopedAltApp(this.mirrorAltApp, arrayList, this.tempKey);
        this.initRemoveScope(n);
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void removeScope(Group group) {
        int n = this.indexOfScope(group);
        if (n >= 0) {
            this.removeScope(n);
        }
    }

    void initRemoveScope(Group group) {
        int n = this.indexOfScope(group);
        if (n >= 0) {
            this.initRemoveScope(n);
        }
    }

    void removeAllScopes() {
        ArrayList arrayList = new ArrayList();
        int n = this.scopes.size();
        for (int i = n - 1; i >= 0; --i) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(i);
            this.tempKey.reset();
            groupRetained.removeAllNodesForScopedAltApp(this.mirrorAltApp, arrayList, this.tempKey);
            this.initRemoveScope(i);
        }
        Object[] objectArray = new Object[]{null, arrayList, Boolean.FALSE};
        this.sendMessage(2, objectArray);
    }

    void initRemoveAllScopes() {
        int n = this.scopes.size();
        for (int i = n - 1; i >= 0; --i) {
            this.initRemoveScope(i);
        }
    }

    Enumeration getAllScopes() {
        Enumeration enumeration = this.scopes.elements();
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.scopes.size());
        while (enumeration.hasMoreElements()) {
            vector.add(((GroupRetained)enumeration.nextElement()).source);
        }
        return vector.elements();
    }

    int indexOfScope(Group group) {
        if (group != null) {
            return this.scopes.indexOf((GroupRetained)group.retained);
        }
        return this.scopes.indexOf(null);
    }

    void initAddScope(Group group) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.addElement((GroupRetained)group.retained);
        groupRetained.setAltAppScope();
    }

    void addScope(Group group) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.initAddScope(group);
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedAltApp(this.mirrorAltApp, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    int numScopes() {
        return this.scopes.size();
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    boolean isScoped() {
        return this.scopes != null;
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 1) != 0) {
            this.mirrorAltApp.appearance = (AppearanceRetained)objectArray[2];
        }
        if ((n & 4) != 0) {
            this.mirrorAltApp.regionOfInfluence = (Bounds)objectArray[2];
            if (this.mirrorAltApp.boundingLeaf == null) {
                if (objectArray[2] != null) {
                    this.mirrorAltApp.region = this.mirrorAltApp.regionOfInfluence.copy(this.mirrorAltApp.region);
                    this.mirrorAltApp.region.transform(this.mirrorAltApp.regionOfInfluence, this.getCurrentLocalToVworld());
                } else {
                    this.mirrorAltApp.region = null;
                }
            }
        } else if ((n & 8) != 0) {
            this.mirrorAltApp.boundingLeaf = (BoundingLeafRetained)objectArray[2];
            if (objectArray[2] != null) {
                this.mirrorAltApp.region = this.mirrorAltApp.boundingLeaf.transformedRegion;
            } else if (this.mirrorAltApp.regionOfInfluence != null) {
                this.mirrorAltApp.region = this.mirrorAltApp.regionOfInfluence.copy(this.mirrorAltApp.region);
                this.mirrorAltApp.region.transform(this.mirrorAltApp.regionOfInfluence, this.getCurrentLocalToVworld());
            } else {
                this.mirrorAltApp.region = null;
            }
        } else if ((n & 2) != 0) {
            Shape3DRetained shape3DRetained;
            int n2;
            Object[] objectArray2 = (Object[])objectArray[2];
            ArrayList arrayList = (ArrayList)objectArray2[0];
            ArrayList arrayList2 = (ArrayList)objectArray2[1];
            boolean bl = (Boolean)objectArray2[2];
            if (arrayList != null) {
                this.mirrorAltApp.isScoped = bl;
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    shape3DRetained = ((GeometryAtom)arrayList.get((int)n2)).source;
                    shape3DRetained.addAltApp(this.mirrorAltApp);
                }
            }
            if (arrayList2 != null) {
                this.mirrorAltApp.isScoped = bl;
                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                    shape3DRetained = ((GeometryAtom)arrayList2.get((int)n2)).source;
                    shape3DRetained.removeAltApp(this.mirrorAltApp);
                }
            }
        }
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        } else {
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLive(SetLiveState setLiveState) {
        Object object;
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("AlternateAppearanceRetained13"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("AlternateAppearanceRetained15"));
        }
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("AlternateAppearanceRetained16"));
        }
        super.doSetLive(setLiveState);
        if (this.appearance != null) {
            if (this.appearance.getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("AlternateAppearanceRetained14"));
            }
            object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.setLive(this.inBackgroundGroup, setLiveState.refCount);
            }
        }
        if (this.mirrorAltApp == null) {
            this.mirrorAltApp = (AlternateAppearanceRetained)this.clone();
            this.mirrorAltApp.boundingLeaf = null;
            this.mirrorAltApp.sgAltApp = this;
        }
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorAltApp);
        }
        if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
            setLiveState.viewScopedNodeList.add(this.mirrorAltApp);
            setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
        } else {
            setLiveState.nodeList.add(this.mirrorAltApp);
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this.mirrorAltApp, 1);
            setLiveState.notifyThreads |= 0x2000;
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this.mirrorAltApp, 1);
        }
        this.mirrorAltApp.switchState = (SwitchState)setLiveState.switchStates.get(0);
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
        object = VirtualUniverse.mc.getMessage();
        ((J3dMessage)object).threads = 4096;
        ((J3dMessage)object).universe = this.universe;
        ((J3dMessage)object).type = 41;
        ((J3dMessage)object).args[0] = this;
        ((J3dMessage)object).args[1] = new Integer(16);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.scopes.size(); ++i) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.get(i);
            this.tempKey.reset();
            groupRetained.addAllNodesForScopedAltApp(this.mirrorAltApp, arrayList, this.tempKey);
        }
        Object[] objectArray = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, arrayList};
        ((J3dMessage)object).args[2] = objectArray;
        ((J3dMessage)object).args[3] = this.appearance != null ? this.appearance.mirror : null;
        Object[] objectArray2 = new Object[]{this.boundingLeaf, this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null};
        ((J3dMessage)object).args[4] = objectArray2;
        VirtualUniverse.mc.processMessage((J3dMessage)object);
    }

    void initMirrorObject(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray[2];
        Boolean bl = (Boolean)objectArray2[0];
        ArrayList arrayList = (ArrayList)objectArray2[1];
        AppearanceRetained appearanceRetained = (AppearanceRetained)objectArray[3];
        BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)((Object[])objectArray[4])[0];
        Bounds bounds = (Bounds)((Object[])objectArray[4])[1];
        for (int i = 0; i < arrayList.size(); ++i) {
            Shape3DRetained shape3DRetained = ((GeometryAtom)arrayList.get((int)i)).source;
            shape3DRetained.addAltApp(this.mirrorAltApp);
        }
        this.mirrorAltApp.isScoped = bl;
        if (appearanceRetained != null) {
            this.mirrorAltApp.appearance = appearanceRetained;
        }
        if (boundingLeafRetained != null) {
            this.mirrorAltApp.boundingLeaf = boundingLeafRetained.mirrorBoundingLeaf;
            this.mirrorAltApp.region = this.boundingLeaf.transformedRegion;
        } else {
            this.mirrorAltApp.boundingLeaf = null;
            this.mirrorAltApp.region = null;
        }
        if (bounds != null) {
            this.mirrorAltApp.regionOfInfluence = bounds;
            if (this.mirrorAltApp.region == null) {
                this.mirrorAltApp.region = (Bounds)this.regionOfInfluence.clone();
                this.mirrorAltApp.region.transform(this.regionOfInfluence, this.getLastLocalToVworld());
            }
        } else {
            this.mirrorAltApp.regionOfInfluence = null;
        }
    }

    void clearMirrorObject(Object[] objectArray) {
        ArrayList arrayList = (ArrayList)objectArray[2];
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Shape3DRetained shape3DRetained = ((GeometryAtom)arrayList.get((int)i)).source;
            shape3DRetained.removeAltApp(this.mirrorAltApp);
        }
        this.mirrorAltApp.isScoped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearLive(SetLiveState setLiveState) {
        Object object;
        if (this.appearance != null) {
            object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.clearLive(setLiveState.refCount);
            }
        }
        super.clearLive(setLiveState);
        setLiveState.notifyThreads |= 0x1080;
        if (this.mirrorAltApp.boundingLeaf != null) {
            this.mirrorAltApp.boundingLeaf.removeUser(this.mirrorAltApp);
        }
        if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
            setLiveState.viewScopedNodeList.add(this.mirrorAltApp);
            setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
        } else {
            setLiveState.nodeList.add(this.mirrorAltApp);
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this.mirrorAltApp, 1);
            setLiveState.notifyThreads |= 0x2000;
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this.mirrorAltApp, 1);
        }
        if (this.scopes.size() > 0) {
            object = VirtualUniverse.mc.getMessage();
            ((J3dMessage)object).threads = 4096;
            ((J3dMessage)object).universe = this.universe;
            ((J3dMessage)object).type = 41;
            ((J3dMessage)object).args[0] = this;
            ((J3dMessage)object).args[1] = new Integer(32);
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.scopes.size(); ++i) {
                GroupRetained groupRetained = (GroupRetained)this.scopes.get(i);
                this.tempKey.reset();
                groupRetained.removeAllNodesForScopedAltApp(this.mirrorAltApp, arrayList, this.tempKey);
            }
            ((J3dMessage)object).args[2] = arrayList;
            VirtualUniverse.mc.processMessage((J3dMessage)object);
        }
    }

    void updateTransformChange() {
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.sgAltApp.getCurrentLocalToVworld());
        }
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 41;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void getMirrorObjects(ArrayList arrayList, HashKey hashKey) {
        arrayList.add(this.mirrorAltApp);
    }

    void duplicateAttributes(Node node, boolean bl) {
        throw new RuntimeException("method not implemented");
    }
}

