/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupData;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.VirtualUniverse;

class TransformStructure
extends J3dStructure
implements ObjectUpdate {
    UnorderList traverseList = new UnorderList(TransformGroupRetained.class);
    UnorderList transformList = new UnorderList(Transform3D.class);
    ArrayList objectList = new ArrayList();
    ArrayList blUsers = new ArrayList();
    UpdateTargets targets = new UpdateTargets();
    ArrayList collisionObjectList = new ArrayList();
    HashKey key = new HashKey(250);
    ArrayList dirtyTransformGroups = new ArrayList();
    ArrayList keySet = new ArrayList();
    Locale locale = null;
    Transform3D currentTrans = new Transform3D();
    TransformGroupRetained[] tgs;
    Transform3D[] t3ds;
    UnorderList activeTraverseList = new UnorderList(TransformGroupRetained.class);
    ArrayList switchDirtyTgList = new ArrayList(1);
    boolean lazyUpdate = false;
    ArrayList switchChangedList = new ArrayList();
    boolean inUpdateObjectList = false;

    TransformStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n <= 0) {
            return;
        }
        this.targets.clearNodes();
        this.objectList.clear();
        this.blUsers.clear();
        this.inUpdateObjectList = false;
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            J3dMessage j3dMessage;
            int n2;
            for (n2 = n - 1; n2 >= 0; --n2) {
                int n3;
                j3dMessage = objectArray[n2];
                if (j3dMessage.type != 3 || (n3 = this.traverseList.indexOf(j3dMessage.args[1])) != -1) continue;
                this.traverseList.add(j3dMessage.args[1]);
                this.transformList.add(j3dMessage.args[2]);
            }
            for (n2 = 0; n2 < n; ++n2) {
                j3dMessage = objectArray[n2];
                switch (j3dMessage.type) {
                    case 0: {
                        this.objectList.add(j3dMessage.args[0]);
                        if (j3dMessage.args[1] == null) break;
                        Object object2 = (TargetsInterface)j3dMessage.args[1];
                        object2.updateCachedTargets(0, (CachedTargets[])j3dMessage.args[2]);
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessage);
                        break;
                    }
                    case 24: {
                        this.objectList.add(j3dMessage.args[3]);
                        if (j3dMessage.args[4] == null) break;
                        Object object2 = (TargetsInterface)j3dMessage.args[4];
                        object2.updateCachedTargets(0, (CachedTargets[])j3dMessage.args[5]);
                        break;
                    }
                    case 17: {
                        this.objectList.add(j3dMessage.args[0]);
                        break;
                    }
                    case 16: {
                        this.objectList.add(j3dMessage.args[3]);
                        break;
                    }
                    case 26: {
                        this.objectList.add(j3dMessage.args[1]);
                        Object object2 = (Object[])j3dMessage.args[2];
                        if (object2 == null) break;
                        Object[] objectArray2 = (Object[])j3dMessage.args[3];
                        for (int i = 0; i < ((Object)object2).length; ++i) {
                            TargetsInterface targetsInterface = (TargetsInterface)object2[i];
                            targetsInterface.updateCachedTargets(0, (CachedTargets[])objectArray2[i]);
                        }
                        break;
                    }
                    case 25: {
                        this.objectList.add(j3dMessage.args[0]);
                        break;
                    }
                    case 37: {
                        this.processBoundsAutoComputeChanged(j3dMessage);
                        break;
                    }
                    case 35: {
                        this.processRegionBoundChanged(j3dMessage);
                        break;
                    }
                    case 34: {
                        this.processCollisionBoundChanged(j3dMessage);
                    }
                }
                j3dMessage.decRefcount();
            }
            this.processCurrentLocalToVworld();
            if (this.objectList.size() > 0) {
                this.processGeometryAtomVwcBounds();
            }
            this.processVwcBounds();
        }
        Arrays.fill(objectArray, 0, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCurrentLocalToVworld() {
        int n;
        this.lazyUpdate = false;
        int n2 = this.transformList.size();
        int n3 = this.switchDirtyTgList.size();
        if (n2 <= 0 && n3 <= 0) {
            return;
        }
        if (n2 > 0) {
            this.tgs = (TransformGroupRetained[])this.traverseList.toArray(false);
            this.t3ds = (Transform3D[])this.transformList.toArray(false);
            for (n = 0; n < n2; ++n) {
                TransformGroupRetained transformGroupRetained = this.tgs[n];
                transformGroupRetained.currentTransform.set(this.t3ds[n]);
                FreeListManager.freeObject(2, this.t3ds[n]);
                TransformGroupRetained transformGroupRetained2 = transformGroupRetained;
                synchronized (transformGroupRetained2) {
                    if (transformGroupRetained.perPathData != null) {
                        TransformGroupData transformGroupData;
                        if (!transformGroupRetained.inSharedGroup) {
                            transformGroupData = transformGroupRetained.perPathData[0];
                            if (!transformGroupData.switchState.inSwitch) {
                                this.activeTraverseList.add(transformGroupRetained);
                                transformGroupData.markedDirty = true;
                                transformGroupData.switchDirty = false;
                            } else if (transformGroupData.switchState.currentSwitchOn) {
                                this.activeTraverseList.add(transformGroupRetained);
                                transformGroupData.switchDirty = false;
                                transformGroupData.markedDirty = true;
                            } else {
                                transformGroupData.switchDirty = true;
                                transformGroupData.markedDirty = false;
                            }
                        } else {
                            int n4 = transformGroupRetained.perPathData.length;
                            boolean bl = false;
                            for (int i = 0; i < n4; ++i) {
                                transformGroupData = transformGroupRetained.perPathData[i];
                                if (!transformGroupData.switchState.inSwitch) {
                                    if (!bl) {
                                        bl = true;
                                        this.activeTraverseList.add(transformGroupRetained);
                                    }
                                    transformGroupData.markedDirty = true;
                                    transformGroupData.switchDirty = false;
                                    continue;
                                }
                                if (transformGroupData.switchState.currentSwitchOn) {
                                    if (!bl) {
                                        bl = true;
                                        this.activeTraverseList.add(transformGroupRetained);
                                    }
                                    transformGroupData.switchDirty = false;
                                    transformGroupData.markedDirty = true;
                                    continue;
                                }
                                transformGroupData.switchDirty = true;
                                transformGroupData.markedDirty = false;
                            }
                        }
                    }
                    continue;
                }
            }
        }
        if (n3 > 0) {
            int n5 = this.switchDirtyTgList.size();
            for (n = 0; n < n5; ++n) {
                this.activeTraverseList.add(this.switchDirtyTgList.get(n));
            }
            this.switchDirtyTgList.clear();
            this.lazyUpdate = true;
        }
        this.tgs = (TransformGroupRetained[])this.activeTraverseList.toArray(false);
        n2 = this.activeTraverseList.size();
        if (n2 > 0) {
            this.sortTransformGroups(n2);
            for (n = 0; n < n2; ++n) {
                this.tgs[n].processChildLocalToVworld(this.dirtyTransformGroups, this.keySet, this.targets, this.blUsers);
            }
            if (!this.inUpdateObjectList) {
                VirtualUniverse.mc.addMirrorObject(this);
                this.inUpdateObjectList = true;
            }
        }
        this.transformList.clear();
        this.traverseList.clear();
        this.activeTraverseList.clear();
    }

    private void sortTransformGroups(int n) {
        if (n < 7) {
            this.insertSort(n);
        } else {
            this.quicksort(0, n - 1);
        }
    }

    private void insertSort(int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0 && this.tgs[j - 1].maxTransformLevel > this.tgs[j].maxTransformLevel; --j) {
                TransformGroupRetained transformGroupRetained = this.tgs[j];
                this.tgs[j] = this.tgs[j - 1];
                this.tgs[j - 1] = transformGroupRetained;
            }
        }
    }

    private void quicksort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        double d = this.tgs[(n + n2) / 2].maxTransformLevel;
        while (true) {
            if ((double)this.tgs[n3].maxTransformLevel < d) {
                ++n3;
                continue;
            }
            while (d < (double)this.tgs[n4].maxTransformLevel) {
                --n4;
            }
            if (n3 <= n4) {
                TransformGroupRetained transformGroupRetained = this.tgs[n3];
                this.tgs[n3] = this.tgs[n4];
                this.tgs[n4] = transformGroupRetained;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quicksort(n, n4);
        }
        if (n < n2) {
            this.quicksort(n3, n2);
        }
    }

    public void updateObject() {
        this.processLastLocalToVworld();
        this.processLastSwitchOn();
    }

    void processLastSwitchOn() {
        int n = this.switchChangedList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                SwitchState switchState = (SwitchState)this.switchChangedList.get(i);
                switchState.updateLastSwitchOn();
            }
            this.switchChangedList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processLastLocalToVworld() {
        int n = this.dirtyTransformGroups.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TransformGroupRetained transformGroupRetained;
            TransformGroupRetained transformGroupRetained2 = transformGroupRetained = (TransformGroupRetained)this.dirtyTransformGroups.get(i);
            synchronized (transformGroupRetained2) {
                if (transformGroupRetained.childLocalToVworld != null) {
                    if (transformGroupRetained.inSharedGroup) {
                        int n3;
                        HashKey hashKey = (HashKey)this.keySet.get(n2++);
                        for (n3 = 0; n3 < transformGroupRetained.localToVworldKeys.length && !transformGroupRetained.localToVworldKeys[n3].equals((Object)hashKey); ++n3) {
                        }
                        if (n3 < transformGroupRetained.localToVworldKeys.length) {
                            transformGroupRetained.childLocalToVworldIndex[n3][0] = transformGroupRetained.childLocalToVworldIndex[n3][1];
                        }
                    } else {
                        transformGroupRetained.childLocalToVworldIndex[0][0] = transformGroupRetained.childLocalToVworldIndex[0][1];
                    }
                }
                continue;
            }
        }
        this.dirtyTransformGroups.clear();
        this.keySet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGeometryAtomVwcBounds() {
        Shape3DRetained shape3DRetained;
        GeometryAtom geometryAtom;
        Object object;
        int n;
        Object[] objectArray;
        int n2;
        int n3 = this.objectList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray = (Object[])this.objectList.get(n2);
            for (n = 0; n < objectArray.length; ++n) {
                object = objectArray[n];
                synchronized (object) {
                    Cloneable cloneable;
                    if (objectArray[n] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n];
                        shape3DRetained = geometryAtom.source;
                        cloneable = shape3DRetained.bounds;
                        synchronized (cloneable) {
                            shape3DRetained.vwcBounds.transform(shape3DRetained.bounds, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                        if (shape3DRetained.collisionBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                        geometryAtom.centroidIsDirty = true;
                    } else if (objectArray[n] instanceof GroupRetained) {
                        cloneable = (GroupRetained)objectArray[n];
                        Bounds bounds = ((GroupRetained)cloneable).sourceNode.collisionBound != null ? ((GroupRetained)cloneable).sourceNode.collisionBound : ((GroupRetained)cloneable).sourceNode.getEffectiveBounds();
                        ((GroupRetained)cloneable).collisionVwcBounds.transform(bounds, ((NodeRetained)cloneable).getCurrentLocalToVworld());
                    }
                    continue;
                }
            }
        }
        for (n2 = 0; n2 < this.collisionObjectList.size(); ++n2) {
            objectArray = (Object[])this.collisionObjectList.get(n2);
            for (n = 0; n < objectArray.length; ++n) {
                object = objectArray[n];
                synchronized (object) {
                    if (objectArray[n] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n];
                        shape3DRetained = geometryAtom.source;
                        if (shape3DRetained.collisionVwcBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                    }
                    continue;
                }
            }
        }
        this.collisionObjectList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processVwcBounds() {
        Bounds bounds;
        Shape3DRetained shape3DRetained;
        GeometryAtom geometryAtom;
        Object object;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3;
        UnorderList unorderList = this.targets.targetList[0];
        if (unorderList != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray = (Object[])objectArray2[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    object = objectArray[n];
                    synchronized (object) {
                        geometryAtom = (GeometryAtom)objectArray[n];
                        shape3DRetained = geometryAtom.source;
                        bounds = shape3DRetained.bounds;
                        synchronized (bounds) {
                            shape3DRetained.vwcBounds.transform(shape3DRetained.bounds, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                        if (shape3DRetained.collisionBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                        geometryAtom.centroidIsDirty = true;
                        continue;
                    }
                }
            }
        }
        if ((unorderList = this.targets.targetList[6]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray = (Object[])objectArray2[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    object = (GroupRetained)objectArray[n];
                    bounds = ((GroupRetained)object).sourceNode.collisionBound != null ? ((GroupRetained)object).sourceNode.collisionBound : ((GroupRetained)object).sourceNode.getEffectiveBounds();
                    ((GroupRetained)object).collisionVwcBounds.transform(bounds, ((NodeRetained)object).getCurrentLocalToVworld());
                }
            }
        }
        for (n2 = 0; n2 < this.collisionObjectList.size(); ++n2) {
            objectArray = (Object[])this.collisionObjectList.get(n2);
            for (n = 0; n < objectArray.length; ++n) {
                object = objectArray[n];
                synchronized (object) {
                    if (objectArray[n] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n];
                        shape3DRetained = geometryAtom.source;
                        if (shape3DRetained.collisionVwcBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                    }
                    continue;
                }
            }
        }
        this.collisionObjectList.clear();
    }

    void processRegionBoundChanged(J3dMessage j3dMessage) {
        this.processBoundsChanged((Object[])j3dMessage.args[0], (Bounds)j3dMessage.args[1]);
    }

    void processBoundsChanged(Object[] objectArray, Bounds bounds) {
        for (int i = 0; i < objectArray.length; ++i) {
            GeometryAtom geometryAtom = (GeometryAtom)objectArray[i];
            Shape3DRetained shape3DRetained = geometryAtom.source;
            shape3DRetained.bounds = bounds;
            if (shape3DRetained.collisionBound != null) continue;
            shape3DRetained.collisionVwcBound = shape3DRetained.vwcBounds;
        }
        this.objectList.add(objectArray);
    }

    void processCollisionBoundChanged(J3dMessage j3dMessage) {
        Bounds bounds = (Bounds)j3dMessage.args[1];
        if (j3dMessage.args[0] instanceof GroupRetained) {
            GroupRetained groupRetained = (GroupRetained)j3dMessage.args[0];
            if (groupRetained.mirrorGroup != null) {
                this.objectList.add(groupRetained.mirrorGroup);
            }
        } else {
            Object[] objectArray = (Object[])j3dMessage.args[0];
            for (int i = 0; i < objectArray.length; ++i) {
                GeometryAtom geometryAtom = (GeometryAtom)objectArray[i];
                Shape3DRetained shape3DRetained = geometryAtom.source;
                shape3DRetained.collisionBound = bounds;
                shape3DRetained.collisionVwcBound = shape3DRetained.collisionBound != null ? (Bounds)shape3DRetained.collisionBound.clone() : shape3DRetained.vwcBounds;
            }
            this.collisionObjectList.add(objectArray);
        }
    }

    void processBoundsAutoComputeChanged(J3dMessage j3dMessage) {
        this.processBoundsChanged((Object[])j3dMessage.args[0], (Bounds)j3dMessage.args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSwitchChanged(J3dMessage j3dMessage) {
        ArrayList arrayList = (ArrayList)j3dMessage.args[2];
        int n = arrayList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                SwitchState switchState = (SwitchState)arrayList.get(i);
                switchState.updateCurrentSwitchOn();
            }
            UpdateTargets updateTargets = (UpdateTargets)j3dMessage.args[0];
            UnorderList unorderList = updateTargets.targetList[6];
            if (unorderList != null) {
                Object[] objectArray = unorderList.toArray(false);
                int n2 = unorderList.size();
                for (int i = 0; i < n2; ++i) {
                    Object[] objectArray2 = (Object[])objectArray[i];
                    for (int j = 0; j < objectArray2.length; ++j) {
                        TransformGroupRetained transformGroupRetained;
                        boolean bl = false;
                        TransformGroupRetained transformGroupRetained2 = transformGroupRetained = (TransformGroupRetained)objectArray2[j];
                        synchronized (transformGroupRetained2) {
                            if (transformGroupRetained.perPathData != null) {
                                int n3 = transformGroupRetained.perPathData.length;
                                for (int k = 0; k < n3; ++k) {
                                    TransformGroupData transformGroupData = transformGroupRetained.perPathData[k];
                                    if (!transformGroupData.switchState.currentSwitchOn || !transformGroupData.switchDirty) continue;
                                    if (!bl) {
                                        this.switchDirtyTgList.add(transformGroupRetained);
                                        bl = true;
                                    }
                                    transformGroupData.switchDirty = false;
                                    transformGroupData.markedDirty = true;
                                }
                            }
                            continue;
                        }
                    }
                }
            }
            this.switchChangedList.addAll(arrayList);
            if (!this.inUpdateObjectList) {
                VirtualUniverse.mc.addMirrorObject(this);
                this.inUpdateObjectList = true;
            }
        }
    }

    UpdateTargets getTargetList() {
        return this.targets;
    }

    ArrayList getBlUsers() {
        return this.blUsers;
    }

    boolean getLazyUpdate() {
        return this.lazyUpdate;
    }

    void removeNodes(J3dMessage j3dMessage) {
        if (j3dMessage.args[1] != null) {
            TargetsInterface targetsInterface = (TargetsInterface)j3dMessage.args[1];
            targetsInterface.updateCachedTargets(0, (CachedTargets[])j3dMessage.args[2]);
        }
    }

    void cleanup() {
    }
}

