/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;

class LinearFogRetained
extends FogRetained {
    private double frontDistance = 0.1;
    private double backDistance = 1.0;
    private double frontDistanceInEc;
    private double backDistanceInEc;
    static final int FRONT_DISTANCE_CHANGED = 64;
    static final int BACK_DISTANCE_CHANGED = 128;

    LinearFogRetained() {
        this.nodeType = 3;
    }

    void initFrontDistance(double d) {
        this.frontDistance = d;
    }

    void setFrontDistance(double d) {
        this.frontDistance = d;
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 22;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(64);
        j3dMessage.args[2] = new Double(d);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    double getFrontDistance() {
        return this.frontDistance;
    }

    void initBackDistance(double d) {
        this.backDistance = d;
    }

    void setBackDistance(double d) {
        this.backDistance = d;
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 22;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(128);
        j3dMessage.args[2] = new Double(d);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    double getBackDistance() {
        return this.backDistance;
    }

    native void update(long var1, float var3, float var4, float var5, double var6, double var8);

    void update(long l, double d) {
        this.validateDistancesInEc(d);
        this.update(l, this.color.x, this.color.y, this.color.z, this.frontDistanceInEc, this.backDistanceInEc);
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4096;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 22;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.scopes.size(); ++i) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.get(i);
            this.tempKey.reset();
            groupRetained.addAllNodesForScopedFog(this.mirrorFog, arrayList, this.tempKey);
        }
        Object[] objectArray = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, arrayList};
        j3dMessage.args[2] = objectArray;
        Color3f color3f = new Color3f(this.color);
        j3dMessage.args[3] = color3f;
        Object[] objectArray2 = new Object[]{this.boundingLeaf, this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null, this.inBackgroundGroup ? Boolean.TRUE : Boolean.FALSE, this.geometryBackground, new Double(this.frontDistance), new Double(this.backDistance)};
        j3dMessage.args[4] = objectArray2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    synchronized void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 0x40) != 0) {
            ((LinearFogRetained)this.mirrorFog).frontDistance = (Double)objectArray[2];
        }
        if ((n & 0x80) != 0) {
            ((LinearFogRetained)this.mirrorFog).backDistance = (Double)objectArray[2];
        }
        if ((n & 0x10) != 0) {
            ((LinearFogRetained)this.mirrorFog).frontDistance = (Double)((Object[])objectArray[4])[4];
            ((LinearFogRetained)this.mirrorFog).backDistance = (Double)((Object[])objectArray[4])[5];
        }
        ((LinearFogRetained)this.mirrorFog).setLocalToVworldScale(this.getLastLocalToVworld().getDistanceScale());
        super.updateMirrorObject(objectArray);
    }

    protected void validateDistancesInEc(double d) {
        double d2 = this.getLocalToVworldScale() * d;
        this.frontDistanceInEc = this.frontDistance * d2;
        this.backDistanceInEc = this.backDistance * d2;
    }
}

