
//----- Includes --------------------------------------------------------------

#include <string.h>
#include "TclCommander.h"


//----- Module data -----------------------------------------------------------

const panelH = 25;



//-----------------------------------------------------------------------------
//----- Tcl commands ----------------------------------------------------------
//-----------------------------------------------------------------------------

static int CsGenericCmdProc (ClientData clientData, 
                             Tcl_Interp *interp, 
                             int        argc, 
                             char       *argv[])
{
	if (argc < 2)
	{
		interp->result = "cs generic command requires at least 1 parameter";
		return TCL_ERROR;
	}
	
	// Check for repetition argument used in simple commands:
	signed long repeat = 1;
	if (argc > 2)
	{
		if (argv[2][0] >= '0' && argv[2][0] <= '9')
		{
			repeat = atol (argv[2]);
			if (repeat <= 0)
				repeat = 1; // not generally an error, depends on command
		}
	}
	
	TclCommander *commander = (TclCommander *)clientData;
	
	if (strcasecmp (argv[1], "load") == 0)
	{
		if (argc < 3)
		{
			interp->result = "wrong # args: cs load <grammar-file>";
			return TCL_ERROR;
		}
		commander->Owner()->Again (argv[2]);
	}
	
	else if (strcasecmp (argv[1], "reload") == 0)
	{
		commander->Owner()->Again (NULL);
	}
	
	else if (strcasecmp (argv[1], "firstpage") == 0)
	{
		commander->Owner()->FirstPage ();
	}
	
	else if (strcasecmp (argv[1], "lastpage") == 0)
	{
		commander->Owner()->LastPage ();
	}
	
	else if (strcasecmp (argv[1], "prevpage") == 0)
	{
		for (int i=0; i < repeat; i++)
			commander->Owner()->PrevPage (0, NULL);
	}
	
	else if (strcasecmp (argv[1], "nextpage") == 0)
	{
		for (int i=0; i < repeat; i++)
			commander->Owner()->NextPage (0, NULL);
	}
	
	else if (strcasecmp (argv[1], "scrollleft") == 0)
	{
		for (int i=0; i < repeat; i++)
			commander->Owner()->ScrollLeft ();
	}
	
	else if (strcasecmp (argv[1], "scrollright") == 0)
	{
		for (int i=0; i < repeat; i++)
			commander->Owner()->ScrollRight ();
	}
	
	else if (strcasecmp (argv[1], "scrollup") == 0)
	{
		for (int i=0; i < repeat; i++)
			commander->Owner()->ScrollUp ();
	}
	
	else if (strcasecmp (argv[1], "scrolldown") == 0)
	{
		for (int i=0; i < repeat; i++)
			commander->Owner()->ScrollDown ();
	}
	
	else if (strcasecmp (argv[1], "zoomin") == 0)
	{
		for (int i=0; i < repeat; i++)
			commander->Owner()->ZoomIn ();
	}
	
	else if (strcasecmp (argv[1], "zoomout") == 0)
	{
		for (int i=0; i < repeat; i++)
			commander->Owner()->ZoomOut ();
	}
	
	else if (strcasecmp (argv[1], "reset") == 0)
	{
		commander->Owner()->Reset ();
	}
	
	else if (strcasecmp (argv[1], "zoomrect") == 0)
	{		
		if (argc < 6)
		{
			interp->result = "wrong # args: cs zoomrect <x> <y> <w> <h>";
			return TCL_ERROR;
		}
		
		int x, y, w, h;
		if (Tcl_GetInt (interp, argv[2], &x) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt (interp, argv[3], &y) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt (interp, argv[4], &w) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt (interp, argv[5], &h) != TCL_OK)
			return TCL_ERROR;
		
		commander->Owner()->ZoomRect (x, y, w, h);	
	}
	
	else if (strcasecmp (argv[1], "sleep") == 0)
	{
		sleep (repeat);
	}
	
	else if (strcasecmp (argv[1], "snapshot") == 0)
	{
		char *filename;
		if (argc < 3)
			filename = NULL;
		else
			filename = argv[2];
			
		commander->Owner()->DoSnapshot (filename);
	}
	
	else if (strcasecmp (argv[1], "prepare") == 0)
	{
		if (argc < 3)
		{
			interp->result = "wrong # args: cs prepare <script>";
			return TCL_ERROR;
		}
	
		CollageEnvi *envi = &commander->Owner()->envi;
		if (! envi->interp)
			envi->interp = Tcl_CreateInterp ();
		
		int result = Tcl_Eval (envi->interp, argv[2]);
		if (result != TCL_OK)
		{
			// take the error over to our interpreter:
			interp->result = envi->interp->result;
			return result;
		}	
	}
	
	else
	{
		sprintf (interp->result, "unknown cs subcommand '%s'", argv[1]);
		return TCL_ERROR;
	}	
	return TCL_OK;
}



//-----------------------------------------------------------------------------
//----- TclCommander ----------------------------------------------------------
//-----------------------------------------------------------------------------

// xvcpp.h macro implementations:

MAKE_BUTTON_STUFF (TclCommander)
MAKE_WIN_EVENT_STUFF (TclCommander)

TclCommander::TclCommander (CgiPrivate &owner)
{
	this->owner = &owner;
	scriptPathname[0] = 0;
	
	interp = Tcl_CreateInterp ();
	
	Tcl_CreateCommand (interp, "cs", CsGenericCmdProc, (ClientData)this, NULL);

	CreateEditor ();

}


//----- PanelEditNotify ------------------------------------------------------

static Panel_setting PanelEditNotify (Panel_item item, Event *event)
{
  return PANEL_NONE;
}


//----- EditNotify -----------------------------------------------------------

static int EditNotify (Textedit    *textedit, 
                       Textsw      textsw, 
                       Attr_avlist attributes, 
                       void        *cgiPrivate)
{
  int pass_on = TRUE; // pass the event to the text subwindow's default proc
  Attr_avlist attrs;
 
  for (attrs = attributes; *attrs; attrs = attr_next(attrs))
  {
    switch ((Textsw_action)(*attrs))
    {
      case TEXTSW_ACTION_LOADED_FILE:
        //cout << "Textedit loaded file " << (char *)attrs[1] << "\n";
        pass_on = TRUE;
        break;
      default:
        pass_on = TRUE;
        break;
    }    
  }
  return pass_on;

  return 1;
}


//----- CreateEditor ----------------------------------------------------------

void TclCommander::CreateEditor ()
{
	editFrame = xv_create (owner->GetFrame(), FRAME, 
		XV_X, xv_get (owner->GetFrame(), XV_X)+130,
		XV_Y, xv_get (owner->GetFrame(), XV_Y)+40,
		XV_WIDTH, 750,
		XV_HEIGHT, 300,
		FRAME_LABEL, "Collage-Two Commander",
		SET_WIN_EVENT_PROC (TclCommander, this, EditFrameEvent),
		NULL);

	editPanel = xv_create (editFrame, PANEL,
		XV_X, 0, XV_Y, 0, XV_WIDTH, 750, XV_HEIGHT, panelH,
		NULL);

	(void) xv_create(editPanel, PANEL_BUTTON, 
		PANEL_LABEL_STRING, "Save & run",
		SET_BUTTON_PROC (TclCommander, this, EditRunBut),
		NULL);
		
	(void) xv_create(editPanel, PANEL_BUTTON, 
		PANEL_LABEL_STRING, "Save",
		SET_BUTTON_PROC (TclCommander, this, EditSaveBut),
		NULL);
		
	(void) xv_create(editPanel, PANEL_BUTTON, 
		PANEL_LABEL_STRING, "Save & close",
		SET_BUTTON_PROC (TclCommander, this, EditSaveAndCloseBut),
		NULL);
		
	(void) xv_create(editPanel, PANEL_BUTTON, 
		PANEL_LABEL_STRING, "Abort",
		SET_BUTTON_PROC (TclCommander, this, EditAbortBut),
		NULL);
		
	(void) xv_create(editPanel, PANEL_BUTTON, 
		PANEL_LABEL_STRING, "Help",
		SET_BUTTON_PROC (TclCommander, this, EditHelpBut),
		NULL);
		
	editEdit = xv_create (editPanel, PANEL_TEXT, 
		PANEL_LABEL_STRING, " Name:",
		PANEL_VALUE, scriptPathname,
        	PANEL_NOTIFY_PROC, PanelEditNotify,
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_VALUE_STORED_LENGTH, 250,
		NULL);
		
	(void) xv_create(editPanel, PANEL_BUTTON, 
		PANEL_LABEL_STRING, "Load",
		SET_BUTTON_PROC (TclCommander, this, EditLoadBut),
		NULL);

	textedit = new Textedit (editFrame);
	if (scriptPathname[0])
		textedit->Load (scriptPathname);
	textedit->SetNotifyProc (EditNotify, this);
	
	xv_set (textedit->GetTextsw(),
		XV_X, 0,
		XV_Y, panelH,
		XV_WIDTH, 550,
		XV_HEIGHT, 300,
		TEXTSW_AUTO_INDENT, TRUE,
		TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
		NULL);

	xv_set (editFrame, XV_SHOW, TRUE, NULL);
}


//----- EditFrameEvent --------------------------------------------------------

void TclCommander::EditFrameEvent (Xv_Window  window, 
                                   Event      *event, 
                                   Notify_arg arg)
{
  switch(event_action(event))
  {
    case WIN_RESIZE: 
      xv_set (textedit->GetTextsw(), 
              XV_WIDTH, xv_get(editFrame, XV_WIDTH),
              XV_HEIGHT, xv_get(editFrame, XV_HEIGHT)-panelH,
              NULL); 
     xv_set (editPanel, XV_WIDTH, xv_get(editFrame, XV_WIDTH), NULL);
     break;
  }
}


//----- EditDoSave ------------------------------------------------------------

void TclCommander::EditDoSave ()
{
	strcpy (scriptPathname, (char *)xv_get (editEdit, PANEL_VALUE));
	if (scriptPathname[0])
	{
		textsw_store_file (textedit->GetTextsw(), scriptPathname, 0, 0);
		xv_set (editFrame, FRAME_LABEL, scriptPathname, NULL);
	}
}


//----- EditSaveBut -----------------------------------------------------------

void TclCommander::EditSaveBut (Panel_item item, Event *event)
{
  EditDoSave();
}


//----- EditSaveAndCloseBut ---------------------------------------------------

void TclCommander::EditSaveAndCloseBut (Panel_item item, Event *event)
{
  EditDoSave();
  delete textedit;
  textedit = NULL;
  xv_destroy_safe (editFrame);
  // <M> delete self, notify owner
}


//----- EditAbortBut ----------------------------------------------------------

void TclCommander::EditAbortBut (Panel_item item, Event *event)
{
  delete textedit;
  textedit = NULL;
  xv_destroy_safe (editFrame);
  // <M> delete self, notify owner
}


//----- EditHelpBut -----------------------------------------------------------

void TclCommander::EditHelpBut (Panel_item item, Event *event)
{
	cout << "Collage-Two: Sorry, no help for TclCommander, yet." << endl;
}


//----- EditLoadBut -----------------------------------------------------------

void TclCommander::EditLoadBut (Panel_item item, Event *event)
{
	strcpy (scriptPathname, (char *)xv_get (editEdit, PANEL_VALUE));
	textedit->Load (scriptPathname);
	// xv_set (editFrame, FRAME_LABEL, scriptPathname, NULL);
}


//----- EditRunBut ------------------------------------------------------------

void TclCommander::EditRunBut (Panel_item item, Event *event)
{
	EditDoSave ();

	int result = Tcl_EvalFile (interp, scriptPathname);
	if (result != TCL_OK)
		cerr << interp->result << endl;
}

