//
// basic.h  --  CollageTwo
//
// Definition of basic types, constants and functions
//
// Author		: Nils Schwabe
// Date of creation 	: Feb 94
// Last modification	: 24 Mar 97 ns
//
// University of Bremen, Germany
//

#ifndef __BASIC_H__
#define __BASIC_H__


// ----- Global switches ------------------------------------------------------

#define LINUX 0
	// Set to 1 if this is a Linux system.

#define USETCL 1
	// Set to 1 to include support for Tcl scripts.

#if USETCL
# if LINUX
# include <tcl.h>
# else
# include <tcl.h>
# endif
#endif

extern unsigned int csMaxObjects;
	// Maximum number of generated parts and/or hyperedges
	// in a collage. The derivation is aborted if this limit
	// is exceeded.
	// Must be defined in main module.
	


// ----- Types ----------------------------------------------------------------

typedef int Boolean;
enum {False, True};
	// Type of truth values.

typedef unsigned int uint;
	// Shorthand for signed integer.

typedef unsigned short ushort;
	// Shorthand for unsigned integer.

typedef double Coordinate;
	// Type of a coordinate. This is required to be an integral
	// numeric type, such as int, float, double, etc.

typedef int ColorIndex;
	// Type of an index into the system's colour table.


// ----- RGB color ------------------------------------------------------------

typedef unsigned char RGBElem;
	// Range of a single colour channel. The systems always assumes a
	// 24-bit RGB colouring model.

class RGBValue
{
public:
	RGBValue ()                                           {r=0; g=0; b=0;}

		// Init RGB value with all channels set to zero.

	RGBValue (RGBElem red, RGBElem green, RGBElem blue)
	                                             {r=red; g=green; b=blue;}

		// Init RGB value with specified values for the colour channels.

	// (Default copy and assignment semantics are ok.)
	
	void Set      (RGBElem red, RGBElem green, RGBElem blue)
	                                             {r=red; g=green; b=blue;}

		// Set the values of all three colour channels.

	void SetRed   (RGBElem red)                                 {r = red;}
	void SetGreen (RGBElem green)                             {g = green;}
	void SetBlue  (RGBElem blue)                               {b = blue;}

		// Set the value of the specified colour channel.

	RGBElem Red () const                                       {return r;}
	RGBElem Green () const                                     {return g;}
	RGBElem Blue () const                                      {return b;}

		// Return the value of the specified colour channel.
		
	int operator== (const RGBValue &cmp) const
	{
		return r == cmp.r && g == cmp.g && b == cmp.b;
	}

private:
	RGBElem r,g,b;
};


// ----- Template list facilities ---------------------------------------------

#include "slists.h"


// ----- String class ---------------------------------------------------------

#include "sstring.h"


// ------- Textblock ----------------------------------------------------------

typedef SList<char *> Textblock;
	// A list of string pointers.


// ----- Constants ------------------------------------------------------------

const DrawDim1Y  = 100; 
	// Y screen output coordinate for 1-D points

const PSOutDim1Y = 100; 
	// Y postscript output coordinate for 1-D points


#endif /* !defined(__BASIC_H__) */

