//
// cgi.cc  --  CollageSystem
//
// CollageSystem Graphics Interface
//
// Author: N. Schwabe
// Date of creation : 12/93
// Last modification: 4/94
//
// University of Bremen, Germany
//

#include <string.h>
#include <iostream.h>
#include "cgi.h"
#include "cgi_p.h"

// ------- ScreenWin ----------------------------------------------------------

ScreenWin::ScreenWin (unsigned long maxCommands, 
                      unsigned long maxCoordinates)
{
  // Init the private part:
  p = new CgiPrivate (maxCommands, maxCoordinates);
}

ScreenWin::~ScreenWin ()
{
	// xv_destroy_safe (frame);
}

void ScreenWin::FgColor (int c)
{
  CgiCommand *cmd = p->NewCmd(CGI_FG_COLOR);
  if (! cmd) return;
  cmd->u.cntArg = 1;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = c;
}

void ScreenWin::FgColor (int r, int g, int b)
{
  CgiCommand *cmd = p->NewCmd(CGI_FG_COLRGB);
  if (! cmd) return;
  cmd->u.cntArg = 3;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = r;
  cmd->args[1] = g;
  cmd->args[2] = b;
}

void ScreenWin::BgColor (int c)
{  
  CgiCommand *cmd = p->NewCmd(CGI_BG_COLOR);
  if (! cmd) return;
  cmd->u.cntArg = 1;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = c;
}

void ScreenWin::BgColor (int r, int g, int b)
{
  CgiCommand *cmd = p->NewCmd(CGI_BG_COLRGB);
  if (! cmd) return;
  cmd->u.cntArg = 3;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = r;
  cmd->args[1] = g;
  cmd->args[2] = b;
}

void ScreenWin::Clear ()
{
  // if (nextCmd > 0 && p->commands[nextCmd-1].command == CGI_CLEAR) return;
  CgiCommand *cmd = p->NewCmd(CGI_CLEAR);
  if (! cmd) return;
  cmd->u.cntArg = 0;
  cmd->args = NULL;
}

void ScreenWin::Point (Coordinate x, Coordinate y)
{
  CgiCommand *cmd = p->NewCmd(CGI_POINT);
  if (! cmd) return;
  cmd->u.cntArg = 2;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = x;
  cmd->args[1] = y;
}

void ScreenWin::Line (Coordinate x1, Coordinate y1, Coordinate x2, Coordinate y2) 
{
  CgiCommand *cmd = p->NewCmd(CGI_LINE);
  if (! cmd) return;
  cmd->u.cntArg = 4;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = x1;
  cmd->args[1] = y1;
  cmd->args[2] = x2;
  cmd->args[3] = y2;
}

void ScreenWin::MoveTo (Coordinate x, Coordinate y)
{
  CgiCommand *cmd = p->NewCmd(CGI_MOVE_TO);
  if (! cmd) return;
  cmd->u.cntArg = 2;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = x;
  cmd->args[1] = y;
}

void ScreenWin::LineTo (Coordinate x, Coordinate y)
{
  CgiCommand *cmd = p->NewCmd(CGI_LINE_TO);
  if (! cmd) return;
  cmd->u.cntArg = 2;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = x;
  cmd->args[1] = y;
}

void ScreenWin::Poly (int count, Coordinate pp[])
{
  CgiCommand *cmd = p->NewCmd(CGI_POLY);
  if (! cmd) return;
  cmd->u.cntArg = count*2;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  memcpy (cmd->args, pp, cmd->u.cntArg*sizeof(Coordinate));
}

void ScreenWin::FilledPoly (int count, Coordinate pp[])
{
  CgiCommand *cmd = p->NewCmd(CGI_FILLED_POLY);
  if (! cmd) return;
  cmd->u.cntArg = count*2;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  memcpy (cmd->args, pp, cmd->u.cntArg*sizeof(Coordinate));
}

void ScreenWin::RealEllipse 
    (Coordinate first_x1, Coordinate first_y1, Coordinate first_x2, Coordinate first_y2,
     Coordinate secnd_x1, Coordinate secnd_y1, Coordinate secnd_x2, Coordinate secnd_y2,
     float begAngle, float endAngle)
{
  CgiCommand *cmd = p->NewCmd(CGI_REAL_ELLIPSE);
  if (! cmd) return;
  cmd->u.cntArg = 10;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = first_x1;
  cmd->args[1] = first_y1;
  cmd->args[2] = first_x2;
  cmd->args[3] = first_y2;
  cmd->args[4] = secnd_x1;
  cmd->args[5] = secnd_y1;
  cmd->args[6] = secnd_x2;
  cmd->args[7] = secnd_y2;
  cmd->args[8] = begAngle;
  cmd->args[9] = endAngle;
}

void ScreenWin::Ellipse (Coordinate x, Coordinate y, Coordinate r1,
                               Coordinate r2, Boolean scale)
{
  CgiCommand *cmd = p->NewCmd(CGI_ELLIPSE);
  if (! cmd) return;
  cmd->u.cntArg = 5;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = x;
  cmd->args[1] = y;
  cmd->args[2] = r1;
  cmd->args[3] = r2;
  cmd->args[4] = scale;
}

void ScreenWin::FilledEllipse (Coordinate x, Coordinate y, Coordinate r1,
                               Coordinate r2, Boolean scale)
{
  CgiCommand *cmd = p->NewCmd(CGI_FILLED_ELLIPSE);
  if (! cmd) return;
  cmd->u.cntArg = 5;
  if ((cmd->args = p->AllocCoords(cmd->u.cntArg)) == NULL) return;
  cmd->args[0] = x;
  cmd->args[1] = y;
  cmd->args[2] = r1;
  cmd->args[3] = r2;
  cmd->args[4] = scale;
}

void ScreenWin::Text (Coordinate x, Coordinate y, const char *text)
{
  CgiCommand *cmd = p->NewCmd(CGI_TEXT);
  if (! cmd) return;
  cmd->u.string = new char[strlen(text)+1];
  strcpy (cmd->u.string, text);
  if ((cmd->args = p->AllocCoords(2)) == NULL) return;
  cmd->args[0] = x;
  cmd->args[1] = y;
}

void ScreenWin::BoxText (Coordinate cx, Coordinate cy, uint width, 
                         uint height, Boolean frame, const char *text)
{
  CgiCommand *cmd = p->NewCmd(CGI_BOXTEXT);
  if (! cmd) return;
  cmd->u.string = new char[strlen(text)+1];
  strcpy (cmd->u.string, text);
  if ((cmd->args = p->AllocCoords(5)) == NULL) return;
  cmd->args[0] = cx;
  cmd->args[1] = cy;
  cmd->args[2] = width;
  cmd->args[3] = height;
  cmd->args[4] = frame;
}

void ScreenWin::PageTitle (const char *text)
{
  CgiCommand *cmd = p->NewCmd(CGI_PAGE_TITLE);
  if (! cmd) return;
  cmd->u.string = new char[strlen(text)+1];
  strcpy (cmd->u.string, text);
  cmd->args = NULL;
}

void ScreenWin::DoProgram 
	(	int argc, char *argv[],
		UserProgram theProgram,
		int width, int height)
{
  p->DoProgram (argc, argv, theProgram, width, height);
}

