#ifndef __CGI_H__
#define __CGI_H__
//
// cgi.h  --  CollageTwo
//
// CollageTwo portable Graphics Interface
//
// Author            : Nils Schwabe
// Date of creation  : Dec 93
// Last modification : Apr 96
//
// University of Bremen, Germany
//

#include "basic.h"

class CollageEnvi;
class CgiPrivate;

typedef void (*UserProgram)
	(int argc, char *argv[], CollageEnvi &envi);

class ScreenWin
{
public:
	ScreenWin (unsigned long maxCommands = 30000, 
	           unsigned long maxCoords =  180000);
	~ScreenWin ();
	
	void FgColor (int c);
	void FgColor (int r, int g, int b);
	void BgColor (int c);
	void BgColor (int r, int g, int b);
	void Clear ();
	void Point (Coordinate x, Coordinate y);
	void Line (Coordinate x1, Coordinate y1, Coordinate x2, Coordinate y2);
	void MoveTo (Coordinate x, Coordinate y);
	void LineTo (Coordinate x, Coordinate y);
	void Poly (int count, Coordinate p[]);
	void FilledPoly (int count, Coordinate p[]);
	void RealEllipse (Coordinate first_x1, Coordinate first_y1, 
	                  Coordinate first_x2, Coordinate first_y2,
                          Coordinate secnd_x1, Coordinate secnd_y1, 
	                  Coordinate secnd_x2, Coordinate secnd_y2,
                          float begAngle, float endAngle);
	void Ellipse (Coordinate x, Coordinate y,
	              Coordinate r1, Coordinate r2, Boolean scale);
	void FilledEllipse (Coordinate x, Coordinate y, 
	                    Coordinate r1, Coordinate r2, Boolean scale);
	void Text (Coordinate x, Coordinate y, const char *text);
	void BoxText (Coordinate cx, Coordinate cy, uint width, uint height,
	              Boolean frame, const char *text);
	void PageTitle (const char *text);

	void DoProgram (int argc, char *argv[], UserProgram theProgram,
	                int width, int height);

private:
	CgiPrivate *p;
};

extern ScreenWin *theScreen; // must be defined by the main module. 

#endif /* !defined(__CGI_H__) */

