#ifndef __CGI_P_H__
#define __CGI_P_H__
//
// cgi_p.h  --  CollageTwo
//
// System dependent implementation class for CGI (X/XView version)
//
// Author             : Nils Schwabe
// Date of creation   : 23 Apr 94
// Last modification  : 04 Feb 96
//
// University of Bremen, Germany
//

//----- Includes ------------------------------------------------------------------------

#include "cgi.h" 
// this is not circular since cgi.h 
// does not need to include cgi_p.h.

#ifndef __ENVI_H__
#include "envi.h"
#endif

extern "C" {
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/xv_xrect.h>
#include <xview/scrollbar.h>
#include <xview/cms.h>
#include <xview/file_chsr.h>
#include <xview/textsw.h>
}
#include <xvcpp.h>
#include <xvtextsw.h>


//----- CGI command types ---------------------------------------------------------------

enum CgiCmdType 
{
  CGI_FG_COLOR,
  CGI_FG_COLRGB,
  CGI_BG_COLOR,
  CGI_BG_COLRGB,
  CGI_CLEAR,
  CGI_POINT,
  CGI_LINE,
  CGI_MOVE_TO,
  CGI_LINE_TO,
  CGI_POLY,
  CGI_FILLED_POLY,
  CGI_REAL_ELLIPSE,
  CGI_ELLIPSE,
  CGI_FILLED_ELLIPSE,
  CGI_TEXT,
  CGI_BOXTEXT,
  CGI_PAGE_TITLE,
};

class CgiCommand
{
public:
  CgiCmdType command;
  union {
    unsigned int cntArg;
    char *string;
  } u;
  Coordinate *args;
}; 

const cgiMaxArgs = 5;


//----- CGI private class (X/XView implementation) --------------------------------------

class CgiPrivate
{
public: 
	CgiPrivate (unsigned long maxCommands, 
	            unsigned long maxCoordinates);

	// Program execution:
	
	void DoProgram (int argc, char *argv[], UserProgram theProgram,
	                int width, int height);

	// Metafile-buffer:
	
	int maxCmds;
	int nextCmd; 
	CgiCommand *commands;
	CgiCommand *NewCmd (CgiCmdType);
	int maxCoords;
	Coordinate *coordHeap, *nextCoord;
	Coordinate *AllocCoords (unsigned int cnt);

	void Again (const char *arg); 
		// This function should be treated as private,
		// it is declared public for technical reasons only.
		
	Frame GetFrame () const {return frame;}

private:

	// The user program:
	
	UserProgram _userPrg; 
	int _userArgc;
	char *_userArgv[cgiMaxArgs]; // makes a copy of the command-line args
	void DoRunPrg();

	// XView event handling:
	
	void FrameEvent(Xv_Window window, Event *event, Notify_arg arg);
	void EditFrameEvent(Xv_Window window, Event *event, Notify_arg arg);
	void CanvasRepaintProc 
		(Canvas, Xv_Window, Display*, Window, Xv_xrectlist*);	
	void MenuFile (Menu menu, Menu_item menu_item);
	void MenuView (Menu menu, Menu_item menu_item);
	void CanvasEvent(Xv_Window window, Event *event, Notify_arg arg);
	void FileChooserNotify (File_chooser, char *, char *);
	Notify_value FCDestroyIP (Notify_client client, Destroy_status status);

public:
	void PrevPage (Panel_item item, Event *event); // also used as button
	void NextPage (Panel_item item, Event *event); // dto.
	void FirstPage ();
	void LastPage ();
	void ScrollLeft ();
	void ScrollRight ();
	void ScrollUp ();
	void ScrollDown ();
	void ZoomIn ();
	void ZoomOut ();
	void Reset ();
	void DoSnapshot (char *filename);
	void Snapshot (Panel_item item, Event *event);
	void Quit ();
	void Load ();
	void Edit ();
	void NewCommander ();
	void EditDoSave();
	void EditRunBut (Panel_item item, Event *event);
	void EditSaveBut (Panel_item item, Event *event);
	void EditSaveAndCloseBut (Panel_item item, Event *event);
	void EditAbortBut (Panel_item item, Event *event);
	void EditHelpBut (Panel_item item, Event *event);
	void EditLoadBut (Panel_item item, Event *event);
	void EditSyncNewFile ();
	
	void SetWindowTitle();
	void CreateRubberGC();
	void CreatePaintingGC();
	void DrawRubber (int x, int y, int w, int h);
	void ZoomRect (int x, int y, int w, int h);
	void ZoomRectAnimated (int x, int y, int w, int h);
	
	// Collage environment:
	
	CollageEnvi envi;

private:
	// X and XView variables:
	GC _gc;
        Xv_Window _paint_window;
	Display *_dpy;
	Window _xwin;
        int _width, _height;
	Frame frame, editFrame;
	Canvas canvas;
	Textedit *textedit;
	Panel panel, editPanel;
	Menu menuFile, menuView;
	Panel_item butPrevPage, butNextPage, editEdit, butSnapshot;
	File_chooser fsel;
	GC rubber_gc;
	Colormap colmap;

	class RGBCache
	{
	public:
		RGBCache ();

		void SetTrueColor (Boolean trueCol) {trueColor = trueCol;}
		void Reset (Display *dpy);

		unsigned long GetIndex
			(	unsigned char red, 
				unsigned char green, 
				unsigned char blue);

		struct Entry 
		{
			unsigned char r, g, b;
			unsigned long colindex;
		};
		SList<Entry> cache;
		Display *dpy;
		Boolean trueColor;
	};
	RGBCache rgbCache;

	// Current output state:
	
	int nextOut;
	int cntPages, actPage;
	int elemsOnPage;
	Coordinate xoffs, yoffs;
	double xzoom, yzoom;
	Coordinate actx, acty; // last MoveTo/LineTo position
	int fgColor, bgColor;
	Boolean vrPageShown; // 0 => Always show the current page again

	// Output routines:
	
	int XOUT (double x) {return (int)(x*xzoom+xoffs);}
	int YOUT (double y) {return _height-(int)(y*yzoom+yoffs);}
	void DoCommand (CgiCommand *cmd);
	void ShowNewPage ();
	void ShowThisPage ();
	void DoFgColor (int c);
	void DoFgColor (int r, int g, int b);
	void DoBgColor (int c);
	void DoBgColor (int r, int g, int b);
	void DoClear ();
	void DoPoint (Coordinate x, Coordinate y);
	void DoLine (Coordinate x1, Coordinate y1, 
	             Coordinate x2, Coordinate y2);
	void DoMoveTo (Coordinate x, Coordinate y);
	void DoLineTo (Coordinate x, Coordinate y);
	void DoPoly (int count, Coordinate p[]);
	void DoFilledPoly (int count, Coordinate p[]);
	void DoRealEllipse (Coordinate first_x1, Coordinate first_y1, 
	                    Coordinate first_x2, Coordinate first_y2,
                            Coordinate secnd_x1, Coordinate secnd_y1, 
	                    Coordinate secnd_x2, Coordinate secnd_y2,
                            float begAngle, float endAngle);
	void DoEllipse (Coordinate x, Coordinate y, Coordinate r1, 
	                Coordinate r2, Boolean scale, Boolean fill);
	void DoText (Coordinate x, Coordinate y, const char *text);
	void DoBoxText (Coordinate cx, Coordinate cy, uint width,
	                uint height, Boolean frame, const char *text);
	void DoPageTitle (const char *text);
};

#endif /* !defined(__CGI_P_H__) */

