
#------	AllRedGreenBlue ---------------------------------------------------------

set myR 0
set myG 0
set myB 0

proc AllRedGreenBlue {step redV greenV blueV} {

	global myR myG myB 

	upvar $redV red
	upvar $greenV green
	upvar $blueV blue

	set red $myR
	set green $myG
	set blue $myB
	#set red 2
	#set green 2
	#set blue 2

	incr myR 25
	if {$myR > 255} {
		set myR 0
		incr myG 25
		if {$myG > 255} {
			set myG 0
			incr myB 25
			if {$myB > 255} {
				set myB 0
			}
		}
	}
}


#------	Continuum ---------------------------------------------------------------

set contR 0.0
set contG 0.0
set contB 0.0
set incR .23
set incG .15
set incB .1

proc Continuum {step redV greenV blueV} {

	global contR contG contB incR incG incB

	upvar $redV red
	upvar $greenV green
	upvar $blueV blue

	set red $contR
	set green $contG
	set blue $contB


	set contR [expr $contR + $incR]
	if {[expr ($contR > 254.0) || ($contR <= 0.0)]} {
		if {$contR > 254.0} {
			set contR 254.0
		} else {
			set contR 0.0
		}
		set incR [expr -($incR)]
	}

	set contG [expr $contG + $incG]
	if {[expr ($contG > 254.0) || ($contG <= 0.0)]} {
		if {$contG > 254.0} {
			set contG 254.0
		} else {
			set contG 0.0
		}
		set incG [expr -($incG)]
	}

	set contB [expr $contB + $incB]
	if {[expr ($contB > 254.0) || ($contB <= 0.0)]} {
		if {$contB > 254.0} {
			set contB 254.0
		} else {
			set contB 0.0
		}
		set incB [expr -($incB)]
	}
}


#------	StepContinuum -----------------------------------------------------------

# Increment pro Step:
set stepincR .23
set stepincG .15
set stepincB .1

# Minimum:
set stepbotR 0.0
set stepbotG 0.0
set stepbotB 0.0

# Maximum:
set steptopR 254.0
set steptopG 254.0
set steptopB 254.0

# (Intern) Aktuelle Werte:
set lastStep  0
set stepcontR $stepbotR
set stepcontG $stepbotG
set stepcontB $stepbotB

proc StepContinuum {step redV greenV blueV} {

	global lastStep stepcontR stepcontG stepcontB stepincR stepincG stepincB
	global stepbotR stepbotG stepbotB steptopR steptopG steptopB

	upvar $redV red
	upvar $greenV green
	upvar $blueV blue

	if {[expr $lastStep != $step]} {

		set stepcontR [expr $stepcontR + $stepincR]
		if {[expr ($stepcontR > $steptopR) || ($stepcontR <= $stepbotR)]} {
			if {$stepcontR > $steptopR} {
				set stepcontR $steptopR
			} else {
				set stepcontR $stepbotR
			}
			set stepincR [expr -($stepincR)]
		}			

		set stepcontG [expr $stepcontG + $stepincG]
		if {[expr ($stepcontG > $steptopG) || ($stepcontG <= $stepbotG)]} {
			if {$stepcontG > $steptopG} {
				set stepcontG $steptopG
			} else {
				set stepcontG $stepbotG
			}
			set stepincG [expr -($stepincG)]
		}

		set stepcontB [expr $stepcontB + $stepincB]
		if {[expr ($stepcontB > $steptopB) || ($stepcontB <= $stepbotB)]} {
			if {$stepcontB > $steptopB} {
				set stepcontB $steptopB
			} else {
				set stepcontB $stepbotB
			}
			set stepincB [expr -($stepincB)]
		}

		set lastStep $step
	} 

	set red $stepcontR
	set green $stepcontG
	set blue $stepcontB
}


#------	AddStep ----------------------------------------------------------------

set stepAddR 0.3
set stepAddG 0.5
set stepAddB 0.7

set stepAddBotR 0
set stepAddBotG 0
set stepAddBotB 0
set stepAddTopR 254
set stepAddTopG 254
set stepAddTopB 254


proc AddStep {step redV greenV blueV} {

	global stepAddR stepAddG stepAddB
	global stepAddBotR stepAddBotG stepAddBotB
	global stepAddTopR stepAddTopG stepAddTopB
	upvar $redV red
	upvar $greenV green
	upvar $blueV blue

	set red [expr $red + $step * $stepAddR]
	set green [expr $green + $step * $stepAddG]
	set blue [expr $blue + $step * $stepAddB]

	if {[expr $red < $stepAddBotR]} {
		set red $stepAddBotR
	} elseif {[expr $red > $stepAddTopR]} {
		set red $stepAddTopR
	}

	if {[expr $green < $stepAddBotG]} {
		set green $stepAddBotG
	} elseif {[expr $green > $stepAddTopG]} {
		set green $stepAddTopG
	}

	if {[expr $blue < $stepAddBotB]} {
		set blue $stepAddBotB
	} elseif {[expr $blue > $stepAddTopB]} {
		set blue $stepAddTopB
	}
}


#------	AddCalls ---------------------------------------------------------------

set cntCalls 0
set callAddR .15
set callAddG 0.0
set callAddB .15

proc AddCalls  {step redV greenV blueV} {

	global cntCalls callAddR callAddG callAddB

	upvar $redV red
	upvar $greenV green
	upvar $blueV blue

	set red [expr $red + $cntCalls * $callAddR]
	set green [expr $green + $cntCalls * $callAddG]
	set blue [expr $blue + $cntCalls * $callAddB]

	incr cntCalls

}

puts "--- Colorprocs are now defined."

