//
// collsys.cc --  CollageVR
//
// CollageVR main module
//
// Authors: N. Schwabe
// Date of creation : ~1/94
// Last modification: 08 Jan 97
//
// University of Bremen, Germany
//


#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <iostream.h>
#include <fstream.h>
#include "collage.h"
#include "grammar.h"
#include "psout.h"
#include "vrout.h"
#include "cgi.h"
#include "envi.h"

ScreenWin *theScreen = 0;
PSOut thePS;
VROut theVR;
unsigned int csMaxObjects = 100000;


void CollageMain (int argc, char *argv[], CollageEnvi &envi)
{
  if (argc <= 1) return; // no grammar file specified

  theVR.Reset();

  if (ReadCollageFile (argv[1], &envi)) {

    // init random generator:
    if (envi.randInit == 0) {
#if LINUX
      int seed = time(NULL);
      srandom (seed);
#else
      int seed = time(NULL);
      srand (seed);
#endif
      if (theScreen)
          cout << "CollageSystem: /randomInit " << seed << endl;
    }
    else
#if LINUX
      srandom (envi.randInit);
#else
      srand (envi.randInit);
#endif   

    if (envi.bboxCalc)  // bounding box options are used
        thePS.SetBBoxCalculator (envi.bboxCalc);

    envi.CG->Normalize(envi.annotated);
    if (envi.annotated)
    	envi.CG->Annotate();
    Grammar (envi); 
    
    delete envi.CG;
    envi.CG = NULL;
        
#if (! LINUX)
    delete envi.derivationTable;  // <T> UNKNOWN BUG under Linux in slists.cc.200 !!!
    envi.derivationTable = NULL;
#endif

    thePS.Reset();
  }
  else {
    if (envi.CG) 
    {
    	delete envi.CG;
    	envi.CG = NULL;
    }
    if (envi.derivationTable) 
    {
    	delete envi.derivationTable;
    	envi.derivationTable = NULL;
    }
    thePS.Reset();
  }
}


int main (int argc, char *argv[]) 
{
	Boolean silent = False;	
	char* listFile = "csresult.txt";
	char* errFile = "cserr.txt";
	
	if (argc >= 3)	
	{
		if (strcmp(argv[2],"-silent") == 0)
		{
			silent = True;
			if (argc >= 4)
				listFile = argv[3];
		}
	}
	
	if (silent)
	{
		//
		// Silent running - no screen output, no interaction.
		//
		
		cout << "CollageVR - silent run..." << endl;
		
		CollageEnvi envi;
		csMaxObjects = 20000; 
		
			CollageMain (argc, argv, envi);
		
			//
			// Generate list file
			//
			ofstream f(listFile);
			if (envi.vrOutput)
			{
				//
				// Generate text file with list of generated VRML output files.
				//
				char vrFileName[256];
				int i = 1;
				theVR.GetNameOfNthFile (1, vrFileName);
				while (vrFileName[0])
				{
					f << vrFileName << endl;
					theVR.GetNameOfNthFile (++i, vrFileName);
				}
			}
			
			//
			// Generate error file
			//
			ofstream e(errFile);
			e << theEnvi->errorMsg << endl;

	}
	else
	{
		//
		// Interactive session.
		//
		theScreen = new ScreenWin (30000*5, 180000*5);
		theScreen->DoProgram (argc, argv, CollageMain, 640, 200);
	}
	return 42;	// <T>
}

