
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include "collage.h"
#include "trans.h"
#include "yytypes.h"
#include "cgi.h"
#include "envi.h"

CollageEnvi *theEnvi = 0;
jmp_buf csjmpbuf;

CollageEnvi::CollageEnvi()
{
	CG = NULL;
	derivationTable = NULL;
	output = False;
	filenamePattern[0] = 0;
	vrOutput = False;
	vrFilenamePattern[0] = 0;
	annotated = False;
	lastOnly = False;
	dimensions = 2;
	colorStepIncr = False;
	randInit = 0;
	bboxCalc = NULL;
	redIncr = 0;
	greenIncr = 0;
	blueIncr = 0;
	textureIncr = 0;
#if USETCL
	interp = NULL;
#endif
	colourContext = False;
	mergeParts = False;
	kInverse = False;
	errorMsg[0] = 0;
}


Boolean ReadCollageFile
	(	char        *pathname,
		CollageEnvi *envi)
{
	FILE *input, *oldyy;
	static Boolean firstScan = True;

	input = fopen (pathname, "r");
	if (! input) {
		if (!strstr (pathname, ".cgr"))
			strcat (pathname, ".cgr");
		input = fopen (pathname, "r");
		if (! input) {
			char cur[200]="cgr/";
			strcat (cur, pathname);
			strcpy (pathname, cur);
			input = fopen (pathname, "r");
			if (! input) {
				cout << "Grammar file '" << pathname << "' not found." << endl;
				return False;
			}
		}
	}

#if USE_CPP
	// use the C preprocessor as a precompiler:
	{
		char command[300];
		int res;
		fclose (input);
#if 0
		sprintf (command, "gcc -x c-header -nostdinc -P -E %s -o _cs_tmp.cgr", pathname);
#else
		sprintf (command, CPP_COMMAND, pathname, "_cs_tmp.cgr");
#endif
//		cerr << command << endl;
		if ((res = system (command)) != 0)
			cerr << "system command error. return code = " << res << endl;
//		cerr << "finished." << endl;
		input = fopen ("_cs_tmp.cgr", "r");
		if (! input) {
			cerr << "Can't open preprocessed grammar file." << endl;
			return False;
		}
	}
#endif	

	// Create new CollageGrammar and Table:
	envi->CG = new CollageGrammar;
	envi->derivationTable = new Table;

	// Set default values:	
	envi->output = False;
	envi->filenamePattern[0] = 0;
	envi->vrOutput = False;
	envi->vrFilenamePattern[0] = 0;	
	envi->annotated = False;
	envi->lastOnly = False;
	envi->dimensions = 2;
	envi->colorStepIncr = False;
	envi->randInit = 0;
	envi->bboxCalc = NULL;
	envi->redIncr = 0;
	envi->greenIncr = 0;
	envi->blueIncr = 0;
	envi->textureIncr = 0;
	envi->colourContext = False;
	envi->mergeParts = False;
	envi->kInverse = False;
	envi->errorMsg[0] = 0;
	while (envi->tableInfoList.GetAt (0))
		envi->tableInfoList.Delete ();
	
	// Set global 'theEnvi' variable to point to this envi:
	theEnvi = envi;

	oldyy = yyin;
	if (firstScan)
		firstScan = False;
	else
		yyrestart (input);
	yyin = input;

	Boolean parseok=True;
	if (setjmp (csjmpbuf) == 0) 
		while (yyparse());
	else {
		parseok = False;
#ifdef CS_BIZARR

#else 
		if (theScreen)
			theScreen->Text (30, 100, yytextbuf);
		strcpy(envi->errorMsg, yytextbuf);
#endif
	}
	
	yyin = oldyy;
	// theEnvi = 0;   <A> now also needed afterwards by other classes !
	fclose (input);
	return parseok;
}

