#ifndef __ENVI_H__
#define __ENVI_H__
//
// envi.h  --  CollageVR
//
// CollageTwo environment information
//
// Author            : Nils Schwabe
// Date of creation  : Feb 94
// Last modification : 04 Dec 96 ns
//
// University of Bremen, Germany
//

#include "boundbox.h"
#include "collage.h"
#include "trans.h"

#define USE_CPP 1
	// 1 -> call C preprocessor on grammar input file.

#define CPP_COMMAND "gcc -x c-header -Icgrlib -I../cgrlib -P -E %s -o %s"
	// Command name of c preprocessor with arguments.
	// Must be a quoted string. The first %s is replaced by the
	// name of the grammar file and the second %s is replaced by the 
	// name of the temporary file.
	
#define VRVIEW_COMMAND "vrweb -bg3d black -remote %s &"
	// Command name of the VRML viewer. The parameter is the name
	// of the VRML file.

class CollageEnvi
{
public:
	CollageEnvi();
	
	// The parsed collage grammar:
	CollageGrammar        *CG;
	
	// Derivation table:
	Table                 *derivationTable;
	TableInfoList         tableInfoList;
	
	// PostScript output:
	Boolean               output;        // PostScript output active?
	char                  filenamePattern[200]; // PS filename pattern
	
	// VRML output:
	Boolean               vrOutput;      // VRML output active?
	char                  vrFilenamePattern[200];
	 
	
	// Options:
	Boolean               annotated;     // Annotated collage grammar?
	Boolean               lastOnly;      // Generate only last picture
	unsigned int          dimensions;    // Number of euclidean dimensions
	Boolean               colorStepIncr; // Stepwise color increment?
	int                   redIncr, greenIncr, blueIncr, textureIncr;
	long                  randInit;      // 0 -> init with random value
	OptionBBoxList        bboxList;      // B.B. options list
	BoundingBoxCalculator *bboxCalc;     // == NULL <=> option not used
#if USETCL
	Tcl_Interp            *interp;       // A Tcl interpreter
#endif
	Boolean               colourContext; // Colour is significant in contexts
	Boolean               mergeParts;    // Merge "identical" parts	
	Boolean               kInverse;      // Kreo's 'inverse' collage grammars
	
	char                  errorMsg[256]; // last error message
};

extern CollageEnvi *theEnvi;
  // This is used by the scanner, the parser and in a few other places
  // where environment information is needed.
  // Assigned automatically in ReadCollageFile. No need to change this.

Boolean ReadCollageFile
	(	char        *pathname, // may be changed, should be >= 200 characters
		CollageEnvi *envi);

	// Opens and parses a collage grammar file and builds up all dynamic
	// structures. Returns True if successful.

#endif /* !defined(__ENVI_H__) */

