//
// grammar.cc  --  CollageSystem
//
// CollageSystem main derivation function
//
// Author: N. Schwabe
// Date of creation : ~1/94
// Last modification: 11/94
//
// University of Bremen, Germany
//

#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include "psout.h"
#include "vrout.h"
#include "collage.h"
#include "trans.h"
#include "cgi.h"
#include "grammar.h"

void Grammar (CollageEnvi &envi)
{
	char str[40];
	TableInfo defaultTableInfo (0);
	TableInfo *tableInfo;

	if (! envi.lastOnly)
	{
		if (theScreen)
		{
			// Screen output start:
			envi.CG->GetStart()->Draw();
			theScreen->PageTitle ("Axiom of grammar");
			theScreen->Clear();

			// Screen output rules:
			envi.CG->GetRules()->Draw();
		
			// Screen output start:
			// (Produces the same output here, but this is to remain
			// synced with the PostScript and VRML output)
			envi.CG->GetStart()->Draw();
			theScreen->PageTitle ("Start of derivation");
			theScreen->Clear();
		}
		
		// PostScript output:
		if (envi.output) 
		{
			// output grammar (start collage and rules):
			envi.CG->PSOut ();

			// output start collage again, now in derivation context:
			envi.CG->GetStart()->MakeBoundingBox(2);
			const BoundingBox *bb = envi.CG->GetStart()->GetBoundingBox();
			thePS.NewFile ("D", bb);
			envi.CG->GetStart()->PSOut (envi.CG->psbGlobal,
			                      envi.derivationTable->psbDerivation,
			                      envi.derivationTable->psbDerivStart);
		}
		
		// VRML output:
		if (envi.vrOutput) 
		{
			// output grammar (start collage and rules):
			envi.CG->VROut ();

			// output start collage again, now in derivation context:
			theVR.NewFile ("D");
			envi.CG->GetStart()->VROut ();
		}		
	}

	int maxDerivation;
	if (envi.derivationTable->GetMaxUntil (&maxDerivation)) 
	{
		int step = 1;
		Boolean endOfDerivation = False;
		Boolean didAlreadyAScreen = False;
		while (step <= maxDerivation && endOfDerivation == False) 
		{
			Base B;
			TableElement *tableElem;
			int i = step;
			int tableNr;

			while (   endOfDerivation == False 
			       && ! ((tableElem = envi.derivationTable->NextTable (i, &tableNr))))
			{
				i++;
				if (i > maxDerivation)
					endOfDerivation = True;
			}

			if (! endOfDerivation) 
			{
				tableInfo = envi.tableInfoList.Find (tableNr);
				if (! tableInfo)
				{
					defaultTableInfo.SetTable (tableNr);
					tableInfo = &defaultTableInfo;
				}
				if (B.Build (envi.CG->GetStart(), envi.CG->GetRules(), tableInfo, envi.kInverse) == False)
					endOfDerivation = True;

				if (! endOfDerivation)
				{
					// derive:
					envi.CG->GetStart()->DeriveWithBase (B, envi.colorStepIncr ? step : 0,
					        envi.kInverse
#if USETCL
							,envi.interp
#endif
							);
				}

					// output:
					if (envi.lastOnly == endOfDerivation || step == maxDerivation)
					{
						if (envi.output) 
						{
							envi.CG->GetStart()->MakeBoundingBox(2);
							const BoundingBox *bb = envi.CG->GetStart()->GetBoundingBox();
							thePS.NewFile ("D", bb);
							envi.CG->GetStart()->PSOut (envi.CG->psbGlobal,
							                      envi.derivationTable->psbDerivation,
							                      tableElem->psbTableElem);
						}

						if (envi.vrOutput) 
						{
							theVR.NewFile ("D");
							envi.CG->GetStart()->VROut ();
						}
						
						if (theScreen)
						{

							if (didAlreadyAScreen)
								theScreen->Clear();
							didAlreadyAScreen = True;
	
							envi.CG->GetStart()->Draw();
	
							// Now let's play a bit:
							switch (step) {
							case 1:	strcpy (str, "First"); break;
							case 2: strcpy (str, "Second"); break;
							case 3: strcpy (str, "Third"); break;
							case 4: strcpy (str, "Fourth"); break;
							case 5: strcpy (str, "Fifth"); break;
							default:
								if (step==maxDerivation)
									sprintf (str, "Last (%ith)", step);
								else 
									sprintf (str, "%ith", step); 
								break;
							}
							strcat (str, " step");
							theScreen->PageTitle (str);
						}
					}

					step++;
			}
		}
	}
	
	if (envi.vrOutput)
		theVR.Close ();


	// Bounding box patching:

	if (envi.bboxCalc)
	{
		cout << endl << "----- Modified Bounding Boxes: -----" << endl;
		BoundingBoxCalculator *c = envi.bboxCalc;
		PictBoundingBox *p = c->Boxes().GetAt (0);
		while (p)
		{
			if (p->group != 'B') // ignore pseudo pictures
			{
				BoundingBox bb(2);
				Boolean calc;
				if (! c->Calc (p->group, p->picture, &bb, &calc))
					cerr << "No bb-info for calculation!" << endl;
				else if (calc)
				{
					cout << p->group << p->picture << " : " 
					<< bb.GetAt(0)->min << " " 
					<< bb.GetAt(1)->min << " "
					<< bb.GetAt(0)->max << " "
					<< bb.GetAt(1)->max;
					cout << "  patching..."; cout.flush();
					char str[10];
					str[0] = p->group; str[1] = 0;
					if (thePS.PatchBBox (str, p->picture, &bb))
						cout << "ERROR.";
					else
						cout << "finished.";
					cout << endl;
					
					// <U> quick&dirty extension: patch context collage files:
					if (p->group == 'G')
					{
						cout << "  patching..."; cout.flush();
						if (thePS.PatchBBox (str, p->picture, &bb, "_C"))
							cout << "no context collage.";
						else
							cout << "finished.";
						cout << endl;
					}
					
				}
			}
			p = c->Boxes().GetNext ();
		}
		cout << "---------------------------------" << endl;
	}

}

