
#include "mathutil.h"
#include "matrix.h"


void Rotate3d
	(	const Point* p,         // in : point to rotate
		const Point* rotPoint,  // in : point on rotation axis
		const Point* rotDir,    // in : rotation axis direction
		double rotAngle,        // in : angle in rad
		Point* result)         // out: rotated point
{

	Matrix m (3, 3);
	
	result->Set (0, p->Get(0) - rotPoint->Get(0));
	result->Set (1, p->Get(1) - rotPoint->Get(1));
	result->Set (2, p->Get(2) - rotPoint->Get(2));
	
	double d = sqrt (  rotDir->Get(0) * rotDir->Get(0)
	                 + rotDir->Get(1) * rotDir->Get(1)
	                 + rotDir->Get(2) * rotDir->Get(2));
	
	Point n (3);
	n.Set (0, rotDir->Get(0) / d);
	n.Set (1, rotDir->Get(1) / d);
	n.Set (2, rotDir->Get(2) / d);
 
	double s = sin (rotAngle);
	double c = cos (rotAngle);
	double t = 1-c;
	
	m.Set (0,0, t * n.Get(0) * n.Get(0) + c);
	m.Set (0,1, t * n.Get(0) * n.Get(1) - s * n.Get(2));
	m.Set (0,2, t * n.Get(0) * n.Get(2) + s * n.Get(1));
	
	m.Set (1,0, t * n.Get(0) * n.Get(1) + s * n.Get(2));
	m.Set (1,1, t * n.Get(1) * n.Get(1) + c);
	m.Set (1,2, t * n.Get(1) * n.Get(2) - s * n.Get(0));
	
	m.Set (2,0, t * n.Get(0) * n.Get(2) - s * n.Get(1));
	m.Set (2,1, t * n.Get(1) * n.Get(2) + s * n.Get(0));
	m.Set (2,2, t * n.Get(2) * n.Get(2) + c);

	Point multResult (3);
	m.Multiply (*result, &multResult);

	result->Set (0, multResult.Get(0) + rotPoint->Get(0));
	result->Set (1, multResult.Get(1) + rotPoint->Get(1));
	result->Set (2, multResult.Get(2) + rotPoint->Get(2));
}
		
