#ifndef __MATRIX_H__
#define __MATRIX_H__
//
// matrix.h  --  Collage System Collage-Two
//
// Matrix class
//
// Author            : Nils Schwabe
// Date of creation  : Feb 94
// Last modification : 20 Nov 95
//
// University of Bremen, Germany
//

#ifndef __BASIC_H__
#include "basic.h"
#endif

#ifndef __POINT_H__
#include "point.h"
#endif

typedef Coordinate ME;    // Type of a matrix element

#include <math.h>
const ME mEpsilon = 0.01; // Intervall in which an element is treated as 0
                          // in some transformation tests.

class Matrix 
{
public:

	Matrix (uint cntRows, uint cntColumns); // construct nxm matrix
	Matrix (ME,ME,ME, ME,ME,ME, ME,ME,ME);  // construct and init 3x3 matrix
	virtual ~Matrix();
	Matrix (const Matrix &);                
	void operator=(const Matrix &);  

	ME Get (uint rw, uint cl) const {return e[rw*_columns+cl];}
	void Set (uint rw, uint cl, ME value) {e[rw*_columns+cl] = value;}

	uint GetRows() const {return rows;}
	uint GetColumns() const {return columns;}
	Boolean Resize (uint cntRows, uint cntColumns);

	void Multiply (const Matrix &v, Matrix *result) const;
	void Multiply (const Point &p, Point *result) const;
	Boolean Invert ();
	void TestOut (char *header);

private:
	ME *e; 
	uint rows, columns;
	uint _rows, _columns;
	void PivotStep (uint,uint);
	Boolean FindPivotColumns (uint, signed char *pcol);
};

#endif /* !defined(__MATRIX_H__) */

