// Generate all permutations of 'n' binary symbols within 'k' slots:
// (Especially used to generate the rules for the CA collage grammar.)
// Nils Schwabe Feb 96

#include <iostream.h>
#include <stdlib.h>
#include <string.h>

static void output (int k, char *a)
{
	int i=0;
	
	while (i < k)
	{
		if (a[i] == 0)
			cout << "0";
		else
			cout << "X";
		i++;
	}
	cout << endl;
}			

static void GameOfLifeOutput (char *a)   // k == 8 assumed
{
	char *s;
	cout << "rule D\n\tpins field(1,1)\n\t\ta(1,1)\n\tendcollage\n\tcontext\n\t\t";

	for (int i=0; i < 8; i++)
	{
		switch (i) {
		case 0: s = "(0,2)"; break;
		case 1: s = "(1,2)"; break;
		case 2: s = "(2,2)"; break;
		case 3: s = "(0,1)"; break;
		case 4: s = "(2,1)"; break;
		case 5: s = "(0,0)"; break;
		case 6: s = "(1,0)"; break;
		case 7: s = "(2,0)"; break;
		}
		cout << (a[i] ? "a" : "d") << s << " ";
	}
	cout << "\n\tendcollage\ntable 1\n";		
}		


static void permutate (int k, int num)
{
	char *a = new char[k];
	int i, rightX;
		
	memset (a, 1, num);
	memset (a+num, 0, k-num);
	
	for (;;)
	{
		if (k==8)
			GameOfLifeOutput (a);
		else
			output (k, a);
		
		// Skip all rightstanding X's:
		i = k-1;
		rightX = 0;
		while (i >= 0 && a[i] == 1)
		{
			i--;
			rightX++;
		}
		if (i < 0)
			return; // all filled with X (only one permutation)
		
		// Skip all 0's:
		while (i >= 0 && a[i] == 0)
			i--;
		if (i < 0)
			return; // finished, string has form "000xxx"
			
		// Push X one position to the right and append all read X's:
		a[i] = 0;
		memset (a+i+1,          1, rightX+1);
		memset (a+i+1+rightX+1, 0, k-rightX);
	}
}


int main (int argc, char *argv[])
{
	int k, num;
	
	if (argc < 3)
	{
		cout << "Usage: permutate <length> <num>" << endl;
		return 0;
	}
	
	k = atol (argv[1]);
	if (k <= 0)
	{
		cout << "length must be > 0" << endl;
		return 0;
	}
	
	num = atol (argv[2]);
	if (num < 0 || num > k)
	{
		cout << "num must be >= 0 and <= length" << endl;
		return 0;
	}
	
	permutate (k, num);
	return 0;
}
