#ifndef __POINT_H__
#define __POINT_H__
//
// point.h  --  CollageTwo
//
// Point, PointSequence 
//
// Author             : Nils Schwabe
// Date of creation   : Feb 94
// Last modification  : 16 Nov 95
//
// University of Bremen, Germany
//

#ifndef __BASIC_H__
#include "basic.h"
#endif

// ------ Point --------------------------------------------------------------- 

//        A point within the n-dimensional euclidian space.

const cntEffDim=3; 
          // number of dimensions that are handled 'efficiently', must be > 0.

const Coordinate pEpsilon = 0.03; // used in comparisons

class Point
{
public:
	Point (ushort dimensions); 

		// Constructs n-D point with all coordinates = 0.

	Point (Coordinate x, Coordinate y);

		// Constructs 2-D point with specified coordinates.

        Point (const Point &); 

		// Copies a point.

	void operator=(const Point &); 

		// Assigns another point of equal dimension.

	~Point ();

	Coordinate Get (uint index) const;

		// Gets the coordinate value for dimension 'index' (0..n).

	void Set (uint index, Coordinate newX);

		// Sets the coordinate value for dimension 'index' to 'newX'.

	ushort GetDim () const                                     {return dim;}

		// Returns the dimension of the point.

	int operator==(const Point &) const;

		// Returns non-zero if both points are equal.

	int operator!=(const Point &) const;

		// Returns non-zero if both points are not equal.

	void TestOut (const char *title) const;
	void PSOut () const;                    
	void VROut () const;

private:
	short dim;
	Coordinate x[cntEffDim];
	Coordinate *_x;
};

ostream& operator<< (ostream &s, const Point& p);


// ------- PointSequence ------------------------------------------------------

//         A sequence (list) of points. 
//         The points in the list have their own identity, i.e. they are
//         _not_ stored as references or pointers. 

class BoundingBox;

typedef SList<Point> Pointlist; 

class PointSequence : public Pointlist 
{
public:
	PointSequence () : Pointlist() {}
	PointSequence (const Pointlist& copy) : Pointlist(copy) {}
	void PSOut () const; 
	void VROut () const;
	void CalcBoundingBox (BoundingBox &bb) const;
	
	Boolean CyclicIdentical (const PointSequence &cmp) const;
};

ostream& operator<< (ostream &s, const PointSequence& ps);


#ifndef __BOUNDBOX_H__
#include "boundbox.h"
#endif


#endif /* !defined(__POINT_H__) */

