//
// psout.cc  --  CollageSystem
//
// Postscript output functions
//
// Authors: N. Schwabe, S. Taubenberger(original)
// Date of creation : 21.04.94
// Last modification: 4/94
//
// University of Bremen, Germany
//

#include <stdio.h>
#include <string.h>
#include "ps_title.h"
#include "psout.h"

static void OutputHeader (PSOut *p, Coordinate llx, Coordinate lly, 
                          Coordinate urx, Coordinate ury)
{
	int i=0;
	char *str;
	while ((str=page_title[i])) 
	{
		if (!strcmp(str, BB_FPRINT_STRING)) 
		{
			char m[100];
			sprintf (m, BB_FPRINT_STRING, llx, lly, urx, ury);
			p->Out (m);
		}
		else
			p->Out (str);
		i++;
	}
}


PSOut::PSOut ()
{
	Init();
}

PSOut::~PSOut()
{
  // ... close file if still open ...
}

void PSOut::Init()
{
	strcpy (pattern, "");
	strcpy (lastCategory, "");
	beginoutput = True;
	fileCounter = 0;
	variable = False;
	firstFile = True;
	endoutline = psoutline;
	length = 0;
	bbc = 0;
}

void PSOut::SetPattern (const char *filenamePattern)
{
	strcpy (pattern, filenamePattern);
}

short PSOut::Open (const char* fileName, ios::open_mode mode)
{
	file.open (fileName, mode);
	if (!file) {
		cerr << "Kann Datei " << fileName << "nicht oeffnen.\n";
		return 1;
	}
	else
		return 0;
}

short PSOut::Close () 
{
	short fehler = 0;
	file << flush;
	if (! file) 
	{
		cerr << "Fehler beim Schliessen der Datei." << endl;
		fehler = file.rdstate();
	}
	file.close();
	return fehler;
}

void PSOut::Reset()
{
	if (! firstFile) Close();
	Init();
}


short PSOut::NewFile (const char *category, const BoundingBox *bb,
                      const char *subCategory)
{
	char* patPtr = pattern;

	if (firstFile == True) {  // Erster Aufruf von NewFile
		while (*patPtr) {
			if (*patPtr == '%') {
				variable = True;
				break;
			}
			patPtr++;
		}
	}
	if (variable == True) {
		char fileName[250];
		if (firstFile == False) {
			Close ();
			if (! subCategory)
			{
				if (strcmp(category, lastCategory)==0) 
					fileCounter++;
				else
					fileCounter = 1;
			}
			// else: Leave fileCounter as it is
		}
		else {
			firstFile = False;
			fileCounter = 1;
		}
		strcpy (lastCategory, category);
		patPtr = pattern;
		while (*patPtr != '%') patPtr++;
		*patPtr = 0;
		if (! subCategory)
			subCategory = "";
		sprintf (fileName, "%s%s%03i%s%s", pattern, category,  fileCounter, subCategory, patPtr+1);
		*patPtr = '%';
		Open (fileName);

		if (bbc && bb)	
			bbc->SetPicture (category[0], fileCounter, *((BoundingBox *)bb)); // <u> const-cast


	}
	else
		if (firstFile == True) {
			firstFile = False;
			Open (pattern);
		}

	if (bb)
		OutputHeader (this, bb->GetAt(0)->min, bb->GetAt(1)->min,
	        	            bb->GetAt(0)->max, bb->GetAt(1)->max);
	return 0;
}

short PSOut::PatchBBox (const char *category, int number,
	                    const BoundingBox *bb, const char *subCategory)
{
	Close();

	if (variable == True) 
	{
		char fileName[250];
		char* patPtr = pattern;
		while (*patPtr != '%') patPtr++;
		*patPtr = 0;
		if (! subCategory)
			subCategory = "";		
		sprintf (fileName, "%s%s%03i%s%s", pattern, category, number, subCategory, patPtr+1);
		*patPtr = '%';
		if (Open (fileName, ios::open_mode(ios::in|ios::out|ios::nocreate))) return 1;
	}
	else if (Open (pattern, ios::open_mode(ios::in|ios::out|ios::nocreate))) return 1;

	OutputHeader (this, bb->GetAt(0)->min, bb->GetAt(1)->min,
       	                    bb->GetAt(0)->max, bb->GetAt(1)->max);

	// WARNING: Associated code fragment is placed in Collage::PSOut 
	Out ("\nBeginCollage");
	if (bb) {
		Out ("\n");
		Out (bb->GetAt(0)->min); // llx = min. of 1st dimension
		Out (bb->GetAt(1)->min); // lly = min. of 2nd dimension
		Out (bb->GetAt(0)->max); // urx = max. of 1st dimension
		Out (bb->GetAt(1)->max); // ury = max. of 2nd dimension
		Out ("_BBox\n");
		Out ("                   \n");

	}
	// END WARNING


	return Close ();	
}


void PSOut::Out (char* String) 
{
	char* p = String;
	Boolean End = False;
	while (End == False) {
		End = True;
		char nextlength = strlen(p) + length;
		if (length != 0) nextlength++;    // Platz fr Leerzeichen
		if (nextlength >= maxoutline - 1) {
			file << psoutline << "\n";
			endoutline = psoutline;
			*endoutline = 0;
			length = 0;
		}
		else
			if (beginoutput == True)
				beginoutput = False;
			else { // Keine neue Zeile begonnen
				*endoutline = ' ';
				endoutline++;
				length++;
			}
		while (*p && *p != '\n') {
			*endoutline = *p;
			endoutline++;
			p++;
			length++;
		}
		if (*p == '\n') {
			*endoutline = 0;
			p++;
			file << psoutline << "\n";
			endoutline = psoutline;
			length = 0;
			beginoutput = True;
			End = False;
		}
		*endoutline = 0;
	}
}

void PSOut::Out (char C) 
{
	char tmp[2];
	tmp[0] = C;
	tmp[1] = 0;
	Out (tmp);
}

void PSOut::Out (float F) 
{
	char string[20];
	char* tmp = string;
	sprintf(string,"%-f", F);
	while (*tmp != 0)  // Bis zum Ende gehen
		tmp++;
	tmp--;
	while (*tmp == '0') { // Nachfolgende Nullen ueberspringen
		*tmp = 0;
		tmp--;
	}
	if (*tmp == '.')  // Dezimalpunkt ueberspringen
		*tmp = 0;
	Out(string);
}

void PSOut::Out (double F) 
{
	char string[20];
	char* tmp = string;
	sprintf(string,"%-1.5f", F);
	while (*tmp != 0)  // Bis zum Ende gehen
		tmp++;
	tmp--;
	while (*tmp == '0') { // Nachfolgende Nullen ueberspringen
		*tmp = 0;
		tmp--;
	}
	if (*tmp == '.')  // Dezimalpunkt ueberspringen
		*tmp = 0;
	Out (string);
}

void PSOut::Out (int I) 
{
	char string[20];
	sprintf(string,"%d", I);
	Out (string);
}

void PSOut::Out (long I) 
{
	char string[20];
	sprintf(string,"%ld", I);
	Out (string);
}

void PSOut::Out (const Textblock *tb)
{
	if (! tb) return;
	char **cur = tb->GetAt(0);
	while (cur) {
		Out (*cur);
		Out ("\n");
		cur = tb->GetNext();
	}
}

