#ifndef __PSOUT_H__
#define __PSOUT_H__
//
// psout.h  --  CollageTwo
//
// Postscript output functions
//
// Authors            : Nils Schwabe, Stefan Taubenberger
// Date of creation   : 21 Apr 94
// Last modification  : 10 Mai 96
//
// University of Bremen, Germany
//

#include <fstream.h>
#include "basic.h"
#include "boundbox.h"

// ------- PSOut --------------------------------------------------------------

const int maxoutline = 76;

class PSOut
{
public:
	PSOut ();
	~PSOut ();

	void SetBBoxCalculator (BoundingBoxCalculator *bbcalc)  {bbc = bbcalc;}
	
		// Set the bounding box calculator. Refer to boundbox.h for details.

	void SetPattern (const char *filenamePattern);
	
		// Set the file name pattern for the generated PostScript files.

	short NewFile (const char *category, const BoundingBox *bbox = 0,
	               const char *subCategory = 0);
	               
		// Create a new output file of 'category' with optional bounding
		// box and sub-category.
		// Note: The bounding box must be 2D.

	short PatchBBox (const char *category, int number,
	                 const BoundingBox *bbox, const char *subCategory = 0);
	                 
		// Patch the bounding box information in the specified output file.

	void Reset();
	
		// Reset this PostScript output object.


	// Output functions:
	
	void Out (char);
	void Out (char*);
	void Out (float);
	void Out (double);
	void Out (int);
	void Out (long);
	void Out (const Textblock *); // pointer may be NULL

private:
	void Init();
	short Open (const char *fileName, ios::open_mode mode=ios::out);
	short Close ();
	char pattern[200];
	char lastCategory[100];
	fstream file;
	char psoutline[maxoutline];
	Boolean beginoutput; 
	int fileCounter;
	Boolean variable;
	Boolean firstFile;
	char* endoutline;
	char length;
	BoundingBoxCalculator *bbc;

};

extern PSOut thePS;  
	// currently the only instance of class PSOut. Must be defined
	// by the main module.

#endif /* !defined(__PSOUT_H__) */

