//
// slists.cc  --  CollageSystem
//
// Template class for single linked, non-intrusive lists 
//
// Author:  N. Schwabe
//
// implemented mainly according to:
// Bjarne Stroustrup, The C++ programming language, 
// 2nd edition, Addison-Wesley 1991
// 
// Date: 2/94
// University of Bremen, Germany
//

#include <stdio.h>
#include <iostream.h>
#include "slists.h"


void Error (char *text)
{
  cout <<"ERROR: " << text << "\n";
}


void SListBase::Insert (SLink *a)
{
  if (last)
    a->next = last->next;
  else
    last = a;
  last->next = a;
  hot = a;
  hotnr = 0;
  length++;
}


void SListBase::Append (SLink *a)
{
  if (last) {
    a->next = last->next;
    last->next = a;
  }
  else
    a->next = a;
  last = a;
  hot = a;
  hotnr = length;
  length++;
}


void SListBase::InsertAt (uint index, SLink *ins)
{
  if (last) {
    SLink *cur = last->next, *prev = 0;
    int i=0;
    while (cur != last && i < index) {
      prev = cur;
      cur = cur->next;
      i++;
    }
    if (cur == last && index == i+1) {
      SListBase::Append (ins);
      return;
    }
    else if (i != index) {
      char msg[100];
      sprintf (msg, "SListBase::InsertAt: index %i is out of range (max=%i).", index, i+1);
      Error (msg);  
      return;
    }
    if (prev) {
      ins->next = cur; 
      prev->next = ins;
      hot = ins;
      hotnr = index;
      length++;
    }
    else
      SListBase::Insert (ins); 
  }
  else
  {
    if (index != 0) {
      Error ("SListBase::InsertAt: index must be 0 for first element.");
      return;
    }
    SListBase::Insert (ins);
  }
}


SLink* SListBase::GetAt (uint index)
{
  SLink *cur=last;
  int i;

  if (! cur) return hot = 0;

  // optimize traversal:
  if (index == hotnr) 
    return hot;
  else if (index > hotnr) {
    cur = hot;
    i = hotnr;
  }
  else {
    cur = cur->next; // first element
    i = 0;
  }

  while (cur != last && i < index) {
    cur = cur->next;
    i++;
  }
    
  if (i == index) {
    hotnr = index;
    return hot = cur;
  }
  else {
    hotnr = -1;
    return hot = 0;
  }
}


SLink* SListBase::GetNext ()
{
  if ((! hot) || (! last)) return 0;
  if (hot->next != last->next) {
    hotnr++;
    return hot = hot->next;
  }
  else {
    hotnr = -1;
    return hot = 0;
  }
}


void SListBase::DeleteAt (unsigned int index)
{
  SLink *cur=last, *prev=0;
  int i=0;

  if (! cur) {
    Error ("SListBase::DeleteAt: list is empty.");
    return;
  }
  cur = cur->next; // first element

  while (cur != last && i < index) {
    prev = cur;
    cur = cur->next;
    i++;
  }

  if (i != index) {
      char msg[100];
      sprintf (msg, "SListBase::DeleteAt: index %i is out of range (max=%i).", index, i);
      Error (msg);  
      return;
  }

  if (prev)
    prev->next = cur->next;
  else
    last->next = cur->next;

  length--;

  if (cur == hot) {
    if (hot == last) {
      hotnr = -1;
      hot = 0;
    }
    else {
      // don't change hotnr
      hot = hot->next;
    }
  }
  else if (hotnr > index)  // note: case hotnr==index equivalent to cur==hot
    hotnr--;

  if (cur == last) last = prev;
}


Boolean SListBase::Delete ()
{
  if ((! hot) || (! last)) return False;
  
  SLink *cur=last->next, *prev=0;
  
  while (cur != hot) {
    prev = cur;
    cur = cur->next;
  }

  if (prev)
    prev->next = cur->next;
  else
    last->next = cur->next;

  length--;

  if (hot == last) {
    hotnr = -1;
    hot = 0;
  }
  else {
    // don't change hotnr
    hot = hot->next;
  }

  if (cur == last) last = prev;
  return True;
}



#if 0   /*  SOME TEST CODE:  */

class Double
{
public:
	Double (double v, char *s) {
		
		cout << "Double constructor for " << s << "\n";
		value=v; strcpy (dummy, s);
	}
	Double (const Double &source) {
		cout << "copy " << source.dummy << "\n";
		value=source.value;
		strcpy (dummy, source.dummy);
		strcat (dummy, "_(copied)");
	}
	void operator=(const Double &source) {
		cout << "assign " << dummy << " = " << source.dummy << "\n";
		value=source.value;
		strcpy (dummy, source.dummy);
		strcat (dummy, "_(assigned)");
	}

	double value;
	char dummy[100];
};

int main ()
{
  SList<Double> dl;
  SList<int> il;
  SList<float> fl;
  Double x (3.0, "drei");

  cout << "x = " << x.dummy << "\n";

  dl.InsertAt (0, Double(3.1234, "first"));
  dl.InsertAt (1, Double(2.4323, "second"));
  dl.InsertAt (2, Double(7.342, "third"));
  dl.DeleteAt (0);
 
  il.Insert (32);
  cout << "Int: " << *il.Get() << "\n";

  fl.Insert ((float)1.234);
  cout << "Float: " << *fl.Get() << "\n";

  Double *d;
  for (int i=0; (d=dl.GetAt(i)) && i < 10; i++) 
    cout << "Element #" << i << " = " << d->value <<  ", " << d->dummy  << "\n";

}

#endif  /* TEST CODE */
