#ifndef __SSTRING_H__
#define __SSTRING_H__
//
// sstring.h
//
// Simple string class template
//
// Author            : Nils Schwabe
// Date of creation  : Jul 94
// Last modification : Jul 94
//

#include <iostream.h>

template<class T> // T = desired type of string elements (char, int, ...)
                  // allowed types: (unsigned) char, short, int, long, float, double

class SString
{
public:
	SString () {s=0;};
	SString (const T* init) {s=0; Set(init);}
	SString (const SString<T> &copy) {s=0; Set (copy.s);}
	~SString() {if (s) delete [] s;}
		
	SString<T> &operator= (const SString<T> &ass) {Set (ass.s); return *this;}
	SString<T> &operator= (const T* ass) {Set (ass); return *this;}
	
		// Assigns another string to this string.
	
	const T* Get () const {return s;}
	operator T* () const {return s;}
	
		// Returns a pointer to the string.

	inline unsigned int Len()  {return Len(s);}
	
		// Returns the length of the string.
		
	static unsigned int Len (const T* s);
	
	inline int operator== (const SString<T>& s2) const; 
	
		// Compares this string to another string.

private:
	inline void Set (const T* set);
	T* s;
};

template<class T> inline ostream& operator<<(ostream& s, const SString<T>& v)
{
	if (v.Get())
		return s << v.Get();
	else
		return s << "(NULL-String)";
}

// Template implementation
// =======================

template<class T> inline unsigned int SString<T>::Len (const T *s) 
{
	if (! s) return 0;
	unsigned int l = 0;
	while (s[l]) l++;
	return l;
}

template<class T> inline int SString<T>::operator== 
	(const SString<T>& s2) const
{
	T *a=s, *b=s2.s;

	while (*a && *b) {
		if (*a != *b) return 0;
		a++; b++;
	}
	if (*a || *b) return 0;
	return 1;
}


template<class T> inline void SString<T>::Set (const T* set)
{
	if (s) {delete [] s;}
	unsigned int len = Len (set);
	s = new T [len+1];
	if (len) memcpy (s, set, sizeof(T)*len);
	s[len] = 0;
}

#endif /* !defined (__SSTRING_H__) */

