//
// vrout.cc  --  CollageVR
//
// VRML output functions
//
// Authors            : Nils Schwabe
// Date of creation   : 04 Dec 96
// Last modification  : 04 Dec 96
//
// University of Bremen, Germany
//

#include <stdio.h>
#include <string.h>
#include "vrout.h"



VROut::VROut ()
{
	Init();
}

VROut::~VROut()
{
}

void VROut::Init()
{
	strcpy (pattern, "");
	strcpy (lastCategory, "");
	fileCounter = 0;
	variable = False;
	firstFile = True;

	uint fnlen = fileNames.Length();
	for (int i=0; i < fnlen; i++)
	{
		char** p = fileNames.GetAt (0);
		delete *p;
		fileNames.Delete();
	}
	
}

void VROut::SetPattern (const char *filenamePattern)
{
	strcpy (pattern, filenamePattern);
}

short VROut::Open (const char* fileName, ios::open_mode mode)
{
	file.open (fileName, mode);
	if (!file) {
		cerr << "VROut::Open: Kann Datei " << fileName << "nicht oeffnen.\n";
		return 1;
	}
	else
		return 0;
}

short VROut::Close () 
{
	if (file)
	{
		file << "\n}\n" << flush;
		file.close();
	}
	return 0;
}

void VROut::Reset()
{
	if (! firstFile) Close();
	Init();
}


short VROut::NewFile (const char *category,
                      const char *subCategory)
{
	char* patPtr = pattern;

	if (firstFile == True) {  // Erster Aufruf von NewFile
		while (*patPtr) {
			if (*patPtr == '%') {
				variable = True;
				break;
			}
			patPtr++;
		}
	}
	if (variable == True) {
		char fileName[250];
		if (firstFile == False) {
			Close ();
			if (! subCategory)
			{
				if (strcmp(category, lastCategory)==0) 
					fileCounter++;
				else
					fileCounter = 1;
			}
			// else: Leave fileCounter as it is
		}
		else {
			firstFile = False;
			fileCounter = 1;
		}
		strcpy (lastCategory, category);
		patPtr = pattern;
		while (*patPtr != '%') patPtr++;
		*patPtr = 0;
		if (! subCategory)
			subCategory = "";
		sprintf (fileName, "%s%s%03i%s%s", pattern, category,  fileCounter, subCategory, patPtr+1);
		*patPtr = '%';
		Open (fileName);
		char* p = new char[strlen(fileName)+1];
		strcpy (p, fileName);
		fileNames.Append (p);
	}
	else
		if (firstFile == True) {
			firstFile = False;
			Open (pattern);
			char* p = new char[strlen(pattern)+1];
			strcpy (p, pattern);
			fileNames.Append (p);
		}

	Out ("#VRML V1.0 ascii\n\nSeparator {\n\n");

	return 0;
}


void VROut::GetNameOfNthFile (uint n, char *name)
{
	if (n <= fileNames.Length())
	{
		char** p = fileNames.GetAt (n-1);
		strcpy (name, *p);
	}
	else
		name[0] = 0;
}


void VROut::Out (char* s) 
{
	file << s;
}

void VROut::Out (char c) 
{
	file << c << " ";
}

void VROut::Out (float f) 
{
	file << f << " ";
}

void VROut::Out (double d) 
{
	file << d << " ";
}

void VROut::Out (int i) 
{
	file << i << " ";
}

void VROut::Out (long l) 
{
	file << l << " ";
}

void VROut::Out (const Textblock *tb)
{
	if (! tb) return;
	char **cur = tb->GetAt(0);
	while (cur) {
		Out (*cur);
		Out ("\n");
		cur = tb->GetNext();
	}
}

