#ifndef __VROUT_H__
#define __VROUT_H__
//
// vrout.h  --  CollageVR
//
// VRML output functions
//
// Authors            : Nils Schwabe
// Date of creation   : 04 Dec 96
// Last modification  : 04 Dec 96
//
// University of Bremen, Germany
//

#include <fstream.h>
#include "basic.h"


// ------- VROut --------------------------------------------------------------

class VROut
{
public:
	VROut ();
	~VROut ();

	void SetPattern (const char *filenamePattern);
	
		// Set the file name pattern for the generated VRML files.

	short NewFile (const char *category, const char *subCategory = 0);
	               
		// Create a new output file of 'category' with optionaL sub-category.

	void Reset();
	
		// Reset this VRML output object.


	// Output functions:
	
	void Out (char);
	void Out (char*);
	void Out (float);
	void Out (double);
	void Out (int);
	void Out (long);
	void Out (const Textblock *); // pointer may be NULL

	short Close ();
	
	
	// Access to generated file names:
	
	void GetNameOfNthFile (uint n, char *name);
	
		// Copy the name of the <n>-th (1..k) generated output
		// file into 'name'. 'name' must be allocated to hold an
		// array of sufficient size.
	
	
private:
	void Init();
	short Open (const char *fileName, ios::open_mode mode=ios::out);
	char pattern[200];
	char lastCategory[100];
	fstream file;
	int fileCounter;
	Boolean variable;
	Boolean firstFile;
	Textblock fileNames;
};

extern VROut theVR;  
	// currently the only instance of class VROut. Must be defined
	// by the main module.

#endif /* !defined(__VROUT_H__) */

