  
// ----- XVCPP-Makros ----------------------------------------------------------
//                                                                    N.S. 1/94




// ACHTUNG: LETZTER BENUTZTER KEY IST 5031959
// BITTE BEI NEUEN MACRO-DEFINITIONEN DIE OBIGE ZAHL ENTSPRECHENDEND AENDERN.




/* Die XVCPP-Makros ermoeglichen die Verwendung von C++ Klassenmethoden 
   als XView-Callbacks. (Derzeit werden Panel-Items, Canvases sowie Callbacks
   vom Typ WIN_EVENT_PROC unterstuetzt. Eine Erweiterung fuer andere Callback-
   Typen ist aber trivial.)
   Die Benutzung ist sehr einfach:

   - MAKE_PANEL_STUFF (Klassenname) bzw. MAKE_CANVAS_STUFF und 
     MAKE_WIN_EVENT_STUFF 'implementieren' die noetigen klassenspezifischen 
     Funktionen.

   - SET_PANEL_NOTIFY_PROC (Klassenname, Objekt-Zeiger, Funktionsname) bzw. 
     SET_CANVAS_REPAINT_PROC und SET_WIN_EVENT_PROC koennen in der Attribut-
     liste bei xv_create oder xv_set angegeben werden und uebernehmen dort die
     Anmeldung der Callback-Funktion fuer das Objekt. 
   
   Die Klassenmethoden muessen entsprechend den XView-Vorgaben fuer die
   jeweilige Callback-Art deklariert werden. Fuer die beiden derzeit
   unterstuetzten Callback-Arten sind dies (s.a. XView Programming Manual 
   S. 173 bzw. S. 94):
   - Fuer Panel-Items:  
     void MyNotify (Panel_item item, int value, Event *event);
   - Fuer Canvases:
     void MyRepaint (Canvas canvas, Xv_Window paint_window, Display *dpy,
                     Window xwin, Xv_xrectlist *area);
   - Fuer WIN_EVENT-Callback:
     void MyEvent (Xv_Window window, Event *event, Notify_arg arg); 

   Erweitert um folgende Callbacks:
    - Buttons
    - Menu 
    - Panel_list
    - Panel_text und Panel_numeric_text
    - Frame_done_proc
    - Notify_set_itimer_func
    - Notify_interpose_destroy_func

*/   


// ----- XVCPP Panel macros:

#define XVCPP_PANEL_ITEM_KEY 5031969
#define MAKE_PANEL_STUFF(theClass)\
\
typedef void (theClass::* theClass##PanelCallback) \
  (Panel_item item, int value, Event *event); \
struct theClass##PanelInfo \
{ \
  theClass##PanelInfo (theClass *o, theClass##PanelCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##PanelCallback fkt; \
}; \
void theClass##PanelProc (Panel_item item, int value, Event *event) \
{ \
  theClass##PanelInfo *info; \
\
  info = (theClass##PanelInfo *)xv_get (item, XV_KEY_DATA, XVCPP_PANEL_ITEM_KEY); \
  (info->object->*info->fkt) (item, value, event); \
}

#define SET_PANEL_NOTIFY_PROC(theClass,ptrObject,fktname) \
\
PANEL_NOTIFY_PROC, theClass##PanelProc, \
XV_KEY_DATA, XVCPP_PANEL_ITEM_KEY, \
  new theClass##PanelInfo (ptrObject, &theClass::fktname)



// ----- XVCPP Canvas macros:

#define XVCPP_CANVAS_ITEM_KEY 5031968
#define MAKE_CANVAS_STUFF(theClass)\
\
typedef void (theClass::* theClass##CanvasCallback) \
  (Canvas canvas, Xv_Window paint_window, Display *dpy, \
                     Window xwin, Xv_xrectlist *area); \
struct theClass##CanvasInfo \
{ \
  theClass##CanvasInfo (theClass *o, theClass##CanvasCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##CanvasCallback fkt; \
}; \
void theClass##CanvasProc (Canvas canvas, Xv_Window paint_window, Display *dpy, \
                     Window xwin, Xv_xrectlist *area) \
{ \
  theClass##CanvasInfo *info; \
\
  info = (theClass##CanvasInfo *)xv_get (canvas, XV_KEY_DATA, XVCPP_CANVAS_ITEM_KEY); \
  (info->object->*info->fkt) (canvas, paint_window, dpy, xwin, area); \
}

#define SET_CANVAS_REPAINT_PROC(theClass,ptrObject,fktname) \
\
CANVAS_REPAINT_PROC, theClass##CanvasProc, \
CANVAS_X_PAINT_WINDOW, TRUE, \
XV_KEY_DATA, XVCPP_CANVAS_ITEM_KEY, \
  new theClass##CanvasInfo (ptrObject, &theClass::fktname)


// ----- XVCPP window event macros:

#define XVCPP_WIN_EVENT_ITEM_KEY 5031967
#define MAKE_WIN_EVENT_STUFF(theClass)\
\
typedef void (theClass::* theClass##WinEventCallback) \
  (Xv_Window window, Event *event, Notify_arg arg); \
struct theClass##WinEventInfo \
{ \
  theClass##WinEventInfo (theClass *o, theClass##WinEventCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##WinEventCallback fkt; \
}; \
void theClass##WinEventProc (Xv_Window window, Event *event, Notify_arg arg) \
{ \
  theClass##WinEventInfo *info; \
\
  info = (theClass##WinEventInfo *)xv_get (window, XV_KEY_DATA, XVCPP_WIN_EVENT_ITEM_KEY); \
  (info->object->*info->fkt) (window, event, arg); \
}

#define SET_WIN_EVENT_PROC(theClass,ptrObject,fktname) \
\
WIN_EVENT_PROC, theClass##WinEventProc, \
XV_KEY_DATA, XVCPP_WIN_EVENT_ITEM_KEY, \
  new theClass##WinEventInfo (ptrObject, &theClass::fktname)



// ----- XVCPP Menu macros:

#define XVCPP_MENU_ITEM_KEY 5031966
#define MAKE_MENU_STUFF(theClass)\
\
typedef void (theClass::* theClass##MenuCallback) \
  (Menu menu, Menu_item menu_item); \
struct theClass##MenuInfo \
{ \
  theClass##MenuInfo (theClass *o, theClass##MenuCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##MenuCallback fkt; \
}; \
void theClass##MenuProc (Menu menu, Menu_item menu_item) \
{ \
  theClass##MenuInfo *info; \
\
  info = (theClass##MenuInfo *)xv_get (menu, XV_KEY_DATA, XVCPP_MENU_ITEM_KEY); \
  (info->object->*info->fkt) (menu, menu_item); \
}

#define SET_MENU_NOTIFY_PROC(theClass,ptrObject,fktname) \
\
MENU_NOTIFY_PROC, theClass##MenuProc, \
XV_KEY_DATA, XVCPP_MENU_ITEM_KEY, \
  new theClass##MenuInfo (ptrObject, &theClass::fktname)



// ----- XVCPP Panel_list macros von Joern: ----------------------------------

#define XVCPP_PANEL_LIST_KEY 5031965
#define MAKE_PANEL_LIST_STUFF(theClass)\
\
typedef void (theClass::* theClass##PanelListCallback) \
  (Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op,\
   Event *event, int row); \
struct theClass##PanelListInfo \
{ \
  theClass##PanelListInfo (theClass *o, theClass##PanelListCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##PanelListCallback fkt; \
}; \
void theClass##PanelListProc (Panel_item item, char *string,\
    Xv_opaque client_data, Panel_list_op op, Event *event, int row) \
{ \
  theClass##PanelListInfo *info; \
\
  info = (theClass##PanelListInfo *)xv_get (item, XV_KEY_DATA,\
		XVCPP_PANEL_LIST_KEY); \
  (info->object->*info->fkt) (item, string, client_data, op, event, row); \
}

#define SET_PANEL_LIST_NOTIFY_PROC(theClass,ptrObject,fktname) \
\
PANEL_NOTIFY_PROC, theClass##PanelListProc, \
XV_KEY_DATA, XVCPP_PANEL_LIST_KEY, \
  new theClass##PanelListInfo (ptrObject, &theClass::fktname)



// ----- XVCPP Panel_Text und Panel_Numeric_Text macros von Joern: ----------

#define XVCPP_PANEL_TEXT_KEY 5031964
#define MAKE_PANEL_TEXT_STUFF(theClass)\
\
typedef Panel_setting (theClass::* theClass##PanelTextCallback) \
  (Panel_item item, Event *event); \
struct theClass##PanelTextInfo \
{ \
  theClass##PanelTextInfo (theClass *o, theClass##PanelTextCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##PanelTextCallback fkt; \
}; \
Panel_setting theClass##PanelTextProc (Panel_item item, Event *event) \
{ \
  theClass##PanelTextInfo *info; \
\
  info = (theClass##PanelTextInfo *)xv_get (item, XV_KEY_DATA,\
		XVCPP_PANEL_TEXT_KEY); \
  return ((info->object->*info->fkt)(item, event)); \
}

#define SET_PANEL_TEXT_NOTIFY_PROC(theClass,ptrObject,fktname) \
\
PANEL_NOTIFY_PROC, theClass##PanelTextProc, \
XV_KEY_DATA, XVCPP_PANEL_TEXT_KEY, \
  new theClass##PanelTextInfo (ptrObject, &theClass::fktname)


// ----- XVCPP Frame_Done_Proc macros fuer FRAME_CMD von Joern: ----------

#define XVCPP_FRAME_DONE_KEY 5031963
#define MAKE_FRAME_DONE_STUFF(theClass)\
\
typedef void (theClass::* theClass##FrameDoneCallback) \
  (Frame frame); \
struct theClass##FrameDoneInfo \
{ \
  theClass##FrameDoneInfo (theClass *o, theClass##FrameDoneCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##FrameDoneCallback fkt; \
}; \
void theClass##FrameDoneProc (Frame frame) \
{ \
  theClass##FrameDoneInfo *info; \
\
  info = (theClass##FrameDoneInfo *)xv_get (frame, XV_KEY_DATA,\
		XVCPP_FRAME_DONE_KEY); \
  (info->object->*info->fkt)(frame); \
} 

#define SET_FRAME_DONE_PROC(theClass,ptrObject,fktname) \
\
FRAME_DONE_PROC, theClass##FrameDoneProc, \
XV_KEY_DATA, XVCPP_FRAME_DONE_KEY, \
  new theClass##FrameDoneInfo (ptrObject, &theClass::fktname)




// ----- XVCPP Button Callbacks von Joern: ----------

#define XVCPP_BUTTON_KEY 5031962
#define MAKE_BUTTON_STUFF(theClass)\
\
typedef void (theClass::* theClass##ButtonCallback) \
  (Panel_item item, Event *event); \
struct theClass##ButtonInfo \
{ \
  theClass##ButtonInfo (theClass *o, theClass##ButtonCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##ButtonCallback fkt; \
}; \
void theClass##ButtonProc (Panel_item item, Event *event) \
{ \
  theClass##ButtonInfo *info; \
\
  info = (theClass##ButtonInfo *)xv_get (item, XV_KEY_DATA,\
		XVCPP_BUTTON_KEY); \
  (info->object->*info->fkt)(item, event); \
} 

#define SET_BUTTON_PROC(theClass,ptrObject,fktname) \
\
PANEL_NOTIFY_PROC, theClass##ButtonProc, \
XV_KEY_DATA, XVCPP_BUTTON_KEY, \
  new theClass##ButtonInfo (ptrObject, &theClass::fktname)


// ----- XVCPP notify_itimer macros von Joern: -----------------------------

// Der Unterschied zu den fuer Panels implementierten Macros liegt nur
// im Setzen und Stoppen des Timers, d.h. vor Verwendung des Notifier-
// Timers muss MAKE_NOTIFY_TIMER_STUFF(theClass) eingebunden werden.
// Fuer jeden verwendeten Timer erhaehlt man durch client = 
// CPP_NOTIFY_NEW_ITIMER_HANDLE(...) einen Handle fuer den Timer.
// Das Setzen erfolgt dann mittels CPP_NOTIFY_SET_ITIMER_FUNC(...) (Argumente
// siehe Quelltext unten) anstelle der ueblichen notify_set_itmer_func(...).  

#define MAKE_NOTIFY_TIMER_STUFF(theClass)\
\
typedef Notify_value (theClass::* theClass##NotifyTimerFunc) \
  (Notify_client client, int which); \
struct theClass##NotifyTimerInfo \
{ \
  theClass##NotifyTimerInfo (theClass *o, theClass##NotifyTimerFunc f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##NotifyTimerFunc fkt; \
}; \
Notify_value theClass##NotifyTimerProc (Notify_client client, int which) \
{ \
  theClass##NotifyTimerInfo *info; \
\
  info = (theClass##NotifyTimerInfo *) client; \
  return ((info->object->*info->fkt) (client, which)); \
}

#define CPP_NOTIFY_NEW_ITIMER_HANDLE(theClass, ptrObject, fktname) \
\
(Notify_client) new theClass##NotifyTimerInfo (ptrObject, &theClass::fktname)

#define CPP_NOTIFY_SET_ITIMER_FUNC(theClass, client, which, value, ovalue) \
\
notify_set_itimer_func(\
client, (Notify_func)theClass##NotifyTimerProc, which, value, ovalue);



// -------- XVCPP notify_interpose_destroy_func macros von Joern: ---------
// nur eine interposer func kann angemeldet werden.


#define XVCPP_INTERPOSE_DESTROY_KEY 5031961
#define MAKE_INTERPOSE_DESTROY_STUFF(theClass) \
\
typedef Notify_value (theClass::* theClass##InterposeDestroyFunc) \
   (Notify_client client, Destroy_status status); \
struct theClass##InterposeDestroyInfo \
{ \
  theClass##InterposeDestroyInfo (theClass *o,\
                            theClass##InterposeDestroyFunc f) \
  { \
     object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##InterposeDestroyFunc fkt; \
}; \
Notify_value theClass##InterposeDestroyProc (Notify_client client,  \
				Destroy_status status) \
{ \
  theClass##InterposeDestroyInfo *info; \
\
  info = (theClass##InterposeDestroyInfo *)xv_get (client, XV_KEY_DATA,\
		XVCPP_INTERPOSE_DESTROY_KEY); \
  return ((info->object->*info->fkt) (client, status)); \
}

#define CPP_NOTIFY_INTERPOSE_DESTROY_FUNC(client, theClass, ptrObject, fktname) \
xv_set(client, XV_KEY_DATA, XVCPP_INTERPOSE_DESTROY_KEY, \
   new theClass##InterposeDestroyInfo (ptrObject, &theClass::fktname), NULL); \
notify_interpose_destroy_func( \
    client, (Notify_func)theClass##InterposeDestroyProc);

#define CPP_NOTIFY_REMOVE_DESTROY_FUNC(client, theClass)\
\
notify_remove_destroy_func(client, (Notify_func)theClass##InterposeDestroyProc);



// -------- XVCPP notify_set_event_func macros von Joern: ---------


#define XVCPP_SET_EVENT_KEY 5031960
#define MAKE_SET_EVENT_STUFF(theClass) \
\
typedef Notify_value (theClass::* theClass##EventFunc) \
   (Notify_client client, Notify_event event, Notify_arg arg, \
	Notify_event_type when); \
struct theClass##EventInfo \
{ \
  theClass##EventInfo (theClass *o,\
                            theClass##EventFunc f) \
  { \
     object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##EventFunc fkt; \
}; \
Notify_value theClass##EventProc (Notify_client client,  \
	Notify_event event, Notify_arg arg, Notify_event_type when) \
{ \
  theClass##EventInfo *info; \
\
  info = (theClass##EventInfo *) client; \
  return ((info->object->*info->fkt) (client, event, arg, when)); \
}

#define CPP_NOTIFY_NEW_EVENT_HANDLE(theClass, ptrObject, fktname) \
\
(Notify_client) new theClass##EventInfo (ptrObject, &theClass::fktname)

#define CPP_NOTIFY_SET_EVENT_FUNC(client, theClass, ptrObject, fktname, when) \
\
notify_set_event_func( \
    client, (Notify_func)theClass##EventProc, when);

#define CPP_NOTIFY_REMOVE_EVENT_FUNC(client, theClass, when)\
\
notify_remove_destroy_func(client, (Notify_func)theClass##EventProc, when);



// ----- Text subwindow notification (NS) ----------

#define MAKE_TEXTSW_STUFF(theClass)\
\
typedef void (theClass::* theClass##TextswCallback) \
  (Textsw textsw, Attr_avlist attributes); \
struct theClass##TextswInfo \
{ \
  theClass##TextswInfo (theClass *o, theClass##TextswCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##TextswCallback fkt; \
}; \
void theClass##TextswProc (Textsw textsw, Attr_avlist attributes) \
{ \
  theClass##TextswInfo *info; \
\
  info = (theClass##TextswInfo *)xv_get (textsw, TEXTSW_CLIENT_DATA);\
  (info->object->*info->fkt)(textsw, attributes); \
} 

#define SET_TEXTSW_PROC(theClass,ptrObject,fktname) \
\
TEXTSW_NOTIFY_PROC, theClass##TextswProc, \
TEXTSW_CLIENT_DATA, \
  new theClass##TextswInfo (ptrObject, &theClass::fktname)



// ----- File chooser notification (NS) ----------

#define XVCPP_FILE_CHOOSER_KEY 5031959
#define MAKE_FILE_CHOOSER_STUFF(theClass)\
\
typedef void (theClass::* theClass##FselCallback) \
  (File_chooser fsel, char *pathname, char *name); \
struct theClass##FselInfo \
{ \
  theClass##FselInfo (theClass *o, theClass##FselCallback f) \
  { \
    object = o; fkt = f; \
  } \
  theClass *object; \
  theClass##FselCallback fkt; \
}; \
void theClass##FselProc (File_chooser fsel, char *pathname, char *name) \
{ \
  theClass##FselInfo *info; \
\
  info = (theClass##FselInfo *)xv_get (fsel, XV_KEY_DATA,\
		XVCPP_FILE_CHOOSER_KEY); \
  (info->object->*info->fkt)(fsel, pathname, name); \
} 

#define SET_FILE_CHOOSER_NOTIFY_FUNC(theClass,ptrObject,fktname) \
\
FILE_CHOOSER_NOTIFY_FUNC, theClass##FselProc, \
XV_KEY_DATA, XVCPP_FILE_CHOOSER_KEY, \
  new theClass##FselInfo (ptrObject, &theClass::fktname)
