
#include <stream.h>
#include <string.h>
#include "xvtextsw.h"
#include <xvcpp.h>


// Input string function:

static int SubframeDoneProc (Frame subframe)
{
  xv_window_return (0);
  return 0;
}

static Panel_setting PanelEditNotify (Panel_item item, Event *event)
{
  xv_window_return (1);
  return PANEL_NONE;
}

int InputString
	(Frame owner, 
	 const char *header,
	 const char *label,
	 char *string)
{
  Frame subframe = xv_create (owner, FRAME_CMD, 
	// Referenz f. Hilfe. Gregor
	XV_HELP_DATA,"StudioHelp:SubFrameInpStr",
	XV_X, xv_get (owner, XV_X)+40,
	XV_Y, xv_get (owner, XV_Y)+60,
	XV_HEIGHT, 50,
	XV_WIDTH, 300,
	FRAME_LABEL, header,
	FRAME_DONE_PROC, SubframeDoneProc,
	NULL);

  Panel panel = xv_get (subframe, FRAME_CMD_PANEL);

  Panel_item edit = xv_create (panel, PANEL_TEXT, 
	// Referenz f. Hilfe. Gregor
	XV_HELP_DATA,"StudioHelp:EditItemInpStr",
	PANEL_LABEL_STRING, label,
	PANEL_VALUE, string,
        PANEL_NOTIFY_PROC, PanelEditNotify,
	PANEL_VALUE_DISPLAY_LENGTH, 20,
	PANEL_VALUE_STORED_LENGTH, 200,
	NULL);

  window_fit (panel);
  window_fit (subframe);
  
  xv_set (subframe, XV_SHOW, TRUE, NULL);

  int res = xv_window_loop (subframe);
  if (res)
    strcpy (string, (char *)xv_get (edit, PANEL_VALUE));
    
  xv_destroy_safe (subframe);	               
  return res;
}


// ----- Text editor in a window class: -----

MAKE_TEXTSW_STUFF(Textedit)

int DefaultTexteditCallback (Textedit *t, Textsw ts, Attr_avlist attributes,
                        void *client_data)
{
  int pass_on = TRUE; // pass the event to the text subwindow's default proc
  Attr_avlist attrs;
 
  for (attrs = attributes; *attrs; attrs = attr_next(attrs))
  {
    switch ((Textsw_action)(*attrs))
    {
      case TEXTSW_ACTION_LOADED_FILE:
        //cout << "Textedit loaded file " << (char *)attrs[1] << "\n";
        pass_on = TRUE;
        break;
      default:
        pass_on = TRUE;
        break;
    }    
  }
  return pass_on;
}



void Textedit::Init (Frame parent)
{
  if (! parent) {
    frame = (Frame)xv_create(0, FRAME, 
               	XV_WIDTH, 600,
              	XV_HEIGHT, 400,
                XV_SHOW, TRUE,
              	NULL);
    parent = frame;
  }
  else
    frame = XV_NULL;

  textsw = (Textsw)xv_create (parent, TEXTSW,
                NULL);
  xv_set (textsw, SET_TEXTSW_PROC(Textedit,this,Notify), NULL);
  notify = NULL;
  // optional:
  SetNotifyProc (DefaultTexteditCallback, NULL);
}

Textedit::Textedit()
{
  Init(0);
}

Textedit::Textedit (Frame parent)
{
  Init(parent);
}

Textedit::Textedit (const char *name)
{
  Init(0);
  Load(name);
}

Textedit::~Textedit()
{
}

void Textedit::Destroy()
{
  xv_destroy_safe (textsw);
}


void Textedit::XvMainLoop()
{
  xv_main_loop (frame);
}

int Textedit::Load (const char *filename)
{
  int status;
  xv_set (textsw, 
	TEXTSW_STATUS, &status,
	TEXTSW_FILE, filename, 
	TEXTSW_FIRST, 0,
	NULL);
  if (frame) 
    xv_set (frame,
          FRAME_LABEL, filename,
          NULL);
  return status;
}

int Textedit::Save()
{
  return textsw_save (textsw, 0, 0);
}

int Textedit::Modified()
{
  return xv_get (textsw, TEXTSW_MODIFIED);
}

void Textedit::Reset()
{
  textsw_reset (textsw, 0, 0);
}

void Textedit::SetNotifyProc (TextEdNotify proc, void *cd)
{
  notify = proc; 
  client_data = cd;
}

void Textedit::Notify(Textsw self, Attr_avlist attributes)
{
  int pass_on = TRUE;
  if (notify) pass_on = notify (this, self, attributes, client_data);
  if (pass_on) textsw_default_notify (textsw, attributes);
}

