
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/seln.h>


// ----- Input a single line of text in a nice tiny window: -------------------

int InputString
	(Frame owner,         // your base frame 
	 const char *header,  // window title
	 const char *label,   // promt
	 char *string);       // input and output, 200 characters max.

// Result: 1="The string has been comitted (OK)". 
// 0=The user canceled the edit, 'string' was not changed.


// ----- Text editor in a window class: ---------------------------------------

class Textedit;

typedef int (*TextEdNotify) (Textedit *, Textsw, Attr_avlist, void *); 
// Parameters: The Textedit object, the text subwindow (XView object), the
// attribute value list (handle with care!!), the client_data.
 

class Textedit
{
public:
  Textedit (); // create own frame
  Textedit (Frame parent); // become child of this frame
  Textedit (const char *filename); // create and load
  ~Textedit ();

  void XvMainLoop();

  int Save(); // 0=ok
  int Load (const char *filename); // 0=ok
  int Modified ();
  void Reset ();

  void Destroy (); // manually destroy text subwindow

  void SetNotifyProc (TextEdNotify proc, void *client_data);
  // Install callback procedure for important events in the text window.
  // Refer to XView programming manual for details. See below for a
  // quick example.

  Textsw GetTextsw () {return textsw;}
  
private:
  void Init(Frame parent);
  void Notify (Textsw self, Attr_avlist attributes);
  Frame frame;
  Textsw textsw;
  TextEdNotify notify;
  void *client_data;
};


// EXAMPLE: how to use the notification callback procedure:

/*
int MyTexteditCallback (Textedit *t, Textsw ts, Attr_avlist attributes,
                        void *client_data)
{
  int pass_on = TRUE; // pass the event to the text subwindow's default proc
  Attr_avlist attrs;
 
  for (attrs = attributes; *attrs; attrs = attr_next(attrs))
  {
    switch ((Textsw_action)(*attrs))
    {
      case TEXTSW_ACTION_LOADED_FILE:
        cout << "Textedit loaded file " << (char *)attrs[1] << "\n";
        pass_on = TRUE;
        break;
      default:
        pass_on = TRUE;
        break;
    }    
  }
  return pass_on;
}
*/

// The client_data may be used to store the pointer to an arbitrary
// application context, e.g. a syntactic object etc.

