// yytypes.h
// Common header file for CollageSystem scanner and parser
// Nils Schwabe 4/94

#include <stdio.h>
#include <setjmp.h>
#include <point.h>

// Types
// -----

// Any scanned number may be used as integer or real:
typedef struct 
{
  int i;
  double r;
} NumberRec;


#if 0
typedef struct 
{
  double x, y;
} PointRec;
#endif

// Extern variables
// ----------------

extern FILE *yyin;           // LEX
  // This must be changed for input from file. Initially set to stdin.

extern int yylineno;         // LEX/YACC
  // Written by scanner, read by parser for error output.

extern char yytextbuf[256]; // defined in scanner
  // used for copying parts of yytext that are then used by the parser

extern jmp_buf csjmpbuf; // must be defined by caller (envi, ...)
  // The parser jumps to this location in case of parse errors with
  // a result of -1. The error message can be found in 'yytextbuf'.


// Function prototypes
// -------------------

int ScanCString ();          // colgram.l
int yylex();                 // LEX
void yyrestart (FILE *);     // LEX
void yyerror (char *);       // colgram.y
int yyparse();               // BISON


