/*
 * @(#)DerivationResult.java
 * 
 */

package collage.generic;

import openstar.generic.Model;
import collage.kernel.*;

/**
 * A <em>derivation result</em> consists primarily of the list
 * of generated collages obtained by applying a derivation to a 
 * collage grammar.
 *
 * @version 16 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class DerivationResult extends Model
{

/** The list of collages that constitute this model. */
protected CollageList collageList;

/** The environment in which the collages are generated. */
protected Envi envi;


public DerivationResult(Envi envi) {
	this.envi = envi;
	// initialize with an empty list:
	this.collageList = new CollageList(); 
}


public Envi getEnvi() {
	return envi;
}


public void setCollageList(CollageList collageList) {
	if (collageList != this.collageList) {
		this.collageList = collageList;
		setModelChanged();
	}
}


public CollageList getCollageList() {
	return collageList;
}

} // class DerivationResult
