/*
 * @(#)DerivationResultSelection.java
 * 
 */

package collage.generic;

import openstar.generic.ModelSelection;
import collage.kernel.*;

/**
 * A <em>derivation result selection</em> is used to navigate through
 * the collages generated by a concrete derivation in a collage grammar.
 *
 * @version 16 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class DerivationResultSelection extends ModelSelection
{

/** The current position within the list of collages. */
protected int index;

/** This index indicates that no collage is currently selected. */
static public final int NONE_SELECTED = -1;


public DerivationResultSelection(DerivationResult result) {
	super(result);
	this.index = NONE_SELECTED;
}


public DerivationResult getResult() {
	return (DerivationResult)getModel();
}


public void setIndex(int index) {
	if (this.index != index) {
		this.index = index;
		fireModelSelection();
	}
}


public int getIndex() {
	return index;
}


} // class DerivationResultSelection

