/*
 * @(#)Display.java
 * 
 */

package collage.generic;

/**
 * CollageSystem display interface.
 * <p>
 * A <em>display</em> is a special type of view that is automatically
 * registered as a listener at a <code>DerivationResult</code> and,
 * optionally, a <code>DerivationResultSelection</code>. Deregistration
 * is usually also done by the same controller.
 * <p>
 * The purpose of a display is to generate output
 * for the results of a derivation and, optionally, to be recognizant of 
 * model selection changes.
 *
 * @version 18 Jun 1997
 * @author 	Nils Schwabe
 */ 
public interface Display extends openstar.generic.ModelChangeListener
{

/** Sets the name of this <code>Display</code> instance. */
public void setName(String name);

/** Gets the name of this <code>Display</code> instance. */
public String getName();

} // interface Display

