/*
 * @(#)DisplayFactory.java
 * 
 */

package collage.generic;

import openstar.generic.*;

/**
 * Display factory base class.
 *
 */
public abstract class DisplayFactory extends Factory
{

protected final String NAME = "name";


/** 
 * Implements the support for testing the "name" parameter. 
 * <p> 
 * Note: A defined name parameter must still be passed to the
 * concrete display object in the create() method of the derived
 * Display factory class.  
 */
public int newParam(String name, Object value) {

	if (name.equals(NAME)) {
		if (! (value instanceof String)) {
			return Factory.ERR_WRONG_TYPE;
		}
	}
	return super.newParam(name, value);
}


/**
 * Creates a new display instance. All concrete factory classes must
 * implement this method.
 * <p>
 * All objects created from descendants of this factory class must
 * return <code>Display</code>-objects. However, this cannot be
 * enforced at compile-time due to the generic character of the
 * factory mechanism.
 */
abstract public Object create();


} // class DisplayFactory

 
 
