/*
 * @(#)Envi.java
 * 
 */

package collage.generic;

import openstar.generic.*;
import openstar.util.*;
import collage.kernel.*;

/**
 * A Collage grammar environment, including the grammar itself and a
 * set of arbitrary parameters.
 * <p>
 * This class represents one of (at least) two primary <em>models</em>
 * within the CollageSystem. The other important model is represented
 * by the class <code>DerivationResult</code>.
 *
 * @version 11 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class Envi extends Model
{

/** A set of parameters */
protected ParamSet paramSet;

/** The parsed/generated collage grammar */
protected Grammar cg;

/** The parsed/generated derivation table */
protected Table derivationTable;

/** The parsed/generated table info list */
protected TableInfoList tableInfoList;

/** The list of defined displays */
protected TypedList displays;

/** Parser error message */	
protected String errorMsg;


public Envi() {
	doReset();
}

private void doReset() {
	paramSet = new ParamSet();
	cg = new Grammar();
	derivationTable = new Table();
	tableInfoList = new TableInfoList();
	displays = new TypedList("collage.generic.Display", true);
	// Default parameters:
	paramSet.put("dimensions", new Integer(2));
}


/**
 * Reset the environment.
 */
public void reset(boolean notifyListeners) {
	doReset();
	if (notifyListeners) {
		setModelChanged();
	}
}


public void setParamSet(ParamSet paramSet) {
	if (paramSet != this.paramSet) {
		this.paramSet = paramSet;
		setModelChanged();
	}
}

public ParamSet getParamSet() {
	return paramSet;
}


public void setGrammar(Grammar grammar) {
	if (grammar != cg) {
		this.cg = grammar;
		setModelChanged();
	}
}

public Grammar getGrammar() {
	return cg;
}


public void setTable(Table table) {
	if (this.derivationTable != table) {
		this.derivationTable = table;
		setModelChanged();
	}
}


public Table getTable() {
	return derivationTable;
}


public void setTableInfoList(TableInfoList tableInfoList) {
	if (this.tableInfoList != tableInfoList) {
		this.tableInfoList = tableInfoList;
		setModelChanged();
	}
}


public TableInfoList getTableInfoList() {
	return tableInfoList;
}


public void setDisplays(TypedList displays) {
	if (this.displays != displays) {
		this.displays = displays;
		setModelChanged();
	}
}


public TypedList getDisplays() {
	return displays;
}

	

public void setErrorMsg(String errorMsg) {
	if (this.errorMsg != errorMsg) {
		this.errorMsg = errorMsg;
		setModelChanged();
	}
}


public String getErrorMsg() {
	return errorMsg;
}


} // class Envi


